/*
 * Decompiled with CFR 0.152.
 */
package se.pureit.swing.icons;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconFactory {
    private static IconFactory instance = new IconFactory();
    private final HashMap images = new HashMap();
    private final HashMap icons = new HashMap();
    private final Component component = new Component(){};
    private final MediaTracker tracker = new MediaTracker(this.component);

    public static IconFactory getInstance() {
        return instance;
    }

    protected IconFactory() {
        instance = this;
    }

    public Icon getIcon(String string) {
        Icon icon = (Icon)this.icons.get(string);
        if (icon != null) {
            return icon;
        }
        Image image = this.getImage(string);
        if (image != null) {
            icon = new ImageIcon(image);
            this.icons.put(string, icon);
            return icon;
        }
        return null;
    }

    public Image getImage(String string) {
        return this.doGetImage(string, true);
    }

    public Image getImage(String string, boolean bl) {
        return this.doGetImage(string, bl);
    }

    public Image getImage(String string, Dimension dimension) {
        Image image = this.getImage(string);
        image = image.getScaledInstance(dimension.width, dimension.height, 1);
        return image;
    }

    protected Image doGetImage(String string) {
        return this.doGetImage(string, true);
    }

    protected Image doGetImage(String string, boolean bl) {
        Image image;
        if (bl && (image = (Image)this.images.get(string)) != null) {
            return image;
        }
        InputStream inputStream = this.getInputStream(string);
        image = inputStream != null ? this.loadImageFromStream(inputStream) : Toolkit.getDefaultToolkit().getImage(string);
        if (image == null) {
            return null;
        }
        if (bl) {
            this.loadImage(image);
            this.images.put(string, image);
        }
        return image;
    }

    InputStream getInputStream(String string) {
        return this.getClass().getResourceAsStream(string);
    }

    private Image loadImageFromStream(InputStream inputStream) {
        byte[] byArray = this.getImageBytes(inputStream);
        if (byArray == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }

    private byte[] getImageBytes(InputStream inputStream) {
        byte[] byArray = null;
        try {
            int n2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byArray = new byte[1024];
            while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length == 0) {
                System.err.println("warning: image data is zero-length");
                return null;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return null;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage(Image image) {
        MediaTracker mediaTracker = this.tracker;
        synchronized (mediaTracker) {
            this.tracker.addImage(image, 0);
            try {
                this.tracker.waitForID(0, 5000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                System.out.println("INTERRUPTED while loading Image!!!");
            }
            this.tracker.removeImage(image, 0);
        }
    }
}

