/*
 * Decompiled with CFR 0.152.
 */
package se.pureit.swing.icons;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import se.pureit.swing.icons.AbstractAnimatedIcon;

public class SpinningDial
extends AbstractAnimatedIcon {
    private static final int MIN_ALPHA = 32;
    private static final int DEFAULT_SIZE = 32;
    private static final int SPOKES = 16;
    public static final int SPIN_INTERVAL = 62;
    private int w;
    private int h;
    private Image[] frames;

    public SpinningDial() {
        this(32, 32);
    }

    public SpinningDial(int n2, int n3) {
        this(n2, n3, 16);
    }

    public SpinningDial(int n2, int n3, int n4) {
        super(n4, 62);
        this.w = n2;
        this.h = n3;
        this.frames = new Image[this.getFrameCount()];
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    protected float getStrokeWidth(int n2) {
        return (float)n2 / 16.0f;
    }

    @Override
    protected void paintFrame(Component component, Graphics graphics, int n2, int n3) {
        int n4 = this.getFrame();
        if (this.frames[n4] == null) {
            int n5 = this.getIconWidth();
            int n6 = this.getIconHeight();
            int n7 = Math.min(n5, n6);
            BufferedImage bufferedImage = component != null ? component.getGraphicsConfiguration().createCompatibleImage(n5, n6, 3) : new BufferedImage(n5, n6, 2);
            Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n5, n6);
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n8 = 256;
            float f2 = this.getStrokeWidth(256);
            float f3 = 0.6f;
            graphics2D.setStroke(new BasicStroke(f2, 1, 1));
            graphics2D.translate((float)n5 / 2.0f, (float)n6 / 2.0f);
            float f4 = (float)n7 / 256.0f;
            graphics2D.scale(f4, f4);
            int n9 = 255;
            int n10 = 127 - (int)(f2 / 2.0f);
            int n11 = this.getFrameCount();
            for (int i2 = 0; i2 < n11; ++i2) {
                double d2 = Math.cos(Math.PI * 2 - Math.PI * 2 * (double)(i2 - n4) / (double)n11);
                double d3 = Math.sin(Math.PI * 2 - Math.PI * 2 * (double)(i2 - n4) / (double)n11);
                int n12 = (int)((double)((float)n10 * f3) * d2);
                int n13 = (int)((double)n10 * d2);
                int n14 = (int)((double)((float)n10 * f3) * d3);
                int n15 = (int)((double)n10 * d3);
                graphics2D.setColor(new Color(0, 0, 0, Math.min(255, n9)));
                graphics2D.drawLine(n12, n14, n13, n15);
                n9 = Math.max(32, n9 * 3 / 4);
            }
            graphics2D.dispose();
            this.frames[n4] = bufferedImage;
        }
        graphics.drawImage(this.frames[n4], n2, n3, null);
    }

    public String toString() {
        return "SpinningDial(" + this.getIconWidth() + "x" + this.getIconHeight() + ")";
    }
}

