/*
 * Decompiled with CFR 0.152.
 */
package se.pureit.swing.icons;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Icon;
import se.pureit.A.B.A;
import se.pureit.swing.icons.IconFactory;

public class StdIconFactory {
    private static final String LOGO = new String(A.\u0101(StdIconFactory.class, "icons.logo"));
    private static final String FILETYPES = new String(A.\u0101(StdIconFactory.class, "icons.filetypes"));
    public static final int SMALL = 1;
    public static final int LARGE = 2;
    private static String currentIconCollection;
    private static int preferredSize;
    private static boolean printErrorsToOut;
    protected static String ixIconRootDirectory;
    protected static String ixSmallIconsDirectory;
    protected static String ixLargeIconsDirectory;
    protected static String ixSmallIconsPath;
    protected static String ixLargeIconsPath;
    protected static String ix2IconRootDirectory;
    protected static String ix2SmallIconsDirectory;
    protected static String ix2LargeIconsDirectory;
    protected static String ix2SmallIconsPath;
    protected static String ix2LargeIconsPath;
    private static String currentSmallIconsPath;
    private static String currentLargeIconsPath;
    private static final String BLANK_ICON_NAME = "Blank";
    protected static HashMap iconMap;
    static ArrayList al;

    public static void setIconCollection(String string) {
        currentIconCollection = string;
        ixIconRootDirectory = StdIconFactory.getText("icons.ix.rootdir");
        ixSmallIconsDirectory = StdIconFactory.getText("icons.ix.small");
        ixLargeIconsDirectory = StdIconFactory.getText("icons.ix.large");
        ixSmallIconsPath = ixIconRootDirectory + ixSmallIconsDirectory;
        ixLargeIconsPath = ixIconRootDirectory + ixLargeIconsDirectory;
        ix2IconRootDirectory = StdIconFactory.getText("icons.ix2.rootdir");
        ix2SmallIconsDirectory = StdIconFactory.getText("icons.ix2.small");
        ix2LargeIconsDirectory = StdIconFactory.getText("icons.ix2.large");
        ix2SmallIconsPath = ix2IconRootDirectory + ix2SmallIconsDirectory;
        ix2LargeIconsPath = ix2IconRootDirectory + ix2LargeIconsDirectory;
        if (currentIconCollection.equals("ix")) {
            currentSmallIconsPath = ixSmallIconsPath;
            currentLargeIconsPath = ixLargeIconsPath;
        } else if (currentIconCollection.equals("ix2")) {
            currentSmallIconsPath = ix2SmallIconsPath;
            currentLargeIconsPath = ix2LargeIconsPath;
        }
    }

    public static String getIconCollection() {
        return currentIconCollection;
    }

    public static void setPreferredSize(int n2) {
        preferredSize = n2;
    }

    public static int getPreferredSize() {
        return preferredSize;
    }

    public static void setPrintErrors(boolean bl) {
        printErrorsToOut = bl;
    }

    public static void setIconFile(String string) {
        try {
            Properties properties = new Properties();
            properties.load(StdIconFactory.class.getResourceAsStream(string));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = properties.get(object);
                if (object == null || object2 == null) continue;
                hashMap.put(((String)object).toLowerCase(), object2);
            }
            iconMap = hashMap;
        }
        catch (IOException iOException) {
            System.err.println("StdIconHandler: " + iOException);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("StdIconHandler: " + nullPointerException + " when loading: " + string);
            nullPointerException.printStackTrace();
        }
    }

    public static Icon getIconFromCollection(String string) {
        return StdIconFactory.getIconFromCollection(string, preferredSize);
    }

    public static Icon getIconFromCollection(String string, int n2) {
        String string2;
        String string3 = null;
        Icon icon = null;
        if (n2 == 2) {
            string3 = StdIconFactory.getLargeIconName(string);
            icon = StdIconFactory.getIconByName(string3);
            if (icon == null) {
                string3 = StdIconFactory.getSmallIconName(string);
                icon = StdIconFactory.getIconByName(string3);
            }
        } else if (n2 == 1 && (icon = StdIconFactory.getIconByName(string3 = StdIconFactory.getSmallIconName(string))) == null) {
            string3 = StdIconFactory.getLargeIconName(string);
            icon = StdIconFactory.getIconByName(string3);
        }
        if ((string2 = StdIconFactory.getFileName(string)) != null && string2.startsWith("null")) {
            return null;
        }
        return icon != null ? icon : StdIconFactory.getJavaIcon(BLANK_ICON_NAME);
    }

    public static InputStream getIconStreamFromCollection(String string, int n2) {
        IconFactory iconFactory = IconFactory.getInstance();
        String string2 = null;
        InputStream inputStream = null;
        if (n2 == 2) {
            string2 = StdIconFactory.getLargeIconName(string);
            inputStream = iconFactory.getInputStream(string2);
            if (inputStream == null) {
                string2 = StdIconFactory.getSmallIconName(string);
                inputStream = iconFactory.getInputStream(string2);
            }
        } else if (n2 == 1 && (inputStream = iconFactory.getInputStream(string2 = StdIconFactory.getSmallIconName(string))) == null) {
            string2 = StdIconFactory.getLargeIconName(string);
            inputStream = iconFactory.getInputStream(string2);
        }
        return inputStream != null ? inputStream : iconFactory.getInputStream("GenericObject");
    }

    public static InputStream getIconStreamFromCollection(String string) {
        return StdIconFactory.getIconStreamFromCollection(string, preferredSize);
    }

    private static Icon getIconByName(String string) {
        if (string != null) {
            Icon icon = StdIconFactory.getIcon(string);
            if (icon == null && printErrorsToOut && !string.endsWith("Blank.png") && !string.endsWith("Blank.gif")) {
                System.out.println("StdIconFactory.getIconByName() - iconName: '" + string + "' not found!");
            }
            return icon;
        }
        return null;
    }

    public static Icon getJavaIcon(String string) {
        String string2 = currentIconCollection;
        StdIconFactory.setIconCollection("ix");
        Icon icon = StdIconFactory.getIcon(string);
        StdIconFactory.setIconCollection(string2);
        return icon;
    }

    public static Icon getIxIcon(String string) {
        String string2 = currentIconCollection;
        StdIconFactory.setIconCollection("ix");
        Icon icon = StdIconFactory.getIcon(string);
        StdIconFactory.setIconCollection(string2);
        return icon;
    }

    public static Icon getIx2Icon(String string) {
        String string2 = currentIconCollection;
        StdIconFactory.setIconCollection("ix2");
        Icon icon = StdIconFactory.getIcon(string);
        StdIconFactory.setIconCollection(string2);
        return icon;
    }

    public static Icon getIcon(String string) {
        IconFactory iconFactory = IconFactory.getInstance();
        if (string.endsWith(".gif") || string.endsWith(".png")) {
            Icon icon = iconFactory.getIcon(string);
            if (StdIconFactory.isIconLoaded(icon)) {
                return icon;
            }
            return null;
        }
        Icon icon = iconFactory.getIcon(currentSmallIconsPath + string + ".png");
        if (StdIconFactory.isIconLoaded(icon)) {
            return icon;
        }
        icon = iconFactory.getIcon(currentSmallIconsPath + string + ".gif");
        if (StdIconFactory.isIconLoaded(icon)) {
            return icon;
        }
        if (currentIconCollection.equals("ix") ? StdIconFactory.isIconLoaded(icon = iconFactory.getIcon(ixSmallIconsPath + string + ".png")) : currentIconCollection.equals("ix2") && StdIconFactory.isIconLoaded(icon = iconFactory.getIcon(ix2SmallIconsPath + string + ".png"))) {
            return icon;
        }
        icon = iconFactory.getIcon(FILETYPES + string + ".gif");
        if (StdIconFactory.isIconLoaded(icon)) {
            return icon;
        }
        icon = iconFactory.getIcon(LOGO + string + ".gif");
        if (StdIconFactory.isIconLoaded(icon)) {
            return icon;
        }
        return icon;
    }

    public static Image getImage(String string) {
        Image image;
        IconFactory iconFactory = IconFactory.getInstance();
        if ((string.endsWith(".gif") || string.endsWith(".png")) && StdIconFactory.isImageLoaded(image = iconFactory.getImage(string))) {
            return image;
        }
        image = iconFactory.getImage(currentSmallIconsPath + string + ".gif");
        if (StdIconFactory.isImageLoaded(image)) {
            return image;
        }
        image = iconFactory.getImage(currentSmallIconsPath + string + ".png");
        if (StdIconFactory.isImageLoaded(image)) {
            return image;
        }
        image = iconFactory.getImage(FILETYPES + string + ".gif");
        if (StdIconFactory.isImageLoaded(image)) {
            return image;
        }
        image = iconFactory.getImage(LOGO + string + ".gif");
        if (StdIconFactory.isImageLoaded(image)) {
            return image;
        }
        return image;
    }

    public static String getSmallIconName(String string) {
        String string2 = StdIconFactory.getFileName(string);
        if (string2 != null) {
            String string3 = currentSmallIconsPath + string2;
            return string3;
        }
        return null;
    }

    public static String getLargeIconName(String string) {
        String string2 = StdIconFactory.getFileName(string);
        if (string2 != null) {
            String string3 = currentLargeIconsPath + string2;
            return string3;
        }
        return null;
    }

    public static void printNotLoadIcons() {
        for (String string : iconMap.keySet()) {
            if (al.contains(string)) continue;
            System.out.println(string);
        }
    }

    protected static String getFileName(String string) {
        String string2 = null;
        if (string.startsWith("icons.") || iconMap == null) {
            string2 = StdIconFactory.getText(string);
        } else {
            string2 = (String)iconMap.get(string = string.toLowerCase());
            if (string2 != null && !al.contains(string)) {
                al.add(string);
            }
        }
        if (string2 == null) {
            if (printErrorsToOut) {
                System.out.println("StdIconFactory.getFileName() - actionId: '" + string + "' not found!");
            }
            return null;
        }
        int n2 = string2.indexOf(",");
        if (n2 < 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3 = string3.trim();
            switch (n3) {
                case 0: {
                    if (!currentIconCollection.equals("ix")) break;
                    return string3 + ".png";
                }
                case 1: {
                    if (!currentIconCollection.equals("ix2")) break;
                    return string3 + ".png";
                }
            }
            ++n3;
        }
        return null;
    }

    private static boolean isIconLoaded(Icon icon) {
        return icon != null && icon.getIconWidth() != -1 && icon.getIconHeight() != -1;
    }

    private static boolean isImageLoaded(Image image) {
        return image != null && image.getWidth(null) != -1 && image.getHeight(null) != -1;
    }

    private static String getText(String string) {
        return A.\u0101(StdIconFactory.class, string);
    }

    static {
        printErrorsToOut = true;
        StdIconFactory.setIconCollection("ix");
        StdIconFactory.setPreferredSize(1);
        al = new ArrayList();
    }
}

