/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.util.JavaVersion;
import de.javasoft.util.OS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class Popup
extends javax.swing.Popup {
    public static final String POPUP_BACKGROUND = "POPUP_BACKGROUND";
    public static final String POPUP_LIGHTWEIGHT = "POPUP_LIGHTWEIGHT";
    private Component contents;
    private int x;
    private int y;
    private javax.swing.Popup popup;
    private Container heavyWeightContainer;
    private boolean lightWeight;

    public Popup(Component component, Component component2, int n, int n2, javax.swing.Popup popup) {
        this.contents = component2;
        this.popup = popup;
        this.x = n;
        this.y = n2;
        Container container = component2.getParent();
        ((JComponent)container).putClientProperty(POPUP_BACKGROUND, null);
        ((JComponent)container).putClientProperty(POPUP_LIGHTWEIGHT, null);
        if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
            ((JComponent)container).setDoubleBuffered(false);
        }
        this.lightWeight = true;
        while (container != null) {
            if (container instanceof JWindow || container instanceof Panel || container instanceof Window) {
                this.heavyWeightContainer = container;
                this.lightWeight = false;
                break;
            }
            container = container.getParent();
        }
        this.internalFrameCursorBugfix(component);
        if (this.heavyWeightContainer != null && OS.getCurrentOS() == OS.Mac && !UIManager.getBoolean("Synthetica.popup.osShadow.enabled")) {
            this.heavyWeightContainer.setBackground(new Color(0x1000000, true));
            this.heavyWeightContainer.setBackground(new Color(0, true));
            if (this.heavyWeightContainer instanceof JWindow) {
                ((JWindow)this.heavyWeightContainer).getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
            }
        }
    }

    private void internalFrameCursorBugfix(Component component) {
        if (component != null && component instanceof JInternalFrame) {
            Container container = ((JInternalFrame)component).getTopLevelAncestor();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            if (container instanceof JFrame) {
                ((JFrame)container).getGlassPane().setCursor(cursor);
                ((JFrame)container).getGlassPane().setVisible(false);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setCursor(cursor);
                ((JWindow)container).getGlassPane().setVisible(false);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setCursor(cursor);
                ((JDialog)container).getGlassPane().setVisible(false);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setCursor(cursor);
                ((JApplet)container).getGlassPane().setVisible(false);
            }
        }
    }

    public void hide() {
        Container container;
        if (this.heavyWeightContainer instanceof Window && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.fade-out.enabled", this.contents)) {
            int n = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-out.delay", this.contents, 25);
            int n2 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-out.duration", this.contents, 150);
            WindowFader windowFader = new WindowFader((Window)this.heavyWeightContainer, this.popup, n, n2, false, true);
            windowFader.start();
        } else {
            this.popup.hide();
        }
        Container container2 = container = this.contents == null ? null : this.contents.getParent();
        if (container instanceof JComponent) {
            ((JComponent)container).putClientProperty(POPUP_BACKGROUND, null);
        }
        if (this.heavyWeightContainer != null) {
            this.heavyWeightContainer = null;
            if (JavaVersion.JAVA5) {
                while (container != null) {
                    if (container instanceof JFrame) {
                        ((JFrame)container).update(container.getGraphics());
                    }
                    container = container.getParent();
                }
            }
        }
        this.contents = null;
        this.popup = null;
    }

    public javax.swing.Popup getDelegate() {
        return this.popup;
    }

    public void show() {
        boolean bl;
        boolean bl2 = bl = this.contents instanceof JPopupMenu && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.blur.enabled", this.contents);
        if (bl && this.heavyWeightContainer == null) {
            this.heavyWeightContainer = this.contents.getParent();
        }
        if (this.heavyWeightContainer == null || !SyntheticaLookAndFeel.getBoolean("Synthetica.popupRobot.enabled", this.contents.getParent(), true)) {
            this.popup.show();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Popup.this.showPopup(bl);
            }
        });
    }

    private void showPopup(boolean bl) {
        boolean bl2;
        if (this.heavyWeightContainer == null) {
            return;
        }
        if (JavaVersion.JAVA7U8_OR_ABOVE && OS.getCurrentOS() == OS.Mac && this.contents instanceof JToolTip) {
            SyntheticaLookAndFeel.setChildrenOpaque(this.heavyWeightContainer, false);
        }
        if ((bl2 = SyntheticaLookAndFeel.getBoolean("Synthetica.popupRobot.enabled", this.contents.getParent(), true)) && (OS.getCurrentOS() != OS.Mac && (SyntheticaLookAndFeel.isWindowOpacityEnabled(null) || bl) || OS.getCurrentOS() == OS.Mac && bl)) {
            ((JComponent)this.contents.getParent()).putClientProperty(POPUP_BACKGROUND, this.snapshot());
            ((JComponent)this.contents.getParent()).putClientProperty(POPUP_LIGHTWEIGHT, this.lightWeight);
        }
        if (this.heavyWeightContainer instanceof Window && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.fade-in.enabled", this.contents)) {
            int n = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-in.delay", this.contents, 25);
            int n2 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-in.duration", this.contents, 200);
            WindowFader windowFader = new WindowFader((Window)this.heavyWeightContainer, null, n, n2, true, false);
            windowFader.start();
        }
        this.popup.show();
        if (this.heavyWeightContainer instanceof Window && !SyntheticaLookAndFeel.isWindowOpacityEnabled(null) && !bl) {
            SyntheticaLookAndFeel.setWindowOpaque((Window)this.heavyWeightContainer, false);
        }
    }

    private BufferedImage snapshot() {
        BufferedImage bufferedImage = null;
        try {
            Robot robot = new Robot();
            Dimension dimension = this.heavyWeightContainer.getPreferredSize();
            if (dimension.width > 0 && dimension.height > 0) {
                Rectangle rectangle = new Rectangle(this.x, this.y, dimension.width, dimension.height);
                bufferedImage = robot.createScreenCapture(rectangle);
            }
        }
        catch (AccessControlException accessControlException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private static class WindowFader
    extends Timer {
        private static ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowFader windowFader = (WindowFader)actionEvent.getSource();
                float f = (float)windowFader.counter / windowFader.repeats;
                this.setWindowOpacity(windowFader.window, windowFader.fadein ? f : 1.0f - f);
                if ((float)windowFader.counter == windowFader.repeats) {
                    windowFader.counter = 0;
                    windowFader.stop();
                    if (windowFader.hidePopup) {
                        windowFader.popup.hide();
                        this.setWindowOpacity(windowFader.window, 1.0f);
                    }
                    windowFader.popup = null;
                    windowFader.window = null;
                } else {
                    WindowFader windowFader2 = windowFader;
                    windowFader2.counter = windowFader2.counter + 1;
                }
            }

            private void setWindowOpacity(Window window, float f) {
                if (JavaVersion.JAVA6U10_OR_ABOVE) {
                    if (JavaVersion.JAVA6U10_OR_ABOVE && !JavaVersion.JAVA7) {
                        try {
                            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                            Method method = clazz.getMethod("setWindowOpacity", Window.class, Float.TYPE);
                            method.invoke(null, window, Float.valueOf(f));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        try {
                            Class<?> clazz = Class.forName("java.awt.Window");
                            Method method = clazz.getMethod("setOpacity", Float.TYPE);
                            method.invoke((Object)window, Float.valueOf(f));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        };
        private Window window;
        private javax.swing.Popup popup;
        private boolean fadein;
        private boolean hidePopup;
        private float repeats;
        private int counter;

        public WindowFader(Window window, javax.swing.Popup popup, int n, int n2, boolean bl, boolean bl2) {
            super(0, listener);
            this.window = window;
            this.popup = popup;
            this.setDelay(n);
            this.repeats = n2 / n;
            this.fadein = bl;
            this.hidePopup = bl2;
        }
    }
}

