/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.TablePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.DefaultTableCellRenderer;

class SyntheticaHeaderRenderer5
extends DefaultTableCellRenderer
implements UIResource {
    private static final long serialVersionUID = -5043195354176641815L;
    private JTable table;
    private int column;

    SyntheticaHeaderRenderer5() {
        this.setHorizontalAlignment(SyntheticaLookAndFeel.getInt("Synthetica.tableHeader.horizontalAlignment", this, 10));
        this.setName("TableHeader.renderer");
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.table = jTable;
        this.column = n2;
        if (jTable != null && !bl2) {
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(jTable.getTableHeader(), Region.TABLE_HEADER);
            SynthContext synthContext = new SynthContext(jTable.getTableHeader(), Region.TABLE_HEADER, synthStyle, 0);
            Insets insets = synthStyle.getInsets(synthContext, null);
            Border border = this.getBorder();
            Border border2 = UIManager.getBorder("TableHeader.cellBorder");
            if (border2 != null) {
                if (border != border2) {
                    this.setBorder(border2);
                }
            } else if (insets.equals(new Insets(0, 0, 0, 0))) {
                this.setBorder(noFocusBorder);
            } else {
                this.setBorder(new EmptyBorder(insets));
            }
        }
        this.setValue(object);
        return this;
    }

    public void paintComponent(Graphics graphics) {
        if (this.table != null) {
            boolean bl = false;
            int[] nArray = (int[])this.table.getClientProperty("SORTABLE_TABLE_SORTED_COLUMNS");
            Boolean bl2 = (Boolean)this.table.getClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND");
            if (nArray != null && bl2 != null && bl2.booleanValue()) {
                int[] nArray2 = nArray;
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray2[n2];
                    if (n3 == this.column) {
                        TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), graphics, 0, 0, this.getWidth(), this.getHeight(), 1);
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl) {
                TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), graphics, 0, 0, this.getWidth(), this.getHeight(), 0);
            }
        }
        super.paintComponent(graphics);
    }

    public boolean isOpaque() {
        Boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.tableHeader.opaque", this.table);
        return bl == null ? super.isOpaque() : bl.booleanValue();
    }
}

