/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainter;
import de.javasoft.util.JavaVersion;
import de.javasoft.util.OS;
import de.javasoft.util.java2d.DropShadow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaTitlePane
extends JPanel {
    private static final long serialVersionUID = -6164225719742333375L;
    private static final String BUTTON_ID = "Synthetica.buttonID";
    private JRootPane rootPane;
    private SyntheticaRootPaneUI rootPaneUI;
    private Window window;
    private Frame frame;
    private Dialog dialog;
    private JButton menuButton;
    private JLabel titleLabel;
    private JLabel menuBarLabel;
    private Container userComponentContainer;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private JPopupMenu systemMenu;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private WindowListener windowListener;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener rootPanePropertyChangeListener;
    private ContainerListener layeredPaneContainerListener;
    private ActionListener menuActionListener;
    private boolean selected = true;
    private boolean useMACStyle = false;
    private LayoutStyle layoutStyle;
    private JInternalFrame iFrameDelegate = new JInternalFrame();

    public SyntheticaTitlePane(JRootPane jRootPane, BasicRootPaneUI basicRootPaneUI) {
        this.rootPane = jRootPane;
        this.rootPaneUI = (SyntheticaRootPaneUI)basicRootPaneUI;
        Container container = this.rootPane.getParent();
        Window window = this.window = container instanceof Window ? (Window)container : SwingUtilities.getWindowAncestor(container);
        if (this.window instanceof Frame) {
            this.frame = (Frame)this.window;
        } else if (this.window instanceof Dialog) {
            this.dialog = (Dialog)this.window;
        }
        String string = SyntheticaLookAndFeel.getString("Synthetica.rootPane.titlePane.layoutStyle", this.window);
        this.layoutStyle = string == null ? LayoutStyle.REGULAR : LayoutStyle.valueOf(string);
        this.useMACStyle = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.useMACStyleOnMAC", this.window, true);
        this.setOpaque(SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.opaque", this.window, true));
        if (!this.isOpaque() && !SyntheticaLookAndFeel.isWindowOpacityEnabled(this.window)) {
            this.setDoubleBuffered(false);
        }
        this.setLayout(new GridBagLayout());
        this.setName("RootPane.titlePane");
        this.closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SyntheticaTitlePane.this.close();
            }
        };
        int n = this.rootPane.getWindowDecorationStyle();
        boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.dialog.icon.enabled", this.window);
        if (n == 1 || bl) {
            this.iconifyAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SyntheticaTitlePane.this.iconify();
                }
            };
            this.restoreAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SyntheticaTitlePane.this.restore();
                }
            };
            this.maximizeAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SyntheticaTitlePane.this.maximize();
                }
            };
            this.menuButton = this.createTitlePaneButton("RootPane.titlePane.menuButton");
            this.menuButton.putClientProperty("doNotCancelPopup", new JComboBox().getClientProperty("doNotCancelPopup"));
            this.menuButton.setIcon(this.getIcon(this.rootPane));
            this.menuButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    String string = System.getProperty("os.name").toLowerCase();
                    if (mouseEvent.getClickCount() == 2 && string.contains("windows")) {
                        SyntheticaTitlePane.this.closeAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), "doubleClick"));
                    }
                }
            });
            this.systemMenu = new JPopupMenu();
            this.systemMenu.putClientProperty("Synthetica.popupMenu.toplevel", false);
            this.addMenuItems(this.systemMenu);
        }
        this.titleLabel = new JLabel(" ");
        this.titleLabel.setName("RootPane.title");
        this.titleLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.menuBarLabel = new JLabel(" ");
        this.menuBarLabel.setName("RootPane.menuBar");
        this.menuBarLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        boolean bl2 = this.showMenuBarInTitlePane();
        this.menuBarLabel.setVisible(bl2);
        if (bl2) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SyntheticaTitlePane.this.menuBarLabel.setPreferredSize(SyntheticaTitlePane.this.rootPane.getJMenuBar().getPreferredSize());
                }
            });
        }
        this.createButtons();
        this.updateLayoutStyle(n, bl);
        this.installListeners(this.rootPane);
        this.setComponentsActiveState(this.window.isActive());
        this.updateState();
    }

    public void updateLayoutStyle() {
        int n = this.rootPane.getWindowDecorationStyle();
        boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.dialog.icon.enabled", this.window);
        this.updateLayoutStyle(n, bl);
    }

    private void updateLayoutStyle(int n, boolean bl) {
        if (this.layoutStyle == LayoutStyle.REGULAR) {
            this.addControls(n, bl);
        } else if (this.layoutStyle == LayoutStyle.SECONDARYMENU) {
            this.menuBarLabel.setVisible(true);
            if (this.userComponentContainer == null) {
                this.userComponentContainer = new UserComponentContainer();
            }
            this.addControls_secondaryMenuLayout(n, bl);
        }
    }

    private void addControls(int n, boolean bl) {
        int n2 = this.getXGap();
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            this.add((Component)this.closeButton, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(n2), 0, 0));
            if (n == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(n2), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(n2), 0, 0));
            }
            this.add((Component)this.titleLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, this.getTitleLabelAlignment(), 2, this.getTitleLabelInsets(n2), 0, 0));
            this.add((Component)this.menuBarLabel, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 2, this.getMenuBarLabelInsets(n2), 0, 0));
            if (n == 1 || bl) {
                this.add((Component)this.menuButton, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(n2), 0, 0));
            }
        } else {
            if (n == 1 || bl) {
                this.add((Component)this.menuButton, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(n2), 0, 0));
            }
            this.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, this.getTitleLabelAlignment(), 2, this.getTitleLabelInsets(n2), 0, 0));
            this.add((Component)this.menuBarLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, this.getMenuBarLabelInsets(n2), 0, 0));
            if (n == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(n2), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(n2), 0, 0));
            }
            this.add((Component)this.closeButton, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(n2), 0, 0));
        }
    }

    private void addControls_secondaryMenuLayout(int n, boolean bl) {
        int n2 = this.getXGap();
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            this.add((Component)this.closeButton, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(n2), 0, 0));
            if (n == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(n2), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(n2), 0, 0));
            }
            this.add((Component)this.menuBarLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, this.getMenuBarLabelInsets(n2), 0, 0));
            this.add((Component)this.userComponentContainer, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 2, this.getUserComponentInsets(n2), 0, 0));
            if (n == 1 || bl) {
                this.add((Component)this.menuButton, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(n2), 0, 0));
            }
        } else {
            if (n == 1 || bl) {
                this.add((Component)this.menuButton, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(n2), 0, 0));
            }
            this.add((Component)this.menuBarLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, this.getMenuBarLabelInsets(n2), 0, 0));
            boolean bl2 = n == 1 && this.dialog == null;
            this.add((Component)this.userComponentContainer, new GridBagConstraints(1, 1, bl2 ? 4 : 2, 1, 1.0, 1.0, 10, 2, this.getUserComponentInsets(n2), 0, 0));
            if (bl2) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(n2), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(n2), 0, 0));
            }
            this.add((Component)this.closeButton, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(n2), 0, 0));
        }
    }

    public void setUserComponent(JComponent jComponent) {
        if (this.userComponentContainer != null) {
            this.userComponentContainer.removeAll();
            this.userComponentContainer.add(jComponent);
        }
    }

    public JComponent getUserComponent() {
        return this.userComponentContainer == null || this.userComponentContainer.getComponentCount() == 0 ? null : (JComponent)this.userComponentContainer.getComponent(0);
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    private void installListeners(JRootPane jRootPane) {
        this.windowListener = new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                if (SyntheticaTitlePane.this.rootPane.getWindowDecorationStyle() == 1 && SyntheticaTitlePane.this.dialog == null) {
                    SyntheticaTitlePane.this.updateToggleButton();
                    SyntheticaTitlePane.this.updateState();
                }
            }

            public void windowStateChanged(WindowEvent windowEvent) {
                SyntheticaTitlePane.this.updateToggleButton();
                SyntheticaTitlePane.this.updateState();
            }

            public void windowActivated(WindowEvent windowEvent) {
                SyntheticaTitlePane.this.setActive(true);
                SyntheticaTitlePane.this.selected = true;
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                SyntheticaTitlePane.this.setActive(false);
                SyntheticaTitlePane.this.selected = false;
            }
        };
        this.window.addWindowListener(this.windowListener);
        this.window.addWindowStateListener((WindowStateListener)((Object)this.windowListener));
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("resizable".equals(string)) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    SyntheticaTitlePane.this.toggleButton.setEnabled(bl);
                    SyntheticaTitlePane.this.systemMenu.removeAll();
                    SyntheticaTitlePane.this.addMenuItems(SyntheticaTitlePane.this.systemMenu);
                } else if ("iconImage".equals(string) && SyntheticaTitlePane.this.menuButton != null) {
                    SyntheticaTitlePane.this.menuButton.setIcon(SyntheticaTitlePane.this.getIcon(SyntheticaTitlePane.this.rootPane));
                } else if ("title".equals(string)) {
                    SyntheticaTitlePane.this.repaint();
                } else if ("name".equals(string)) {
                    SyntheticaTitlePane.this.updateDefaults();
                }
            }
        };
        this.window.addPropertyChangeListener(this.propertyChangeListener);
        this.rootPanePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("Synthetica.dialog.iconImage".equals(propertyChangeEvent.getPropertyName()) && SyntheticaTitlePane.this.menuButton != null) {
                    SyntheticaTitlePane.this.menuButton.setIcon(SyntheticaTitlePane.this.getIcon((JRootPane)propertyChangeEvent.getSource()));
                }
            }
        };
        this.rootPane.addPropertyChangeListener(this.rootPanePropertyChangeListener);
        if (this.menuButton != null) {
            this.menuActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    if (SyntheticaTitlePane.this.systemMenu.isVisible()) {
                        SyntheticaTitlePane.this.systemMenu.setVisible(false);
                        return;
                    }
                    int n = SyntheticaTitlePane.this.getXGap();
                    int n2 = SyntheticaTitlePane.this.menuButton.getY() + SyntheticaTitlePane.this.menuButton.getHeight() + ((SyntheticaTitlePane)SyntheticaTitlePane.this).getTitleLabelInsets((int)n).bottom;
                    boolean bl2 = bl = SyntheticaTitlePane.this.useMACStyle && OS.getCurrentOS() == OS.Mac;
                    if (SyntheticaTitlePane.this.isRTL() && !bl || !SyntheticaTitlePane.this.isRTL() && bl) {
                        SyntheticaTitlePane.this.systemMenu.show(SyntheticaTitlePane.this, SyntheticaTitlePane.this.menuButton.getX() + SyntheticaTitlePane.this.menuButton.getWidth() - ((SyntheticaTitlePane)SyntheticaTitlePane.this).systemMenu.getPreferredSize().width + n, n2);
                    } else {
                        SyntheticaTitlePane.this.systemMenu.show(SyntheticaTitlePane.this, SyntheticaTitlePane.this.menuButton.getX() - n, n2);
                    }
                }
            };
            this.menuButton.addActionListener(this.menuActionListener);
        }
        this.layeredPaneContainerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                if (containerEvent.getChild() instanceof JMenuBar && SyntheticaTitlePane.this.showMenuBarInTitlePane()) {
                    JMenuBar jMenuBar = (JMenuBar)containerEvent.getChild();
                    SyntheticaTitlePane.this.menuBarLabel.setPreferredSize(jMenuBar.getPreferredSize());
                    SyntheticaTitlePane.this.menuBarLabel.setMinimumSize(jMenuBar.getPreferredSize());
                    SyntheticaTitlePane.this.menuBarLabel.setVisible(true);
                    ((JLayeredPane)containerEvent.getComponent()).setComponentZOrder(jMenuBar, 1);
                    MouseInputListener mouseInputListener = SyntheticaTitlePane.this.rootPaneUI.getMouseInputListener();
                    jMenuBar.addMouseListener(mouseInputListener);
                    jMenuBar.addMouseMotionListener(mouseInputListener);
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                if (containerEvent.getChild() instanceof JMenuBar) {
                    JMenuBar jMenuBar = (JMenuBar)containerEvent.getChild();
                    MouseInputListener mouseInputListener = SyntheticaTitlePane.this.rootPaneUI.getMouseInputListener();
                    jMenuBar.removeMouseListener(mouseInputListener);
                    jMenuBar.removeMouseMotionListener(mouseInputListener);
                    SyntheticaTitlePane.this.menuBarLabel.setVisible(false);
                }
            }
        };
        this.rootPane.getLayeredPane().addContainerListener(this.layeredPaneContainerListener);
    }

    void uninstallListeners(JRootPane jRootPane) {
        this.window.removeWindowListener(this.windowListener);
        this.window.removeWindowStateListener((WindowStateListener)((Object)this.windowListener));
        this.window.removePropertyChangeListener(this.propertyChangeListener);
        jRootPane.removePropertyChangeListener(this.rootPanePropertyChangeListener);
        jRootPane.getLayeredPane().removeContainerListener(this.layeredPaneContainerListener);
        if (this.menuButton != null) {
            this.menuButton.removeActionListener(this.menuActionListener);
        }
    }

    private void updateDefaults() {
        this.setOpaque(SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.opaque", this.window, true));
        int n = this.getXGap();
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.titleLabel);
        gridBagConstraints.insets = this.getTitleLabelInsets(n);
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        this.titleLabel.revalidate();
        gridBagConstraints = gridBagLayout.getConstraints(this.menuBarLabel);
        gridBagConstraints.insets = this.getMenuBarLabelInsets(n);
        gridBagLayout.setConstraints(this.menuBarLabel, gridBagConstraints);
        this.menuBarLabel.revalidate();
        if (this.menuButton != null) {
            this.menuButton.setIcon(this.getIcon(this.rootPane));
            gridBagConstraints = gridBagLayout.getConstraints(this.menuButton);
            gridBagConstraints.insets = this.getMenuButtonInsets(n);
            gridBagConstraints.anchor = this.getMenuButtonAlignment();
            gridBagLayout.setConstraints(this.menuButton, gridBagConstraints);
            this.menuButton.revalidate();
        }
        if (this.iconifyButton != null) {
            gridBagConstraints = gridBagLayout.getConstraints(this.iconifyButton);
            gridBagConstraints.insets = this.getIconifyButtonInsets(n);
            gridBagConstraints.anchor = this.getIconifyButtonAlignment();
            gridBagLayout.setConstraints(this.iconifyButton, gridBagConstraints);
            this.iconifyButton.revalidate();
        }
        if (this.toggleButton != null) {
            gridBagConstraints = gridBagLayout.getConstraints(this.toggleButton);
            gridBagConstraints.insets = this.getToggleButtonInsets(n);
            gridBagConstraints.anchor = this.getToggleButtonAlignment();
            gridBagLayout.setConstraints(this.toggleButton, gridBagConstraints);
            this.toggleButton.revalidate();
        }
        gridBagConstraints = gridBagLayout.getConstraints(this.closeButton);
        gridBagConstraints.insets = this.getCloseButtonInsets(n);
        gridBagConstraints.anchor = this.getCloseButtonAlignment();
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        this.closeButton.revalidate();
    }

    boolean showMenuBarInTitlePane() {
        return this.rootPane.getJMenuBar() != null && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.showMenuBarInTitlePane", this.window, false);
    }

    boolean clipMenuBarWidth() {
        return this.rootPane.getJMenuBar() != null && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.clipMenuBarWidth", this.window, false);
    }

    private int getXGap() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.gap", this.window, 4);
    }

    private Insets getTitleLabelInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.title.insets", (Component)this.window, new Insets(3, 0, 4, 0));
        return new Insets(insets.top, insets.left + n, insets.bottom, insets.right + n);
    }

    private Insets getMenuBarLabelInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.menuBar.insets", (Component)this.window, false);
        return new Insets(insets.top, insets.left + n, insets.bottom, insets.right + n);
    }

    private Insets getUserComponentInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.userComponent.insets", (Component)this.window, false);
        return new Insets(insets.top, insets.left + n, insets.bottom, insets.right + n);
    }

    private Insets getMenuButtonInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.menuButton.insets", (Component)this.window, false);
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            return new Insets(insets.top, insets.right, insets.bottom, insets.left + n);
        }
        return new Insets(insets.top, insets.left + n, insets.bottom, insets.right);
    }

    private Insets getIconifyButtonInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.iconifyButton.insets", (Component)this.window, false);
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            int n2 = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.iconifyButton.gap", this.window, 0);
            return new Insets(insets.top, insets.left + n2, insets.bottom, insets.right);
        }
        int n3 = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.iconifyButton.gap", this.window, 0);
        return new Insets(insets.top, insets.left, insets.bottom, insets.right + n3);
    }

    private Insets getToggleButtonInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.toggleButton.insets", (Component)this.window, false);
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            int n2 = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.toggleButton.gap", this.window, 0);
            return new Insets(insets.top, insets.left + n2, insets.bottom, insets.right);
        }
        int n3 = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.toggleButton.gap", this.window, n);
        return new Insets(insets.top, insets.left, insets.bottom, insets.right + n3);
    }

    private Insets getCloseButtonInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.closeButton.insets", (Component)this.window, false);
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            return new Insets(insets.top, insets.right + n, insets.bottom, insets.left);
        }
        return new Insets(insets.top, insets.left, insets.bottom, insets.right + n);
    }

    private int getMenuButtonAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.menuButton.alignment", this.window, 10);
    }

    private int getTitleLabelAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.title.alignment", this.window, 10);
    }

    private int getIconifyButtonAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.iconifyButton.alignment", this.window, 10);
    }

    private int getToggleButtonAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.toggleButton.alignment", this.window, 10);
    }

    private int getCloseButtonAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.closeButton.alignment", this.window, 10);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public Dimension getPreferredSize() {
        if (this.isTitlePaneEnabled()) {
            return super.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        if (this.isTitlePaneEnabled()) {
            return super.getMinimumSize();
        }
        return new Dimension(0, 0);
    }

    private boolean isTitlePaneEnabled() {
        boolean bl = this.rootPane.getClientProperty("Synthetica.titlePane.enabled") == null ? false : (Boolean)this.rootPane.getClientProperty("Synthetica.titlePane.enabled") == false;
        String string = String.valueOf(this.rootPane.getParent().getClass().getName()) + ".titlePane.enabled";
        return (UIManager.get(string) == null || UIManager.getBoolean(string)) && !bl;
    }

    private String getTitle() {
        if (this.frame != null) {
            return this.frame.getTitle();
        }
        if (this.dialog != null) {
            return this.dialog.getTitle();
        }
        return null;
    }

    private Icon getFrameIcon() {
        Image image = this.frame != null ? this.frame.getIconImage() : null;
        Icon icon = null;
        if (image != null) {
            icon = this.image2Icon(image);
        } else {
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.rootPane, Region.ROOT_PANE);
            SynthContext synthContext = new SynthContext(this.rootPane, Region.ROOT_PANE, synthStyle, 1024);
            icon = synthStyle.getIcon(synthContext, "RootPane.icon");
        }
        return icon;
    }

    private Icon getIcon(JRootPane jRootPane) {
        Window window;
        Icon icon = this.getFrameIcon();
        if (jRootPane.getWindowDecorationStyle() == 1 || jRootPane == null) {
            return icon;
        }
        if (jRootPane.getClientProperty("Synthetica.dialog.iconImage") != null) {
            Image image = (Image)jRootPane.getClientProperty("Synthetica.dialog.iconImage");
            return this.image2Icon(image);
        }
        if (this.window instanceof JDialog && !JavaVersion.JAVA5 && ((JDialog)this.window).getIconImages().size() > 0) {
            return this.image2Icon(((JDialog)jRootPane.getParent()).getIconImages().get(0));
        }
        if (this.window != null && this.window.getOwner() != null && (jRootPane = (window = this.window.getOwner()) instanceof JFrame ? ((JFrame)window).getRootPane() : (window instanceof JDialog ? ((JDialog)window).getRootPane() : null)) != null && jRootPane.getUI() instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)jRootPane.getUI()).getTitlePane() != null) {
            return ((SyntheticaTitlePane)((SyntheticaRootPaneUI)jRootPane.getUI()).getTitlePane()).getIcon(jRootPane);
        }
        return icon;
    }

    private Icon image2Icon(Image image) {
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.menuButton.useOriginalImageSize", this.window)) {
            return new ImageIcon(image);
        }
        return new ImageIcon(image.getScaledInstance(16, 16, 4));
    }

    private void setActive(boolean bl) {
        this.setComponentsActiveState(bl);
        this.getRootPane().repaint();
    }

    private void setComponentsActiveState(boolean bl) {
        float f;
        JInternalFrame jInternalFrame = this.iFrameDelegate;
        jInternalFrame.setName(this.window.getName());
        SynthStyle synthStyle = SynthLookAndFeel.getStyleFactory().getStyle(jInternalFrame, Region.INTERNAL_FRAME_TITLE_PANE);
        int n = 1024;
        if (bl) {
            n = 512;
        }
        SynthContext synthContext = new SynthContext(jInternalFrame, Region.INTERNAL_FRAME_TITLE_PANE, synthStyle, n);
        Font font = this.getFont();
        if (font == null || font instanceof UIResource) {
            font = synthStyle.getFont(synthContext);
        }
        f = (f = (float)SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.title.fontSize", this.window)) == 0.0f ? (float)font.getSize() : SyntheticaLookAndFeel.scaleFontSize(f);
        font = font.deriveFont(font.getStyle(), f);
        this.titleLabel.setFont(font);
        Color color = this.getForeground();
        if (color == null || color instanceof UIResource) {
            color = synthStyle.getColor(synthContext, ColorType.FOREGROUND);
        }
        color = new Color(color.getRGB());
        this.titleLabel.setForeground(color);
        this.closeButton.putClientProperty("paintActive", bl);
        if (this.rootPane.getWindowDecorationStyle() == 1 && this.dialog == null) {
            this.iconifyButton.putClientProperty("paintActive", bl);
            this.toggleButton.putClientProperty("paintActive", bl);
        }
        this.updateToggleButton();
        if (this.iconifyButton != null) {
            this.iconifyButton.setIcon(bl ? (Icon)this.iconifyButton.getClientProperty("Synthetica.iconifyIcon") : (Icon)this.iconifyButton.getClientProperty("Synthetica.iconifyIcon.inactive"));
        }
        if (this.closeButton != null) {
            this.closeButton.setIcon(bl ? (Icon)this.closeButton.getClientProperty("Synthetica.closeIcon") : (Icon)this.closeButton.getClientProperty("Synthetica.closeIcon.inactive"));
        }
    }

    private boolean isFrameResizable() {
        return this.frame != null && this.frame.isResizable();
    }

    private boolean isFrameMaximized() {
        return this.frame != null && (this.frame.getExtendedState() & 6) == 6;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.restoreButtonText", this.window));
        jMenuItem.setMnemonic('R');
        jMenuItem.setEnabled(this.isFrameResizable());
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.minimizeButtonText", this.window));
        jMenuItem.setMnemonic('n');
        jMenuItem.setEnabled(this.frame != null);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jMenuItem = jPopupMenu.add(this.maximizeAction);
            jMenuItem.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.maximizeButtonText", this.window));
            jMenuItem.setMnemonic('x');
            jMenuItem.setEnabled(this.isFrameResizable());
        }
        jPopupMenu.addSeparator();
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.closeButtonText", this.window));
        jMenuItem.setMnemonic('C');
        if (this.closeButton != null) {
            jMenuItem.setEnabled(this.closeButton.isVisible() & this.closeButton.isEnabled());
        }
    }

    private JButton createTitlePaneButton(String string) {
        JButton jButton = new JButton();
        jButton.setName(string);
        jButton.setFocusPainted(false);
        jButton.setFocusable(false);
        jButton.setOpaque(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        return jButton;
    }

    private void createButtons() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JButton jButton = (JButton)mouseEvent.getSource();
                String string = "Synthetica." + jButton.getClientProperty(SyntheticaTitlePane.BUTTON_ID) + "Icon.hover";
                jButton.setIcon((Icon)jButton.getClientProperty(string));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JButton jButton = (JButton)mouseEvent.getSource();
                String string = "Synthetica." + jButton.getClientProperty(SyntheticaTitlePane.BUTTON_ID) + "Icon";
                if (!SyntheticaTitlePane.this.window.isActive()) {
                    string = String.valueOf(string) + ".inactive";
                }
                jButton.setIcon((Icon)jButton.getClientProperty(string));
            }
        };
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.rootPane, Region.ROOT_PANE);
        SynthContext synthContext = new SynthContext(this.rootPane, Region.ROOT_PANE, synthStyle, 1024);
        Icon icon = synthStyle.getIcon(synthContext, "RootPane.closeIcon");
        Icon icon2 = synthStyle.getIcon(synthContext, "RootPane.iconifyIcon");
        Icon icon3 = synthStyle.getIcon(synthContext, "RootPane.maximizeIcon");
        Icon icon4 = synthStyle.getIcon(synthContext, "RootPane.minimizeIcon");
        Icon icon5 = synthStyle.getIcon(synthContext, "RootPane.closeIcon.inactive") == null ? icon : synthStyle.getIcon(synthContext, "RootPane.closeIcon.inactive");
        Icon icon6 = synthStyle.getIcon(synthContext, "RootPane.iconifyIcon.inactive") == null ? icon2 : synthStyle.getIcon(synthContext, "RootPane.iconifyIcon.inactive");
        Icon icon7 = synthStyle.getIcon(synthContext, "RootPane.maximizeIcon.inactive") == null ? icon3 : synthStyle.getIcon(synthContext, "RootPane.maximizeIcon.inactive");
        Icon icon8 = synthStyle.getIcon(synthContext, "RootPane.minimizeIcon.inactive") == null ? icon4 : synthStyle.getIcon(synthContext, "RootPane.minimizeIcon.inactive");
        synthContext = new SynthContext(this.rootPane, Region.ROOT_PANE, synthStyle, 2);
        Icon icon9 = synthStyle.getIcon(synthContext, "RootPane.closeIcon");
        Icon icon10 = synthStyle.getIcon(synthContext, "RootPane.iconifyIcon");
        Icon icon11 = synthStyle.getIcon(synthContext, "RootPane.maximizeIcon");
        Icon icon12 = synthStyle.getIcon(synthContext, "RootPane.minimizeIcon");
        synthContext = new SynthContext(this.rootPane, Region.ROOT_PANE, synthStyle, 4);
        Icon icon13 = synthStyle.getIcon(synthContext, "RootPane.closeIcon") == icon ? null : synthStyle.getIcon(synthContext, "RootPane.closeIcon");
        Icon icon14 = synthStyle.getIcon(synthContext, "RootPane.iconifyIcon") == icon2 ? null : synthStyle.getIcon(synthContext, "RootPane.iconifyIcon");
        Icon icon15 = synthStyle.getIcon(synthContext, "RootPane.maximizeIcon") == icon3 ? null : synthStyle.getIcon(synthContext, "RootPane.maximizeIcon");
        Icon icon16 = synthStyle.getIcon(synthContext, "RootPane.minimizeIcon") == icon4 ? null : synthStyle.getIcon(synthContext, "RootPane.minimizeIcon");
        this.closeButton = this.createTitlePaneButton("RootPane.titlePane.closeButton");
        this.closeButton.putClientProperty(BUTTON_ID, "close");
        this.closeButton.putClientProperty("Synthetica.closeIcon", icon);
        this.closeButton.putClientProperty("Synthetica.closeIcon.hover", icon9);
        this.closeButton.putClientProperty("Synthetica.closeIcon.inactive", icon5);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(icon);
        this.closeButton.setPressedIcon(icon13);
        this.closeButton.addMouseListener(mouseAdapter);
        CloseButtonStateListener closeButtonStateListener = new CloseButtonStateListener();
        this.closeButton.addPropertyChangeListener(closeButtonStateListener);
        this.closeButton.addComponentListener(closeButtonStateListener);
        if (this.rootPane.getWindowDecorationStyle() == 1 && this.dialog == null) {
            this.iconifyButton = this.createTitlePaneButton("RootPane.titlePane.iconifyButton");
            this.iconifyButton.putClientProperty(BUTTON_ID, "iconify");
            this.iconifyButton.putClientProperty("Synthetica.iconifyIcon", icon2);
            this.iconifyButton.putClientProperty("Synthetica.iconifyIcon.hover", icon10);
            this.iconifyButton.putClientProperty("Synthetica.iconifyIcon.inactive", icon6);
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
            this.iconifyButton.setIcon(icon2);
            this.iconifyButton.setPressedIcon(icon14);
            this.iconifyButton.addMouseListener(mouseAdapter);
            this.toggleButton = this.createTitlePaneButton("RootPane.titlePane.toggleButton");
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon", icon3);
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon.hover", icon11);
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon.pressed", icon15);
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon.inactive", icon7);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon", icon4);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon.hover", icon12);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon.pressed", icon16);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon.inactive", icon8);
            this.updateToggleButton();
            this.toggleButton.addMouseListener(mouseAdapter);
        }
    }

    private void updateToggleButton() {
        if (this.toggleButton == null) {
            return;
        }
        boolean bl = this.window.isActive();
        Icon icon = null;
        Icon icon2 = null;
        if (!this.isFrameMaximized()) {
            this.toggleButton.setAction(this.maximizeAction);
            this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
            this.toggleButton.putClientProperty(BUTTON_ID, "maximize");
            icon = !bl ? (Icon)this.toggleButton.getClientProperty("Synthetica.maximizeIcon.inactive") : (Icon)this.toggleButton.getClientProperty("Synthetica.maximizeIcon");
            icon2 = (Icon)this.toggleButton.getClientProperty("Synthetica.maximizeIcon.pressed");
        } else {
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.getAccessibleContext().setAccessibleName("Restore");
            this.toggleButton.putClientProperty(BUTTON_ID, "minimize");
            icon = !bl ? (Icon)this.toggleButton.getClientProperty("Synthetica.minimizeIcon.inactive") : (Icon)this.toggleButton.getClientProperty("Synthetica.minimizeIcon");
            icon2 = (Icon)this.toggleButton.getClientProperty("Synthetica.minimizeIcon.pressed");
        }
        this.toggleButton.setIcon(icon);
        this.toggleButton.setPressedIcon(icon2);
        this.toggleButton.setEnabled(this.isFrameResizable());
    }

    public void paintComponent(Graphics graphics) {
        boolean bl;
        int n;
        int n2;
        String string;
        super.paintComponent(graphics);
        SynthContext synthContext = SyntheticaLookAndFeel.createContext(this.rootPane, Region.ROOT_PANE, this.selected ? 512 : 0);
        ((SyntheticaPainter)SyntheticaPainter.getInstance()).paintRootPaneTitlePaneBackground(synthContext, graphics, 0, 0, this.getWidth(), this.getHeight());
        Rectangle rectangle = this.getControlButtonsBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            ((SyntheticaPainter)SyntheticaPainter.getInstance()).paintRootPaneButtonAreaBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if ((string = this.getTitle()) == null || string.length() == 0) {
            return;
        }
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        Insets insets = gridBagLayout.getConstraints((Component)this.titleLabel).insets;
        FontMetrics fontMetrics = this.getFontMetrics(this.titleLabel.getFont());
        boolean bl2 = OS.getCurrentOS() == OS.Mac && this.useMACStyle;
        boolean bl3 = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.title.center", this.window) || bl2;
        int n3 = this.getXGap();
        Rectangle rectangle2 = this.getBounds();
        Rectangle rectangle3 = this.getMenuButtonBounds();
        if (this.menuButton != null) {
            rectangle3.width += gridBagLayout.getConstraints((Component)this.menuButton).insets.right;
        }
        Rectangle rectangle4 = this.getControlButtonsBounds();
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.iFrameDelegate, Region.INTERNAL_FRAME_TITLE_PANE);
        int n4 = 1024;
        if (this.selected) {
            n4 = 512;
        }
        synthContext = new SynthContext(this.iFrameDelegate, Region.INTERNAL_FRAME_TITLE_PANE, synthStyle, n4);
        rectangle2.width -= rectangle3.width + rectangle4.width + n3 * 2 + insets.left + insets.right;
        String string2 = synthStyle.getGraphicsUtils(synthContext).layoutText(synthContext, fontMetrics, string, null, 0, 0, 0, 0, rectangle2, new Rectangle(0, 0), new Rectangle(0, 0), 0);
        boolean bl4 = this.isRTL();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getHeight();
        int n7 = n2 = this.getTitleLabelAlignment() == 10 ? (this.getHeight() - n6 + insets.top - insets.bottom) / 2 : this.titleLabel.getY();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.showMenuBarInTitlePane", this.window, false)) {
            n2 = this.titleLabel.getY() + this.titleLabel.getInsets().top;
        }
        int n8 = bl2 || bl4 ? rectangle4.x + rectangle4.width + insets.right : rectangle3.x + rectangle3.width + insets.left;
        int n9 = bl2 || bl4 ? rectangle3.x - n5 - insets.left : rectangle4.x - n5 - insets.right;
        n9 = Math.max(n8, n9);
        int n10 = n = bl4 ? n9 : n8;
        int n11 = bl3 ? (bl4 ? Math.min(n, this.getWidth() / 2 - fontMetrics.stringWidth(string) / 2) : Math.max(n, this.getWidth() / 2 - fontMetrics.stringWidth(string) / 2)) : (n = n);
        if (!bl2) {
            n = bl4 ? Math.min(n, n9) : Math.max(n, n8);
            n = bl4 ? Math.max(n, n8) : Math.min(n, n9);
        }
        boolean bl5 = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.title.visible", this.window, true);
        boolean bl6 = bl = this.rootPane.getClientProperty("Synthetica.logoRenderer") != null;
        if (bl5 && (!bl || (!bl || this.rootPane.getClientProperty("Synthetica.paintTitle") != null) && ((Boolean)this.rootPane.getClientProperty("Synthetica.paintTitle")).booleanValue())) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.dropShadow", this.window) && this.selected) {
                BufferedImage bufferedImage = new BufferedImage(n5, n6, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setFont(this.titleLabel.getFont());
                ((Graphics)graphics2D).drawString(string2, 0, fontMetrics.getAscent());
                graphics2D.dispose();
                DropShadow dropShadow = new DropShadow(bufferedImage);
                dropShadow.setDistance(SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.distance", this.window, -5));
                dropShadow.setShadowColor(SyntheticaLookAndFeel.getColor("Synthetica.rootPane.titlePane.dropShadow.color", this.window, dropShadow.getShadowColor()));
                dropShadow.setQuality(SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.dropShadow.highQuality", this.window, dropShadow.getHighQuality()));
                dropShadow.setShadowOpacity((float)SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.opacity", this.window, (int)(dropShadow.getShadowOpacity() * 100.0f)) / 100.0f);
                dropShadow.setShadowSize(SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.size", this.window, dropShadow.getShadowSize()));
                int n12 = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.xOffset", this.window, 0);
                int n13 = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.yOffset", this.window, 0);
                dropShadow.paintShadow(graphics, n + n12, n2 + n13);
            }
            graphics.setFont(this.titleLabel.getFont());
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.title.etchedTop", this.window)) {
                graphics.setColor(Color.BLACK);
                synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string2, n, n2 - 1, -2);
            }
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.title.etchedBottom", this.window)) {
                graphics.setColor(Color.WHITE);
                synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string2, n, n2 + 1, -2);
            }
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.FOREGROUND));
            synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string2, n, n2, -2);
        }
    }

    public Rectangle getControlButtonsBounds() {
        Rectangle rectangle = this.closeButton.getBounds();
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            if (this.toggleButton != null) {
                rectangle.width = this.toggleButton.getBounds().x + this.toggleButton.getBounds().width - rectangle.x;
            }
        } else if (this.iconifyButton != null) {
            Rectangle rectangle2 = this.iconifyButton.getBounds();
            if (this.isRTL()) {
                rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
            } else {
                rectangle.width = rectangle.x + rectangle.width - rectangle2.x;
                rectangle.x = rectangle2.x;
            }
        }
        return rectangle;
    }

    public Rectangle getMenuButtonBounds() {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = this.menuButton == null ? new Rectangle(0, 0, 0, 0) : this.menuButton.getBounds();
        if (this.menuButton == null) {
            rectangle.x = this.isRTL() ? this.getBounds().width - 1 : 0;
            rectangle.y = this.getBounds().y;
        }
        return rectangle;
    }

    private void close() {
        this.window.dispatchEvent(new WindowEvent(this.window, 201));
    }

    private void iconify() {
        int n = this.frame.getExtendedState();
        this.frame.setExtendedState(n | 1);
        this.updateState();
    }

    void maximize() {
        int n = this.frame.getExtendedState();
        this.rootPaneUI.setMaximizedBounds(this.frame);
        this.frame.setExtendedState(n | 6);
        this.updateState();
    }

    void restore() {
        int n = this.frame.getExtendedState();
        if ((n & 1) == 1) {
            this.frame.setExtendedState(n ^ 1);
        } else if ((n & 6) == 6) {
            this.frame.setExtendedState(n ^ 6);
        }
        this.updateState();
    }

    private void updateState() {
        if (this.frame == null) {
            return;
        }
        if (!this.isFrameResizable()) {
            this.restoreAction.setEnabled(false);
            this.maximizeAction.setEnabled(false);
            this.iconifyAction.setEnabled(true);
            return;
        }
        switch (this.frame.getExtendedState()) {
            case 6: {
                this.restoreAction.setEnabled(true);
                this.maximizeAction.setEnabled(false);
                this.iconifyAction.setEnabled(true);
                break;
            }
            case 1: {
                this.restoreAction.setEnabled(true);
                this.maximizeAction.setEnabled(true);
                this.iconifyAction.setEnabled(false);
                break;
            }
            default: {
                this.restoreAction.setEnabled(false);
                this.maximizeAction.setEnabled(true);
                this.iconifyAction.setEnabled(true);
            }
        }
    }

    public ComponentOrientation getComponentOrientation() {
        return this.window == null ? this.getRootPane().getComponentOrientation() : this.window.getComponentOrientation();
    }

    private boolean isRTL() {
        return !this.getComponentOrientation().isLeftToRight();
    }

    private class CloseButtonStateListener
    implements PropertyChangeListener,
    ComponentListener {
        private CloseButtonStateListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.updateSystemMenu();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.updateSystemMenu();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                this.updateSystemMenu();
            }
        }

        private void updateSystemMenu() {
            if (SyntheticaTitlePane.this.systemMenu != null) {
                SyntheticaTitlePane.this.systemMenu.removeAll();
                SyntheticaTitlePane.this.addMenuItems(SyntheticaTitlePane.this.systemMenu);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LayoutStyle {
        REGULAR,
        SECONDARYMENU;

    }

    private static class UserComponentContainer
    extends JComponent {
        public UserComponentContainer() {
            this.setLayout(new BorderLayout());
        }
    }
}

