/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.TaskPanePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneContainerUI;

public class TaskPaneContainerUI
extends BasicTaskPaneContainerUI {
    protected JXTaskPaneContainer container;
    protected boolean useGradient;
    protected Color gradientStart;
    protected Color gradientEnd;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("name".equals(string)) {
                TaskPaneContainerUI.this.container.setLayout(TaskPaneContainerUI.this.createDefaultLayout());
                TaskPaneContainerUI.this.container.setBorder(TaskPaneContainerUI.this.createContainerBorder());
            }
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new TaskPaneContainerUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.container = (JXTaskPaneContainer)jComponent;
        this.container.setBorder(this.createContainerBorder());
        this.container.setOpaque(true);
        if (this.container.getBackground() == null || this.container.getBackground() instanceof ColorUIResource) {
            this.container.setBackground(UIManager.getColor("TaskPaneContainer.background"));
        }
        this.useGradient = UIManager.getBoolean("TaskPaneContainer.useGradient");
        if (this.useGradient) {
            this.gradientStart = UIManager.getColor("TaskPaneContainer.backgroundGradientStart");
            this.gradientEnd = UIManager.getColor("TaskPaneContainer.backgroundGradientEnd");
        }
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallListeners();
    }

    protected void installListeners() {
        this.container.addPropertyChangeListener(this.propertyListener);
    }

    protected void uninstallListeners() {
        this.container.removePropertyChangeListener(this.propertyListener);
    }

    protected void installDefaults() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.useGradient) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.gradientStart, 0.0f, jComponent.getHeight(), this.gradientEnd);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics2D.setPaint(paint);
        }
        if (UIManager.get("Synthetica.taskPane.container.background") != null) {
            TaskPanePainter.getInstance().paintTaskPaneContainerBackground(jComponent, new SyntheticaState(), graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    protected LayoutManager createDefaultLayout() {
        return new BasicTaskPaneContainerUI.VerticalLayoutUIResource((BasicTaskPaneContainerUI)this, SyntheticaLookAndFeel.getInt("Synthetica.taskPane.container.verticalGap", (Component)this.container, 14));
    }

    private Border createContainerBorder() {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.taskPane.container.insets", (Component)this.container);
        if (insets == null) {
            insets = new Insets(10, 10, 0, 10);
        }
        return new EmptyBorder(insets);
    }
}

