/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ButtonPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ButtonPainter";
    protected static WeakHashMap<AbstractButton, Object> buttons = new WeakHashMap();

    protected ButtonPainter() {
    }

    public static ButtonPainter getInstance() {
        return ButtonPainter.getInstance(null);
    }

    public static ButtonPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(ButtonPainter.getPainterClassName(synthContext, ButtonPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = ButtonPainter.getInstance(synthContext, ButtonPainter.class, UI_KEY);
        }
        return (ButtonPainter)syntheticaComponentPainter;
    }

    public void paintButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.paintCheck(synthContext)) {
            return;
        }
        JComponent jComponent = synthContext.getComponent();
        String string = (String)jComponent.getClientProperty("JButton.segmentPosition");
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        this.paintButtonBackground(jComponent, syntheticaPainterState, string, graphics, n, n2, n3, n4);
    }

    public void paintButtonBackground(JComponent jComponent, SyntheticaState syntheticaState, String string, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintButtonBackground(jComponent, syntheticaState, string, 0, graphics, n, n2, n3, n4);
    }

    public void paintButtonBackground(JComponent jComponent, SyntheticaState syntheticaState, String string, int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        Object object;
        Insets insets;
        if (!this.paintCheck(jComponent, syntheticaState)) {
            return;
        }
        if (syntheticaState.isSet(SyntheticaState.State.SELECTED)) {
            syntheticaState = new SyntheticaState(syntheticaState.getState());
            syntheticaState.resetState(SyntheticaState.State.SELECTED);
            syntheticaState.setState(SyntheticaState.State.PRESSED);
        }
        String string2 = string == null || string.length() == 0 ? "" : "." + string;
        Object object2 = new UIKey("button.border" + string2, syntheticaState);
        if (n4 <= 12 || n5 <= 12) {
            object2 = new UIKey("button.12x12.border", syntheticaState);
            string2 = ".12x12";
        }
        Container container = jComponent.getParent();
        Insets insets2 = insets = (Insets)UIKey.findProperty(jComponent, ((UIKey)object2).get(), "insets", true, 2);
        if (this.isToolBarButton(jComponent) && !SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", jComponent)) {
            object2 = new UIKey("toolBar.button.border" + string2, syntheticaState);
            if (SyntheticaLookAndFeel.get(((UIKey)object2).get(), jComponent) == null) {
                object2 = new UIKey("toolBar.button.border", syntheticaState);
            }
        } else if (container != null && container.getParent() instanceof JToolBar && "ButtonBar".equals(SyntheticaLookAndFeel.getStyleName(container)) && SyntheticaLookAndFeel.get(((UIKey)(object = new UIKey("toolBar.buttonBar.button.border" + string2, syntheticaState))).get(), jComponent) != null) {
            object2 = object;
        }
        object = SyntheticaLookAndFeel.getString(((UIKey)object2).get(), jComponent);
        if (jComponent.hasFocus() && SyntheticaLookAndFeel.get(String.valueOf(((UIKey)object2).get()) + ".focused", jComponent) != null) {
            object = SyntheticaLookAndFeel.getString(String.valueOf(((UIKey)object2).get()) + ".focused", jComponent);
        }
        object2 = new UIKey("button", syntheticaState);
        if (object != null && SyntheticaLookAndFeel.isOpaque(jComponent)) {
            int n6 = SyntheticaLookAndFeel.getInt(((UIKey)object2).get("animation.cycles"), jComponent, 1);
            int n7 = SyntheticaLookAndFeel.getInt(((UIKey)object2).get("animation.delay"), jComponent, 50);
            int n8 = SyntheticaLookAndFeel.getInt(((UIKey)object2).get("animation.type"), jComponent, 2);
            if (syntheticaState.isSet(SyntheticaState.State.DEFAULT)) {
                n6 = SyntheticaLookAndFeel.getInt(((UIKey)object2).get("animation.cycles"), jComponent, -1);
                n7 = SyntheticaLookAndFeel.getInt(((UIKey)object2).get("animation.delay"), jComponent, 70);
                n8 = SyntheticaLookAndFeel.getInt(((UIKey)object2).get("animation.type"), jComponent, 0);
            } else if (syntheticaState.isSet(SyntheticaState.State.HOVER)) {
                n8 = SyntheticaLookAndFeel.getInt(((UIKey)object2).get("animation.type"), jComponent, 1);
            }
            ImagePainter imagePainter = new ImagePainter(jComponent, n6, n7, n8, syntheticaState.getState(), graphics, n2, n3, n4, n5, (String)object, insets, insets2, 0, 0);
            imagePainter.setAngle(n);
            imagePainter.draw();
        }
        if ((jComponent.hasFocus() || syntheticaState.isSet(SyntheticaState.State.FOCUSED)) && ((AbstractButton)jComponent).isFocusPainted()) {
            string2 = string2 == null || string2.length() == 0 ? "" : string2;
            FocusPainter.paintFocus("focus.button" + string2, jComponent, syntheticaState.getState(), null, n, graphics, n2, n3, n4, n5);
        }
    }

    protected boolean paintCheck(SynthContext synthContext) {
        return this.paintCheck(synthContext.getComponent(), new SyntheticaPainterState(synthContext));
    }

    protected boolean paintCheck(JComponent jComponent, SyntheticaState syntheticaState) {
        if (!(jComponent instanceof AbstractButton)) {
            return false;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Container container = abstractButton.getParent();
        if (container != null) {
            if (container instanceof BasicInternalFrameTitlePane && !SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.buttons.paintBorder", abstractButton)) {
                return false;
            }
            if (container instanceof SyntheticaTitlePane && !SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.buttons.paintBorder", abstractButton)) {
                return false;
            }
            if (this.isToolBarButton(jComponent)) {
                Insets insets;
                SynthStyle synthStyle = SynthLookAndFeel.getStyle(jComponent, Region.BUTTON);
                SynthContext synthContext = new SynthContext(jComponent, Region.BUTTON, synthStyle, 0);
                Insets insets2 = (Insets)synthContext.getStyle().get(synthContext, "Button.margin");
                Insets insets3 = insets = abstractButton.getMargin() == null ? new Insets(0, 0, 0, 0) : abstractButton.getMargin();
                if ((insets.equals(insets2) || !buttons.containsKey(abstractButton) && (abstractButton.getText() == null || "".equals(abstractButton.getText().trim()))) && insets.equals(insets2)) {
                    abstractButton.setMargin(new Insets(insets.bottom - insets2.bottom, insets.left - insets2.left, insets.top - insets2.top, insets.right - insets2.right));
                }
                buttons.put(abstractButton, null);
                boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", abstractButton);
                if (!(bl || syntheticaState.isSet(SyntheticaState.State.HOVER) || SyntheticaLookAndFeel.get("Synthetica.toolBar.button.border", abstractButton) != null || syntheticaState.isSet(SyntheticaState.State.PRESSED) && SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.button.pressed.paintBorder", abstractButton))) {
                    return false;
                }
            }
        }
        if (abstractButton.isBorderPainted() || abstractButton.getText() == null || abstractButton.getText().length() == 0) {
            if (!abstractButton.isBorderPainted() && !syntheticaState.isSet(SyntheticaState.State.HOVER)) {
                return false;
            }
            return abstractButton.isContentAreaFilled();
        }
        return false;
    }

    private boolean isToolBarButton(JComponent jComponent) {
        Boolean bl = (Boolean)jComponent.getClientProperty("Synthetica.useToolBarStyle");
        return bl == null || bl != false ? jComponent.getParent() instanceof JToolBar : false;
    }

    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        AbstractButton abstractButton = (AbstractButton)synthContext.getComponent();
        if (abstractButton.getParent() instanceof JToolBar) {
            return -1;
        }
        String string2 = (String)abstractButton.getClientProperty("JButton.segmentPosition");
        Border border = abstractButton.getBorder();
        int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
        int n5 = n4 = string2 == null ? n4 : 31 * n4 + string2.hashCode();
        n4 = border == null ? n4 : 31 * n4 + (abstractButton.isBorderPainted() ? 0 : 1);
        n4 = 31 * n4 + (abstractButton.isContentAreaFilled() ? 0 : 1);
        return n4;
    }
}

