/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.synth.SynthContext;

public class SliderPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SliderPainter";

    protected SliderPainter() {
    }

    public static SliderPainter getInstance() {
        return SliderPainter.getInstance(null);
    }

    public static SliderPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(SliderPainter.getPainterClassName(synthContext, SliderPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = SliderPainter.getInstance(synthContext, SliderPainter.class, UI_KEY);
        }
        return (SliderPainter)syntheticaComponentPainter;
    }

    public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.hasFocus()) {
            FocusPainter.paintFocus("focus.slider", synthContext, graphics, n, n2, n3, n4);
        }
    }

    public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JSlider jSlider = (JSlider)synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        this.paintSliderTrack(jSlider, syntheticaPainterState, jSlider.getOrientation(), graphics, n, n2, n3, n4);
        syntheticaPainterState = new SyntheticaPainterState(synthContext, 0, true);
        this.paintSliderTrack(jSlider, syntheticaPainterState, jSlider.getOrientation(), jSlider.getValue(), jSlider.getMinimum(), jSlider.getMaximum(), jSlider.getInverted(), graphics, n, n2, n3, n4);
    }

    public void paintSliderTrack(JComponent jComponent, SyntheticaState syntheticaState, int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        Insets insets;
        UIKey uIKey = new UIKey("slider.track", syntheticaState, -1, -1, n);
        Insets insets2 = insets = (Insets)UIKey.findProperty(jComponent, uIKey.get(), "image.insets", true, 1);
        String string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        ImagePainter imagePainter = new ImagePainter(jComponent, graphics, n2, n3, n4, n5, string, insets, insets2, 0, 0);
        imagePainter.draw();
    }

    public void paintSliderTrack(JComponent jComponent, SyntheticaState syntheticaState, int n, int n2, int n3, int n4, boolean bl, Graphics graphics, int n5, int n6, int n7, int n8) {
        int n9 = SyntheticaLookAndFeel.getInt("Synthetica.slider.thumb.width", jComponent, 10);
        String string = "slider.trackMark";
        UIKey uIKey = new UIKey(string, syntheticaState, -1, -1, n);
        String string2 = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        if (string2 == null) {
            string = "slider.track";
            uIKey = new UIKey(string, syntheticaState, -1, -1, n);
            string2 = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        }
        if (string2 != null) {
            int n10;
            int n11;
            Insets insets = (Insets)UIKey.findProperty(jComponent, uIKey.get(), "image.insets", true, 1);
            Insets insets2 = (Insets)insets.clone();
            uIKey = new UIKey(string, syntheticaState);
            int n12 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jComponent, 1);
            int n13 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jComponent, 50);
            int n14 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, 2);
            if (syntheticaState.isSet(SyntheticaState.State.HOVER) || syntheticaState.isSet(SyntheticaState.State.PRESSED)) {
                n14 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, 1);
            }
            int n15 = n2 - n3;
            int n16 = n11 = n4 == n3 ? n15 : n4 - n3;
            if (n11 == 0) {
                n11 = 1;
            }
            if (n == 0) {
                n7 -= n9;
                if (!bl ^ !jComponent.getComponentOrientation().isLeftToRight()) {
                    n7 = n7 * n15 / n11 + n9 / 2;
                    insets2.right = 0;
                } else {
                    n10 = n7 * n15 / n11 + n9 / 2;
                    n5 += n7 - n10 + n9;
                    n7 = n10;
                    insets2.left = 0;
                }
            } else {
                n8 -= n9;
                if (!bl) {
                    n10 = n8 * n15 / n11 + n9 / 2;
                    n6 += n8 - n10 + n9;
                    n8 = n10;
                    insets2.top = 0;
                } else {
                    n8 = n8 * n15 / n11 + n9 / 2;
                    insets2.bottom = 0;
                }
            }
            ImagePainter imagePainter = new ImagePainter(jComponent, "track", n12, n13, n14, syntheticaState.getState(), graphics, n5, n6, n7, n8, string2, insets, insets2, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintSliderThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        JSlider jSlider = (JSlider)synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        this.paintSliderThumb(jSlider, syntheticaPainterState, n5, graphics, n, n2, n3, n4);
    }

    public void paintSliderThumb(JComponent jComponent, SyntheticaState syntheticaState, int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        Insets insets;
        UIKey uIKey = new UIKey("slider.thumb", syntheticaState, -1, -1, n);
        Insets insets2 = insets = (Insets)UIKey.findProperty(jComponent, uIKey.get(), "image.insets", true, 1);
        String string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        if (syntheticaState.isSet(SyntheticaState.State.PRESSED) && string == null) {
            syntheticaState.setState(SyntheticaState.State.HOVER.toInt());
            uIKey = new UIKey("slider.thumb", syntheticaState, -1, -1, n);
            string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        }
        if (string != null) {
            uIKey = new UIKey("slider.thumb", syntheticaState);
            int n6 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jComponent, 1);
            int n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jComponent, 50);
            int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, 2);
            if (syntheticaState.isSet(SyntheticaState.State.HOVER) || syntheticaState.isSet(SyntheticaState.State.PRESSED)) {
                n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, 1);
            }
            ImagePainter imagePainter = new ImagePainter(jComponent, "thumb", n6, n7, n8, syntheticaState.getState(), graphics, n2, n3, n4, n5, string, insets, insets2, 0, 0);
            imagePainter.draw();
        }
        if (jComponent.hasFocus() || syntheticaState.isSet(SyntheticaState.State.FOCUSED)) {
            String string2 = null;
            if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb.x", jComponent) != null && ((JSlider)jComponent).getOrientation() == 0) {
                string2 = "focus.slider.thumb.x";
            } else if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb.y", jComponent) != null && ((JSlider)jComponent).getOrientation() == 1) {
                string2 = "focus.slider.thumb.y";
            } else if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb", jComponent) != null) {
                string2 = "focus.slider.thumb";
            }
            if (string2 != null) {
                FocusPainter.paintFocus(string2, jComponent, syntheticaState.getState(), "", graphics, n2, n3, n4, n5);
            }
        }
    }

    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        if (string.equals("paintSliderBackground")) {
            return -1;
        }
        JSlider jSlider = (JSlider)synthContext.getComponent();
        int n4 = jSlider.getOrientation();
        int n5 = super.getCacheHash(synthContext, n, n2, n3, string);
        n5 = 31 * n5 + n4;
        return n5;
    }
}

