/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class PopupMenuStyle
extends StyleWrapper {
    private static PopupMenuStyle instance = new PopupMenuStyle();

    private PopupMenuStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        JPopupMenu jPopupMenu = (JPopupMenu)jComponent;
        jPopupMenu.setOpaque(false);
        if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
            jPopupMenu.setDoubleBuffered(false);
        }
        jPopupMenu.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JPopupMenu jPopupMenu;
                JPanel jPanel;
                String string = propertyChangeEvent.getPropertyName();
                if ("visible".equals(string) && (jPanel = (JPanel)(jPopupMenu = (JPopupMenu)propertyChangeEvent.getSource()).getParent()) != null && jPanel.isOpaque()) {
                    jPanel.setOpaque(false);
                    if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
                        jPanel.setDoubleBuffered(false);
                    }
                }
            }
        });
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        PopupMenuStyle popupMenuStyle = new PopupMenuStyle();
        popupMenuStyle.setStyle(synthStyle);
        return popupMenuStyle;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        JPopupMenu jPopupMenu = (JPopupMenu)synthContext.getComponent();
        Insets insets2 = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.toplevel.insets", (Component)jPopupMenu, false);
        return SyntheticaLookAndFeel.isToplevelPopupMenu(jPopupMenu) ? insets2 : super.getInsets(synthContext, insets);
    }
}

