/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class TableStyle
extends StyleWrapper {
    private static TableStyle instance = new TableStyle();

    private TableStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        TableStyle tableStyle = new TableStyle();
        tableStyle.setStyle(synthStyle);
        return tableStyle;
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        Color color;
        if (colorType == ColorType.BACKGROUND && (color = synthContext.getComponent().getBackground()) != null && !(color instanceof UIResource)) {
            return color;
        }
        return super.getColor(synthContext, colorType);
    }

    public Object get(SynthContext synthContext, Object object) {
        if ("Table.rowHeight".equals(object)) {
            JComponent jComponent = synthContext.getComponent();
            FontMetrics fontMetrics = ((Component)jComponent).getFontMetrics(jComponent.getFont());
            int n = fontMetrics.getHeight();
            if (this.synthStyle.get(synthContext, object) == null) {
                return new Integer(n + 2);
            }
        } else {
            if ("Table.dropLineColor".equals(object)) {
                return UIManager.get("Table.dropLineColor");
            }
            if ("Table.dropLineShortColor".equals(object)) {
                return UIManager.get("Table.dropLineShortColor");
            }
        }
        return this.synthStyle.get(synthContext, object);
    }
}

