/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.IUIPropertySupport;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.UIValue;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JYCheckBox
extends JCheckBox
implements IUIPropertySupport {
    private static final long serialVersionUID = 559458749450181044L;
    private boolean setStateInteractive = true;
    private UIValue<Icon> halfSelectedIcon;
    private UIValue<Icon> rolloverHalfSelectedIcon;

    public JYCheckBox() {
        this(null, null, false);
    }

    public JYCheckBox(Action action) {
        this();
        this.setAction(action);
    }

    public JYCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public JYCheckBox(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JYCheckBox(String string) {
        this(string, null, false);
    }

    public JYCheckBox(String string, boolean bl) {
        this(string, null, bl);
    }

    public JYCheckBox(String string, Icon icon) {
        this(string, icon, false);
    }

    public JYCheckBox(String string, Icon icon, boolean bl) {
        this(string, icon, bl ? State.SELECTED : State.DESELECTED);
    }

    public JYCheckBox(String string, Icon icon, State state) {
        super(string, icon, false);
        this.setModel(new CheckBoxModel(state));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Icon icon = SyntheticaLookAndFeel.loadIcon("JYCheckBox.halfSelected.icon", this);
        if (icon == null && this.getDefaultSelectedIcon() != null) {
            icon = SyntheticaAddonsUtilities.createAlphaIcon(this.getDefaultSelectedIcon(), 0.5f);
        }
        if (this.halfSelectedIconIsUIResource()) {
            this.setHalfSelectedIcon(icon, true);
        }
        if ((icon = SyntheticaLookAndFeel.loadIcon("JYCheckBox.halfSelected.icon.hover", this)) == null && this.getDefaultRolloverSelectedIcon() != null) {
            icon = SyntheticaAddonsUtilities.createAlphaIcon(this.getDefaultRolloverSelectedIcon(), 0.5f);
        }
        if (this.rolloverHalfSelectedIconIsUIResource()) {
            this.setRolloverHalfSelectedIcon(icon, true);
        }
    }

    private Icon getDefaultSelectedIcon() {
        Icon icon = SyntheticaLookAndFeel.loadIcon("Synthetica.checkBox.selected.image", this);
        if (icon == null && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(this, Region.CHECK_BOX);
            SynthContext synthContext = new SynthContext(this, Region.CHECK_BOX, synthStyle, 512);
            icon = synthStyle.getIcon(synthContext, "CheckBox.icon");
        }
        return icon;
    }

    private Icon getDefaultRolloverSelectedIcon() {
        Icon icon = SyntheticaLookAndFeel.loadIcon("Synthetica.checkBox.hover.selected.image", this);
        if (icon == null && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(this, Region.CHECK_BOX);
            SynthContext synthContext = new SynthContext(this, Region.CHECK_BOX, synthStyle, 514);
            icon = synthStyle.getIcon(synthContext, "CheckBox.icon");
        }
        return icon;
    }

    @Override
    public Icon getSelectedIcon() {
        return ((CheckBoxModel)this.getModel()).getState() == State.HALF_SELECTED ? this.getHalfSelectedIcon() : super.getSelectedIcon();
    }

    @Override
    public Icon getRolloverSelectedIcon() {
        return ((CheckBoxModel)this.getModel()).getState() == State.HALF_SELECTED ? this.getRolloverHalfSelectedIcon() : super.getRolloverSelectedIcon();
    }

    public void setState(State state) {
        ((CheckBoxModel)this.getModel()).setState(state);
    }

    public State getState() {
        return ((CheckBoxModel)this.getModel()).getState();
    }

    public void setStateInteractive(boolean bl) {
        this.setStateInteractive = bl;
    }

    public boolean isStateInteractive() {
        return this.setStateInteractive;
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    public void setHalfSelectedIcon(Icon icon) {
        this.setHalfSelectedIcon(icon, false);
    }

    public void setHalfSelectedIcon(Icon icon, boolean bl) {
        WidgetUtils.setUIProperty(this, "halfSelectedIcon", this.halfSelectedIcon, this.getHalfSelectedIcon(), icon, bl, false, false);
    }

    public boolean halfSelectedIconIsUIResource() {
        return this.getHalfSelectedIconUIValue().isUIResource();
    }

    public Icon getHalfSelectedIcon() {
        return this.getHalfSelectedIconUIValue().get();
    }

    private UIValue<Icon> getHalfSelectedIconUIValue() {
        if (this.halfSelectedIcon == null) {
            this.halfSelectedIcon = new UIValue();
        }
        return this.halfSelectedIcon;
    }

    public void setRolloverHalfSelectedIcon(Icon icon) {
        this.setRolloverHalfSelectedIcon(icon, false);
    }

    public void setRolloverHalfSelectedIcon(Icon icon, boolean bl) {
        WidgetUtils.setUIProperty(this, "rolloverHalfSelectedIcon", this.rolloverHalfSelectedIcon, this.getRolloverHalfSelectedIcon(), icon, bl, false, false);
    }

    public boolean rolloverHalfSelectedIconIsUIResource() {
        return this.getRolloverHalfSelectedIconUIValue().isUIResource();
    }

    public Icon getRolloverHalfSelectedIcon() {
        return this.getRolloverHalfSelectedIconUIValue().get();
    }

    private UIValue<Icon> getRolloverHalfSelectedIconUIValue() {
        if (this.rolloverHalfSelectedIcon == null) {
            this.rolloverHalfSelectedIcon = new UIValue();
        }
        return this.rolloverHalfSelectedIcon;
    }

    private class CheckBoxModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 6033408508665083060L;
        private State state;

        public CheckBoxModel() {
            this(State.DESELECTED);
        }

        public CheckBoxModel(State state) {
            this.setState(state);
        }

        public void setPressed(boolean bl) {
            if (!JYCheckBox.this.setStateInteractive) {
                super.setPressed(bl);
                return;
            }
            if (this.isPressed() == bl || !this.isEnabled()) {
                return;
            }
            if (!bl && this.isArmed()) {
                this.nextState();
            }
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int n = 0;
                AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                if (aWTEvent instanceof InputEvent) {
                    n = ((InputEvent)aWTEvent).getModifiers();
                } else if (aWTEvent instanceof ActionEvent) {
                    n = ((ActionEvent)aWTEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n));
            }
        }

        public void setSelected(boolean bl) {
            this.setState(bl ? State.SELECTED : State.DESELECTED);
        }

        public void setState(State state) {
            this.state = state;
            JYCheckBox.this.putClientProperty("Synthetica.background", null);
            JYCheckBox.this.putClientProperty("Synthetica.background.alpha", null);
            if (state == State.SELECTED) {
                super.setSelected(true);
            } else if (state == State.DESELECTED) {
                super.setSelected(false);
            } else {
                super.setSelected(true);
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, -1));
            }
        }

        public State getState() {
            return this.state;
        }

        private void nextState() {
            State state = this.getState();
            if (state == State.DESELECTED) {
                this.setState(State.SELECTED);
            } else if (state == State.SELECTED) {
                this.setState(State.HALF_SELECTED);
            } else if (state == State.HALF_SELECTED) {
                this.setState(State.DESELECTED);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        SELECTED,
        HALF_SELECTED,
        DESELECTED;

    }
}

