/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYCheckBox;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JYCheckBoxList
extends JList {
    private static final long serialVersionUID = 4276590525430269592L;
    private CheckBoxSelectionModel checkBoxSelectionModel;
    private boolean checkBoxSelectableByItemClick;
    private boolean mousePressed;
    private Object clickedItem;
    private boolean checkBoxClicked;

    public JYCheckBoxList() {
        this((ListModel)new AbstractListModel(){

            public int getSize() {
                return 0;
            }

            public Object getElementAt(int n) {
                return "No Data Model";
            }
        });
    }

    public JYCheckBoxList(final Object ... objectArray) {
        this((ListModel)new AbstractListModel(){

            public int getSize() {
                return objectArray.length;
            }

            public Object getElementAt(int n) {
                return objectArray[n];
            }
        });
    }

    public JYCheckBoxList(ListModel listModel) {
        super(listModel);
        this.setCheckBoxSelectableByItemClick(false);
        this.setCheckBoxSelectionModel(new CheckBoxSelectionModel(this, false));
        CheckBoxRenderer checkBoxRenderer = this.createCheckBoxRenderer(this.getCellRenderer());
        this.setCellRenderer(checkBoxRenderer);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JYCheckBoxList.this.mousePressed = true;
                int n = JYCheckBoxList.this.locationToIndex(mouseEvent.getPoint());
                if (n >= 0) {
                    JYCheckBoxList.this.clickedItem = JYCheckBoxList.this.getModel().getElementAt(n);
                    Rectangle rectangle = JYCheckBoxList.this.getCellBounds(n, n);
                    if (rectangle != null) {
                        rectangle.x = JYCheckBoxList.this.getComponentOrientation().isLeftToRight() ? (rectangle.x += JYCheckBoxList.this.getXOffset()) : rectangle.x + rectangle.width - JYCheckBoxList.this.getXOffset() - 16;
                        rectangle.width = 16;
                        JYCheckBoxList.this.checkBoxClicked = rectangle.contains(mouseEvent.getPoint());
                    }
                    ((JComponent)mouseEvent.getComponent()).repaint(rectangle);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                int n = JYCheckBoxList.this.locationToIndex(mouseEvent.getPoint());
                Rectangle rectangle = JYCheckBoxList.this.getCellBounds(n, n);
                if (rectangle != null && !JYCheckBoxList.this.isCheckBoxSelectableByItemClick()) {
                    rectangle.x = JYCheckBoxList.this.getComponentOrientation().isLeftToRight() ? (rectangle.x += JYCheckBoxList.this.getXOffset()) : rectangle.x + rectangle.width - JYCheckBoxList.this.getXOffset() - 16;
                    rectangle.width = 16;
                }
                if (n >= 0 && rectangle.contains(mouseEvent.getPoint()) && JYCheckBoxList.this.clickedItem != null) {
                    JYCheckBoxList.this.doSelection(n);
                }
                JYCheckBoxList.this.mousePressed = false;
                JYCheckBoxList.this.clickedItem = null;
                mouseEvent.getComponent().repaint();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "selectCheckBox");
        this.getActionMap().put("selectCheckBox", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JYCheckBoxList.this.getSelectedIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    JYCheckBoxList.this.doSelection(n3);
                    ++n2;
                }
            }
        });
    }

    protected CheckBoxRenderer createCheckBoxRenderer(ListCellRenderer listCellRenderer) {
        return new CheckBoxRenderer(listCellRenderer);
    }

    private int getXOffset() {
        JComponent jComponent = (JComponent)this.getCellRenderer().getListCellRendererComponent(this, 0, 0, false, false);
        return jComponent == null ? 0 : (jComponent.getComponentOrientation().isLeftToRight() ? jComponent.getInsets().left : jComponent.getInsets().right);
    }

    private void doSelection(int n) {
        if (this.isEnabled()) {
            this.selectCheckBoxItem(n, !this.checkBoxSelectionModel.isSelected(n));
        }
    }

    public void setModel(ListModel listModel) {
        this.clearCheckBoxSelection();
        super.setModel(listModel);
    }

    public void clearCheckBoxSelection() {
        CheckBoxSelectionModel checkBoxSelectionModel = this.getCheckBoxSelectionModel();
        if (checkBoxSelectionModel != null) {
            checkBoxSelectionModel.clearSelection();
        }
    }

    public int[] getSelectedCheckBoxIndices() {
        CheckBoxSelectionModel checkBoxSelectionModel = this.getCheckBoxSelectionModel();
        if (checkBoxSelectionModel == null) {
            return new int[0];
        }
        return checkBoxSelectionModel.getSelectedCheckBoxIndices();
    }

    public void setSelectedCheckBoxIndices(int ... nArray) {
        CheckBoxSelectionModel checkBoxSelectionModel = this.getCheckBoxSelectionModel();
        if (checkBoxSelectionModel != null) {
            checkBoxSelectionModel.setSelectedCheckBoxIndices(nArray);
        }
    }

    public int[] getHalfSelectedCheckBoxIndices() {
        CheckBoxSelectionModel checkBoxSelectionModel = this.getCheckBoxSelectionModel();
        if (checkBoxSelectionModel == null) {
            return new int[0];
        }
        return checkBoxSelectionModel.getHalfSelectedCheckBoxIndices();
    }

    public void setHalfSelectedCheckBoxIndices(int ... nArray) {
        CheckBoxSelectionModel checkBoxSelectionModel = this.getCheckBoxSelectionModel();
        if (checkBoxSelectionModel != null) {
            checkBoxSelectionModel.setHalfSelectedCheckBoxIndices(nArray);
        }
    }

    protected void selectCheckBoxItem(int n, boolean bl) {
        if (bl) {
            this.checkBoxSelectionModel.addSelectionInterval(n, n);
        } else {
            this.checkBoxSelectionModel.removeSelectionInterval(n, n);
        }
    }

    public void setCheckBoxSelectableByItemClick(boolean bl) {
        this.checkBoxSelectableByItemClick = bl;
    }

    public boolean isCheckBoxSelectableByItemClick() {
        return this.checkBoxSelectableByItemClick;
    }

    public CheckBoxSelectionModel getCheckBoxSelectionModel() {
        return this.checkBoxSelectionModel;
    }

    public void setCheckBoxSelectionModel(CheckBoxSelectionModel checkBoxSelectionModel) {
        this.checkBoxSelectionModel = checkBoxSelectionModel;
        this.checkBoxSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JYCheckBoxList.this.revalidate();
                JYCheckBoxList.this.repaint();
            }
        });
    }

    public class CheckBoxRenderer
    extends JYCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = -3982702802918918435L;
        private ListCellRenderer defaultRenderer;

        public CheckBoxRenderer(ListCellRenderer listCellRenderer) {
            this.defaultRenderer = listCellRenderer;
            this.setName("List.cellRenderer");
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (n >= 0) {
                if (JYCheckBoxList.this.checkBoxSelectionModel.isHalfSelected(n)) {
                    this.setState(JYCheckBox.State.HALF_SELECTED);
                } else if (JYCheckBoxList.this.checkBoxSelectionModel.isSelected(n)) {
                    this.setState(JYCheckBox.State.SELECTED);
                } else {
                    this.setState(JYCheckBox.State.DESELECTED);
                }
                if (JYCheckBoxList.this.checkBoxClicked) {
                    boolean bl3 = JYCheckBoxList.this.clickedItem == object && JYCheckBoxList.this.mousePressed;
                    this.getModel().setArmed(bl3);
                    this.getModel().setPressed(bl3);
                }
            }
            this.setText(defaultListCellRenderer.getText());
            this.setFont(defaultListCellRenderer.getFont());
            this.setForeground(defaultListCellRenderer.getForeground());
            this.setBackground(defaultListCellRenderer.getBackground());
            this.setOpaque(defaultListCellRenderer.isOpaque());
            Insets insets = SyntheticaLookAndFeel.getInsets("JYCheckBoxList.cell.insets", jList);
            this.setBorder(insets == null ? defaultListCellRenderer.getBorder() : new EmptyBorder(insets));
            if (this.getComponentOrientation() != jList.getComponentOrientation()) {
                this.setComponentOrientation(jList.getComponentOrientation());
            }
            return this;
        }

        public void validate() {
        }

        public void invalidate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        public void repaint() {
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text" || (string == "font" || string == "foreground") && object != object2 && this.getClientProperty("html") != null) {
                super.firePropertyChange(string, object, object2);
            }
        }

        public void firePropertyChange(String string, byte by, byte by2) {
        }

        public void firePropertyChange(String string, char c, char c2) {
        }

        public void firePropertyChange(String string, short s, short s2) {
        }

        public void firePropertyChange(String string, int n, int n2) {
        }

        public void firePropertyChange(String string, long l, long l2) {
        }

        public void firePropertyChange(String string, float f, float f2) {
        }

        public void firePropertyChange(String string, double d, double d2) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    public static class CheckBoxSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = 1228865802141272863L;
        protected JList list;
        private DefaultListSelectionModel halfSelectionModel;

        public CheckBoxSelectionModel(JList jList, boolean bl) {
            this.list = jList;
            if (bl) {
                this.halfSelectionModel = new DefaultListSelectionModel();
                this.halfSelectionModel.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        CheckBoxSelectionModel.this.list.revalidate();
                        CheckBoxSelectionModel.this.list.repaint();
                    }
                });
            }
        }

        public boolean hasTriStateSupport() {
            return this.halfSelectionModel != null;
        }

        public boolean isSelected(int n) {
            return this.halfSelectionModel == null ? this.isSelectedIndex(n) : this.isSelectedIndex(n) && !this.halfSelectionModel.isSelectedIndex(n);
        }

        public boolean isHalfSelected(int n) {
            return this.halfSelectionModel == null ? false : this.isSelectedIndex(n) && this.halfSelectionModel.isSelectedIndex(n);
        }

        public void setSelectionInterval(int n, int n2) {
            if (this.list.getModel() != null) {
                if (this.halfSelectionModel != null) {
                    int n3 = n;
                    while (n3 <= n2) {
                        if (this.halfSelectionModel.isSelectedIndex(n3)) {
                            this.halfSelectionModel.removeSelectionInterval(n, n);
                        } else {
                            this.halfSelectionModel.setSelectionInterval(n, n);
                        }
                        ++n3;
                    }
                }
                super.setSelectionInterval(n, n2);
            }
        }

        public void addSelectionInterval(int n, int n2) {
            if (this.list.getModel() != null) {
                if (this.halfSelectionModel != null) {
                    int n3 = n;
                    while (n3 <= n2) {
                        if (this.halfSelectionModel.isSelectedIndex(n3)) {
                            this.halfSelectionModel.removeSelectionInterval(n, n);
                        } else {
                            this.halfSelectionModel.addSelectionInterval(n, n);
                        }
                        ++n3;
                    }
                }
                super.addSelectionInterval(n, n2);
            }
        }

        public void removeSelectionInterval(int n, int n2) {
            if (this.list.getModel() != null) {
                if (this.halfSelectionModel != null) {
                    int n3 = n;
                    while (n3 <= n2) {
                        if (this.isHalfSelected(n3)) {
                            this.halfSelectionModel.removeSelectionInterval(n, n);
                        } else {
                            super.removeSelectionInterval(n, n);
                        }
                        ++n3;
                    }
                    return;
                }
                super.removeSelectionInterval(n, n2);
            }
        }

        public void clearSelection() {
            if (this.list.getModel() != null) {
                if (this.halfSelectionModel != null) {
                    this.halfSelectionModel.clearSelection();
                }
                super.clearSelection();
            }
        }

        public void setHalfSelectionInterval(int n, int n2) {
            if (this.list.getModel() != null && this.halfSelectionModel != null) {
                this.halfSelectionModel.setSelectionInterval(n, n2);
                super.setSelectionInterval(n, n2);
            }
        }

        public void addHalfSelectionInterval(int n, int n2) {
            if (this.list.getModel() != null && this.halfSelectionModel != null) {
                this.halfSelectionModel.addSelectionInterval(n, n2);
                super.addSelectionInterval(n, n2);
            }
        }

        public void removeHalfSelectionInterval(int n, int n2) {
            if (this.list.getModel() != null && this.halfSelectionModel != null) {
                this.halfSelectionModel.removeSelectionInterval(n, n2);
                super.removeSelectionInterval(n, n2);
            }
        }

        public int[] getSelectedCheckBoxIndices() {
            int n = this.getMinSelectionIndex();
            int n2 = this.getMaxSelectionIndex();
            if (n < 0 || n2 < 0) {
                return new int[0];
            }
            int[] nArray = new int[n2 - n + 1];
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.isSelected(n4)) {
                    nArray[n3++] = n4;
                }
                ++n4;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }

        public void setSelectedCheckBoxIndices(int ... nArray) {
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                super.addSelectionInterval(n2, n2);
                ++n;
            }
        }

        public int[] getHalfSelectedCheckBoxIndices() {
            if (this.halfSelectionModel == null) {
                return new int[0];
            }
            int n = this.halfSelectionModel.getMinSelectionIndex();
            int n2 = this.halfSelectionModel.getMaxSelectionIndex();
            if (n < 0 || n2 < 0) {
                return new int[0];
            }
            int[] nArray = new int[n2 - n + 1];
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.isHalfSelected(n4)) {
                    nArray[n3++] = n4;
                }
                ++n4;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }

        public void setHalfSelectedCheckBoxIndices(int ... nArray) {
            if (this.halfSelectionModel == null) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                this.addHalfSelectionInterval(n2, n2);
                ++n;
            }
        }
    }
}

