/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class JYCheckBoxTree
extends JTree {
    private static final long serialVersionUID = 4472927255942543844L;
    private CheckBoxSelectionModel checkBoxSelectionModel;
    private boolean checkBoxSelectableByNodeClick;
    private boolean mousePressed;
    private Object clickedNode;
    private boolean checkBoxClicked;
    private int checkBoxWidth;

    public JYCheckBoxTree() {
        this(new DefaultMutableTreeNode("RootNode"));
    }

    public JYCheckBoxTree(TreeNode treeNode) {
        super(treeNode);
        this.setCheckBoxSelectableByNodeClick(true);
        this.setCheckBoxSelectionModel(new CheckBoxSelectionModel(this));
        CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer(this.getCellRenderer());
        this.setCellRenderer(checkBoxRenderer);
        this.checkBoxWidth = SyntheticaLookAndFeel.getInsets((String)"JYCheckBoxTree.cell.insets", (Component)this, (boolean)false).left + UIManager.getIcon("CheckBox.icon").getIconWidth();
        this.setToggleClickCount(-1);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                JYCheckBoxTree.this.mousePressed = true;
                TreePath treePath = JYCheckBoxTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    JYCheckBoxTree.this.clickedNode = treePath.getLastPathComponent();
                    Rectangle rectangle = JYCheckBoxTree.this.getPathBounds(treePath);
                    if (rectangle != null) {
                        rectangle.width = JYCheckBoxTree.this.checkBoxWidth;
                        JYCheckBoxTree.this.checkBoxClicked = rectangle.contains(mouseEvent.getPoint());
                    }
                    ((JComponent)mouseEvent.getComponent()).repaint(rectangle);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                TreePath treePath = JYCheckBoxTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                Rectangle rectangle = JYCheckBoxTree.this.getPathBounds(treePath);
                if (rectangle != null && !JYCheckBoxTree.this.isCheckBoxSelectableByNodeClick()) {
                    rectangle.width = JYCheckBoxTree.this.checkBoxWidth;
                }
                if (treePath != null && rectangle.contains(mouseEvent.getPoint()) && JYCheckBoxTree.this.clickedNode != null) {
                    JYCheckBoxTree.this.doSelection(treePath);
                }
                JYCheckBoxTree.this.mousePressed = false;
                JYCheckBoxTree.this.clickedNode = null;
                mouseEvent.getComponent().repaint();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "selectCheckBox");
        this.getActionMap().put("selectCheckBox", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray;
                TreePath[] treePathArray2 = treePathArray = JYCheckBoxTree.this.getSelectionPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath treePath = treePathArray2[n2];
                    JYCheckBoxTree.this.doSelection(treePath);
                    ++n2;
                }
            }
        });
    }

    void doSelection(TreePath treePath) {
        if (this.isEnabled()) {
            this.selectCheckBoxPath(treePath, !this.checkBoxSelectionModel.isPathSelected(treePath));
        }
    }

    public void setModel(TreeModel treeModel) {
        this.clearCheckBoxSelection();
        super.setModel(treeModel);
    }

    public void clearCheckBoxSelection() {
        CheckBoxSelectionModel checkBoxSelectionModel = this.getCheckBoxSelectionModel();
        if (checkBoxSelectionModel != null) {
            checkBoxSelectionModel.clearSelection();
        }
    }

    protected void selectCheckBoxPath(TreePath treePath, boolean bl) {
        if (bl) {
            this.checkBoxSelectionModel.addSelectionPath(treePath);
        } else {
            this.checkBoxSelectionModel.removeSelectionPath(treePath);
        }
    }

    public void setCheckBoxSelectableByNodeClick(boolean bl) {
        this.checkBoxSelectableByNodeClick = bl;
    }

    public boolean isCheckBoxSelectableByNodeClick() {
        return this.checkBoxSelectableByNodeClick;
    }

    public CheckBoxSelectionModel getCheckBoxSelectionModel() {
        return this.checkBoxSelectionModel;
    }

    public void setCheckBoxSelectionModel(CheckBoxSelectionModel checkBoxSelectionModel) {
        this.checkBoxSelectionModel = checkBoxSelectionModel;
        this.checkBoxSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                JYCheckBoxTree.this.treeDidChange();
            }
        });
    }

    public void updateUI() {
        boolean bl = this.ui != null;
        super.updateUI();
        if (bl) {
            ((BasicTreeUI)this.getUI()).uninstallUI(this);
            ((BasicTreeUI)this.getUI()).installUI(this);
        }
    }

    public class CheckBoxRenderer
    extends JYCheckBox
    implements TreeCellRenderer,
    UIResource {
        private static final long serialVersionUID = 6353437826308600712L;
        private TreeCellRenderer defaultRenderer;

        public CheckBoxRenderer(TreeCellRenderer treeCellRenderer) {
            this.defaultRenderer = treeCellRenderer;
            this.setName("JYCheckBoxTree.cellRenderer");
        }

        public void updateUI() {
            super.updateUI();
            if (this.defaultRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.defaultRenderer;
                DefaultTreeCellRenderer defaultTreeCellRenderer2 = new DefaultTreeCellRenderer();
                defaultTreeCellRenderer.setTextNonSelectionColor(defaultTreeCellRenderer2.getTextNonSelectionColor());
                defaultTreeCellRenderer.setTextSelectionColor(defaultTreeCellRenderer2.getTextSelectionColor());
                defaultTreeCellRenderer.setBackgroundNonSelectionColor(defaultTreeCellRenderer2.getBackgroundNonSelectionColor());
                defaultTreeCellRenderer.setBackgroundSelectionColor(defaultTreeCellRenderer2.getBackgroundSelectionColor());
                defaultTreeCellRenderer.setFont(defaultTreeCellRenderer2.getFont());
            }
        }

        public Icon getDefaultTreeLeafIcon() {
            return this.defaultRenderer instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)this.defaultRenderer).getDefaultLeafIcon() : null;
        }

        public Icon getDefaultTreeOpenIcon() {
            return this.defaultRenderer instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)this.defaultRenderer).getDefaultOpenIcon() : null;
        }

        public Icon getDefaultTreeClosedIcon() {
            return this.defaultRenderer instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)this.defaultRenderer).getDefaultClosedIcon() : null;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.defaultRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            TreePath treePath = jTree.getPathForRow(n);
            if (treePath != null) {
                if (JYCheckBoxTree.this.checkBoxSelectionModel.isPathSelected(treePath)) {
                    this.setState(JYCheckBox.State.SELECTED);
                } else {
                    this.setState(JYCheckBoxTree.this.checkBoxSelectionModel.isPartiallySelected(treePath) ? JYCheckBox.State.HALF_SELECTED : JYCheckBox.State.DESELECTED);
                }
                if (JYCheckBoxTree.this.checkBoxClicked) {
                    boolean bl5 = JYCheckBoxTree.this.clickedNode == object && JYCheckBoxTree.this.mousePressed;
                    this.getModel().setArmed(bl5);
                    this.getModel().setPressed(bl5);
                }
            }
            this.setText(defaultTreeCellRenderer.getText());
            this.setFont(defaultTreeCellRenderer.getFont());
            this.setForeground(bl ? defaultTreeCellRenderer.getTextSelectionColor() : defaultTreeCellRenderer.getTextNonSelectionColor());
            this.setBackground(bl ? defaultTreeCellRenderer.getBackgroundSelectionColor() : defaultTreeCellRenderer.getBackgroundNonSelectionColor());
            Insets insets = SyntheticaLookAndFeel.getInsets("JYCheckBoxTree.cell.insets", jTree);
            this.setBorder(insets == null ? defaultTreeCellRenderer.getBorder() : new EmptyBorder(insets));
            return this;
        }

        public void validate() {
        }

        public void invalidate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        public void repaint() {
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text" || (string == "font" || string == "foreground") && object != object2 && this.getClientProperty("html") != null) {
                super.firePropertyChange(string, object, object2);
            }
        }

        public void firePropertyChange(String string, byte by, byte by2) {
        }

        public void firePropertyChange(String string, char c, char c2) {
        }

        public void firePropertyChange(String string, short s, short s2) {
        }

        public void firePropertyChange(String string, int n, int n2) {
        }

        public void firePropertyChange(String string, long l, long l2) {
        }

        public void firePropertyChange(String string, float f, float f2) {
        }

        public void firePropertyChange(String string, double d, double d2) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    public static class CheckBoxSelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -1526281621712666620L;
        protected JTree tree;

        public CheckBoxSelectionModel(JTree jTree) {
            this.tree = jTree;
            this.setSelectionMode(4);
        }

        public boolean isPartiallySelected(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            TreeModel treeModel = this.tree.getModel();
            if (treeModel == null) {
                return false;
            }
            int n = treeModel.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = treeModel.getChild(object, n2);
                TreePath treePath2 = treePath.pathByAddingChild(object2);
                if (this.isPathSelected(treePath2) || this.isPartiallySelected(treePath2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
            throw new UnsupportedOperationException();
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
            super.addSelectionPaths(treePathArray);
            HashSet<TreePath> hashSet = new HashSet<TreePath>();
            TreePath[] treePathArray2 = treePathArray;
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray2[n2];
                TreePath treePath2 = treePath.getParentPath();
                if (treePath2 == null) {
                    this.selectPath(treePath, true);
                } else if (!hashSet.contains(treePath2)) {
                    this.selectPath(treePath, true);
                    hashSet.add(treePath2);
                }
                ++n2;
            }
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
            super.removeSelectionPaths(treePathArray);
            HashSet<TreePath> hashSet = new HashSet<TreePath>();
            TreePath[] treePathArray2 = treePathArray;
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray2[n2];
                TreePath treePath2 = treePath.getParentPath();
                if (treePath2 == null) {
                    this.selectPath(treePath, false);
                } else if (!hashSet.contains(treePath2)) {
                    this.selectPath(treePath, false);
                    hashSet.add(treePath2);
                }
                ++n2;
            }
        }

        protected void selectPath(TreePath treePath, boolean bl) {
            TreeModel treeModel = this.tree.getModel();
            if (treeModel == null) {
                return;
            }
            this.selectPath_(treePath, bl);
            TreePath treePath2 = treePath.getParentPath();
            while (treePath2 != null) {
                super.addSelectionPaths(new TreePath[]{treePath2});
                Object object = treePath2.getLastPathComponent();
                int n = treeModel.getChildCount(object);
                int n2 = 0;
                while (n2 < n) {
                    Object object2 = treeModel.getChild(object, n2);
                    TreePath treePath3 = treePath2.pathByAddingChild(object2);
                    if (!this.isPathSelected(treePath3)) {
                        super.removeSelectionPaths(new TreePath[]{treePath2});
                        break;
                    }
                    ++n2;
                }
                treePath2 = treePath2.getParentPath();
            }
        }

        private void selectPath_(TreePath treePath, boolean bl) {
            Object object = treePath.getLastPathComponent();
            if (bl) {
                super.addSelectionPaths(new TreePath[]{treePath});
            } else {
                super.removeSelectionPaths(new TreePath[]{treePath});
            }
            TreeModel treeModel = this.tree.getModel();
            int n = treeModel.getChildCount(object);
            TreePath[] treePathArray = new TreePath[n];
            int n2 = 0;
            while (n2 < n) {
                Object object2 = treeModel.getChild(object, n2);
                TreePath treePath2 = treePath.pathByAddingChild(object2);
                if (treeModel.getChildCount(object2) > 0) {
                    this.selectPath_(treePath2, bl);
                } else {
                    treePathArray[n2] = treePath2;
                }
                ++n2;
            }
            if (bl) {
                super.addSelectionPaths(treePathArray);
            } else {
                super.removeSelectionPaths(treePathArray);
            }
        }
    }

    public static class CheckBoxTreeRenderer
    implements TreeCellRenderer {
        private CheckBoxRenderer checkBoxRenderer;
        private Icon openIcon;
        private Icon closedIcon;
        private Icon leafIcon;
        private int cacheHash;
        private JPanel panel;
        private JLabel label;

        public CheckBoxTreeRenderer(CheckBoxRenderer checkBoxRenderer) {
            this.checkBoxRenderer = checkBoxRenderer;
            this.label = new JRendererLabel();
            this.label.setOpaque(!SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.selectionBackground.enabled", null));
            this.panel = new JPanel(new BorderLayout()){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = this.getInsets().left + this.getInsets().right;
                    Component[] componentArray = CheckBoxTreeRenderer.this.panel.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component component = componentArray[n2];
                        dimension.width += component.getPreferredSize().width;
                        ++n2;
                    }
                    return dimension;
                }
            };
            this.panel.setOpaque(false);
            this.panel.add(this.label);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JYCheckBox jYCheckBox = (JYCheckBox)this.checkBoxRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            jYCheckBox.setText("");
            int n2 = this.calcCacheHash(jYCheckBox, object, bl, bl2, bl3, n, bl4);
            if (n2 == this.cacheHash) {
                this.label.setText(object.toString());
                return this.panel;
            }
            this.cacheHash = n2;
            this.panel.add((Component)jYCheckBox, "West");
            this.label.setText(object.toString());
            if (bl3) {
                this.label.setIcon(this.leafIcon == null ? this.checkBoxRenderer.getDefaultTreeLeafIcon() : this.leafIcon);
            } else {
                this.label.setIcon(bl2 ? (this.openIcon == null ? this.checkBoxRenderer.getDefaultTreeOpenIcon() : this.openIcon) : (this.closedIcon == null ? this.checkBoxRenderer.getDefaultTreeClosedIcon() : this.closedIcon));
            }
            this.label.setForeground(jYCheckBox.getForeground());
            this.label.setBackground(jYCheckBox.getBackground());
            return this.panel;
        }

        private int calcCacheHash(JYCheckBox jYCheckBox, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            int n2 = n;
            n2 = 31 * n2 + (jYCheckBox.getModel().isPressed() ? 0 : 1);
            n2 = 31 * n2 + (bl ? 0 : 1);
            n2 = 31 * n2 + (bl2 ? 0 : 1);
            n2 = 31 * n2 + (bl3 ? 0 : 1);
            n2 = 31 * n2 + (bl4 ? 0 : 1);
            return n2;
        }

        public void setOpenIcon(Icon icon) {
            this.openIcon = icon;
        }

        public Icon getOpenIcon() {
            return this.openIcon;
        }

        public void setClosedIcon(Icon icon) {
            this.closedIcon = icon;
        }

        public Icon getClosedIcon() {
            return this.closedIcon;
        }

        public void setLeafIcon(Icon icon) {
            this.leafIcon = icon;
        }

        public Icon getLeafIcon() {
            return this.leafIcon;
        }
    }
}

