/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.JYTabbedPanePainter;
import de.javasoft.swing.IUIPropertySupport;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.JYTabbedPaneUI;
import de.javasoft.swing.plaf.UIValue;
import de.javasoft.swing.plaf.addons.JYTabbedPaneAddon;
import de.javasoft.swing.plaf.basic.BasicJYTabbedPaneUI;
import de.javasoft.swing.plaf.jytabbedpane.ICloseButtonStrategy;
import de.javasoft.swing.plaf.jytabbedpane.Tab;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JYTabbedPane
extends JTabbedPane
implements IUIPropertySupport {
    private static final long serialVersionUID = 4072790590414750617L;
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    public static final String uiClassID = "JYTabbedPaneUI";
    private JPanel contentPanel;
    private JComponent leadingTabAreaComponent;
    private JComponent trailingTabAreaComponent;
    private UIValue<Boolean> paintSelectedTabBold;
    private UIValue<Integer> tabGap;
    private UIValue<Integer> hTabAlign;
    private UIValue<Integer> vTabAlign;
    private UIValue<TabControlsShowStrategy> tabControlsShowStrategy;
    private UIValue<TabControlsPosition> tabControlsPosition;
    private UIValue<Boolean> showScrollButtons;
    private UIValue<Boolean> showPopupButton;
    private UIValue<Boolean> overlapTabsInvers;
    private UIValue<ICloseButtonStrategy> closeButtonStrategy;
    private UIValue<TabStyle> tabStyle;
    private UIValue<Boolean> tabScrollAnimationEnabled;
    private UIValue<Boolean> tabReorderByDraggingEnabled;
    private UIValue<Integer> minimumTabSize;
    private UIValue<Integer> maximumTabSize;
    private UIValue<Boolean> tabsStretchedEnabled;
    private UIValue<Boolean> tabRotationEnabled;
    private UIValue<Boolean> showPlusButton;
    private boolean tabsEditable;
    private TabHistoryHandler tabHistoryHandler;
    private boolean tabRemove;
    private boolean tabInsert;
    private boolean tabMove;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYTabbedPaneAddon());
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, JYTabbedPaneUI.class));
    }

    @Override
    public Component add(Component component) {
        return super.add(component);
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!(component instanceof UIResource)) {
            this.getContentPanel().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new ContentPanel();
        }
        return this.contentPanel;
    }

    public void setLeadingTabAreaComponent(JComponent jComponent) {
        if (jComponent != this.leadingTabAreaComponent) {
            JComponent jComponent2 = this.leadingTabAreaComponent;
            this.leadingTabAreaComponent = jComponent;
            this.firePropertyChange("leadingTabAreaComponent", jComponent2, jComponent);
        }
    }

    public JComponent getLeadingTabAreaComponent() {
        return this.leadingTabAreaComponent;
    }

    public void setTrailingTabAreaComponent(JComponent jComponent) {
        if (jComponent != this.trailingTabAreaComponent) {
            JComponent jComponent2 = this.trailingTabAreaComponent;
            this.trailingTabAreaComponent = jComponent;
            this.firePropertyChange("trailingTabAreaComponent", jComponent2, jComponent);
        }
    }

    public JComponent getTrailingTabAreaComponent() {
        return this.trailingTabAreaComponent;
    }

    public void moveTab(int n, int n2) {
        JLabel jLabel;
        if (n == n2) {
            return;
        }
        this.tabMove = true;
        String string = this.getTitleAt(n);
        Icon icon = this.getIconAt(n);
        Component component = this.getComponentAt(n);
        String string2 = this.getToolTipTextAt(n);
        boolean bl = this.isEnabledAt(n);
        int n3 = this.getMnemonicAt(n);
        Component component2 = null;
        if (!JAVA5) {
            component2 = this.getTabComponentAt(n);
        }
        int n4 = (jLabel = this.getTabLabelAt(n)) == null ? 0 : jLabel.getHorizontalTextPosition();
        int n5 = jLabel == null ? 0 : jLabel.getVerticalTextPosition();
        int n6 = jLabel == null ? 0 : jLabel.getHorizontalAlignment();
        int n7 = jLabel == null ? 0 : jLabel.getVerticalAlignment();
        Color color = this.getTabBackground(n);
        Float f = this.getTabAlpha(n);
        this.removeTabAt(n);
        this.insertTab(string, icon, component, string2, n2);
        this.setEnabledAt(n2, bl);
        this.setSelectedIndex(bl ? n2 : n);
        this.setMnemonicAt(n2, n3);
        if (!JAVA5) {
            this.setTabComponentAt(n2, component2);
        }
        if ((jLabel = this.getTabLabelAt(n2)) != null) {
            jLabel.setHorizontalTextPosition(n4);
            jLabel.setVerticalTextPosition(n5);
            jLabel.setHorizontalAlignment(n6);
            jLabel.setVerticalAlignment(n7);
        }
        this.setTabBackground(color, f, n2);
        this.tabMove = false;
        if (this.isTabHistoryEnabled()) {
            this.tabHistoryHandler.updateSelectedIndex(this.getSelectedIndex());
        }
    }

    public void setTabBackgroundAt(Color color, int n) {
        float f = (float)color.getAlpha() / 255.0f;
        this.setTabBackground(new Color(color.getRGB() & 0xFFFFFF), Float.valueOf(f), n);
    }

    public Color getTabBackgroundAt(int n) {
        Color color = this.getTabBackground(n);
        float f = this.getTabAlpha(n).floatValue();
        return new Color((int)(255.0f * f) << 24 | 0xFFFFFF & color.getRGB(), true);
    }

    private void setTabBackground(Color color, Float f, int n) {
        this.putClientProperty("Synthetica.tabbedPane.tab." + n + ".background", color);
        this.putClientProperty("Synthetica.tabbedPane.tab." + n + ".background.alpha", f);
    }

    private Color getTabBackground(int n) {
        return (Color)this.getClientProperty("Synthetica.tabbedPane.tab." + n + ".background");
    }

    private Float getTabAlpha(int n) {
        return (Float)this.getClientProperty("Synthetica.tabbedPane.tab." + n + ".background.alpha");
    }

    public void setSelectedIndex(final int n, boolean bl) {
        this.setSelectedIndex(n);
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Action action = JYTabbedPane.this.getActionMap().get("scrollTabIndexToVisible");
                    action.actionPerformed(new ActionEvent(this, 1001, String.valueOf(n)));
                }
            });
        }
    }

    @Override
    public void addTab(String string, Component component) {
        super.addTab(string, component);
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        this.tabInsert = true;
        int n2 = this.getTabCount();
        while (n2 > n) {
            Color color = this.getTabBackground(n2 - 1);
            Float f = this.getTabAlpha(n2 - 1);
            this.setTabBackground(color, f, n2);
            --n2;
        }
        this.setTabBackground(null, null, n);
        super.insertTab(string, icon, component, string2, n);
        this.firePropertyChange("insertTab", null, (Object)n);
        this.tabInsert = false;
        if (this.isTabHistoryEnabled()) {
            this.tabHistoryHandler.updateSelectedIndex(this.getSelectedIndex());
        }
    }

    @Override
    public void removeTabAt(int n) {
        this.tabRemove = true;
        int n2 = n;
        while (n2 < this.getTabCount() - 1) {
            Color color = this.getTabBackground(n2 + 1);
            Float f = this.getTabAlpha(n2 + 1);
            this.setTabBackground(color, f, n2);
            ++n2;
        }
        this.setTabBackground(null, null, this.getTabCount() - 1);
        Component component = this.getComponentAt(n);
        if (component != null) {
            this.getContentPanel().remove(component);
            component.setVisible(true);
        }
        super.removeTabAt(n);
        this.firePropertyChange("removeTab", null, (Object)n);
        this.tabRemove = false;
    }

    @Override
    public void setTitleAt(int n, String string) {
        super.setTitleAt(n, string);
        this.firePropertyChange("title", -1, n);
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        super.setIconAt(n, icon);
        this.firePropertyChange("icon", -1, n);
    }

    @Override
    public void setToolTipTextAt(int n, String string) {
        super.setToolTipTextAt(n, string);
        this.firePropertyChange("toolTipText", -1, n);
    }

    @Override
    public void setMnemonicAt(int n, int n2) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(n2, 8), "setSelectedTabIndex");
        this.getTabLabelAt(n).setDisplayedMnemonic(n2);
        super.setMnemonicAt(n, n2);
    }

    public JLabel getTabLabelAt(int n) {
        BasicJYTabbedPaneUI.TabsPanel tabsPanel = this.getTabsPanel();
        Tab tab = tabsPanel.getTab(n);
        return tab == null ? null : (tab.getComponent() instanceof JLabel ? (JLabel)tab.getComponent() : null);
    }

    public void setTabVisible(int n, boolean bl) {
        if (!bl && this.getSelectedIndex() == n) {
            this.setSelectedIndex(n + 1 < this.getTabCount() ? n + 1 : n - 1);
        }
        this.getTabsPanel().getTab(n).setVisible(bl);
    }

    public boolean isTabVisible(int n) {
        return this.getTabsPanel().getTab(n).isVisible();
    }

    public void setTabsEditable(boolean bl) {
        boolean bl2 = this.tabsEditable;
        this.tabsEditable = bl;
        this.firePropertyChange("tabsEditable", bl2, bl);
    }

    public boolean getTabsEditable() {
        return this.tabsEditable;
    }

    public void setTabHistoryEnabled(boolean bl) {
        boolean bl2 = this.isTabHistoryEnabled();
        if (bl2 == bl) {
            return;
        }
        if (bl) {
            this.tabHistoryHandler = new TabHistoryHandler();
            this.addPropertyChangeListener(this.tabHistoryHandler);
            this.addChangeListener(this.tabHistoryHandler);
        } else {
            this.removePropertyChangeListener(this.tabHistoryHandler);
            this.removeChangeListener(this.tabHistoryHandler);
            this.tabHistoryHandler = null;
        }
        this.firePropertyChange("tabHistoryEnabled", bl2, bl);
    }

    public boolean isTabHistoryEnabled() {
        return this.tabHistoryHandler != null;
    }

    public void setPaintSelectedTabBold(Boolean bl) {
        this.setPaintSelectedTabBold(bl, false);
    }

    public void setPaintSelectedTabBold(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "paintSelectedTabBold", this.paintSelectedTabBold, this.getPaintSelectedTabBold(), bl, bl2, true, true);
    }

    public boolean paintSelectedTabBoldIsUIResource() {
        return this.getPaintSelectedTabBoldUIValue().isUIResource();
    }

    public Boolean getPaintSelectedTabBold() {
        return this.getPaintSelectedTabBoldUIValue().get();
    }

    private UIValue<Boolean> getPaintSelectedTabBoldUIValue() {
        if (this.paintSelectedTabBold == null) {
            this.paintSelectedTabBold = new UIValue();
        }
        return this.paintSelectedTabBold;
    }

    public void setTabGap(Integer n) {
        this.setTabGap(n, false);
    }

    public void setTabGap(Integer n, boolean bl) {
        WidgetUtils.setUIProperty(this, "tabGap", this.tabGap, this.getTabGap(), n, bl, false, false);
    }

    public boolean tabGapIsUIResource() {
        return this.getTabGapUIValue().isUIResource();
    }

    public Integer getTabGap() {
        return this.getTabGapUIValue().get();
    }

    private UIValue<Integer> getTabGapUIValue() {
        if (this.tabGap == null) {
            this.tabGap = new UIValue();
        }
        return this.tabGap;
    }

    public void setHorizontalTabAlignment(Integer n) {
        this.setHorizontalTabAlignment(n, false);
    }

    public void setHorizontalTabAlignment(Integer n, boolean bl) {
        WidgetUtils.setUIProperty(this, "horizontalTabAlignment", this.hTabAlign, this.getHorizontalTabAlignment(), n, bl, false, false);
    }

    public boolean horizontalTabAlignmentIsUIResource() {
        return this.getHorizontalTabAlignmentUIValue().isUIResource();
    }

    public Integer getHorizontalTabAlignment() {
        return this.getHorizontalTabAlignmentUIValue().get();
    }

    private UIValue<Integer> getHorizontalTabAlignmentUIValue() {
        if (this.hTabAlign == null) {
            this.hTabAlign = new UIValue();
        }
        return this.hTabAlign;
    }

    public void setVerticalTabAlignment(Integer n) {
        this.setVerticalTabAlignment(n, false);
    }

    public void setVerticalTabAlignment(Integer n, boolean bl) {
        WidgetUtils.setUIProperty(this, "verticalTabAlignment", this.vTabAlign, this.getVerticalTabAlignment(), n, bl, false, false);
    }

    public boolean verticalTabAlignmentIsUIResource() {
        return this.getVerticalTabAlignmentUIValue().isUIResource();
    }

    public Integer getVerticalTabAlignment() {
        return this.getVerticalTabAlignmentUIValue().get();
    }

    private UIValue<Integer> getVerticalTabAlignmentUIValue() {
        if (this.vTabAlign == null) {
            this.vTabAlign = new UIValue();
        }
        return this.vTabAlign;
    }

    public void setTabControlsShowStrategy(TabControlsShowStrategy tabControlsShowStrategy) {
        this.setTabControlsShowStrategy(tabControlsShowStrategy, false);
    }

    public void setTabControlsShowStrategy(TabControlsShowStrategy tabControlsShowStrategy, boolean bl) {
        WidgetUtils.setUIProperty(this, "tabControlsShowStrategy", this.tabControlsShowStrategy, this.getTabControlsShowStrategy(), tabControlsShowStrategy, bl, true, true);
    }

    public boolean tabControlsShowStrategyIsUIResource() {
        return this.getTabControlsShowStrategyUIValue().isUIResource();
    }

    public TabControlsShowStrategy getTabControlsShowStrategy() {
        return this.getTabControlsShowStrategyUIValue().get();
    }

    private UIValue<TabControlsShowStrategy> getTabControlsShowStrategyUIValue() {
        if (this.tabControlsShowStrategy == null) {
            this.tabControlsShowStrategy = new UIValue();
        }
        return this.tabControlsShowStrategy;
    }

    public void setTabControlsPosition(TabControlsPosition tabControlsPosition) {
        this.setTabControlsPosition(tabControlsPosition, false);
    }

    public void setTabControlsPosition(TabControlsPosition tabControlsPosition, boolean bl) {
        WidgetUtils.setUIProperty(this, "tabControlsPosition", this.tabControlsPosition, this.getTabControlsPosition(), tabControlsPosition, bl, false, false);
    }

    public boolean tabControlsPositionIsUIResource() {
        return this.getTabControlsPositionUIValue().isUIResource();
    }

    public TabControlsPosition getTabControlsPosition() {
        return this.getTabControlsPositionUIValue().get();
    }

    private UIValue<TabControlsPosition> getTabControlsPositionUIValue() {
        if (this.tabControlsPosition == null) {
            this.tabControlsPosition = new UIValue();
        }
        return this.tabControlsPosition;
    }

    public void setTabStyle(TabStyle tabStyle) {
        this.setTabStyle(tabStyle, false);
    }

    public void setTabStyle(TabStyle tabStyle, boolean bl) {
        WidgetUtils.setUIProperty(this, "tabStyle", this.tabStyle, this.getTabStyle(), tabStyle, bl, false, true);
    }

    public boolean tabStyleIsUIResource() {
        return this.getTabStyleUIValue().isUIResource();
    }

    public TabStyle getTabStyle() {
        return this.getTabStyleUIValue().get();
    }

    private UIValue<TabStyle> getTabStyleUIValue() {
        if (this.tabStyle == null) {
            this.tabStyle = new UIValue();
        }
        return this.tabStyle;
    }

    public void setShowScrollButtons(Boolean bl) {
        this.setShowScrollButtons(bl, false);
    }

    public void setShowScrollButtons(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "showScrollButtons", this.showScrollButtons, this.getShowScrollButtons(), bl, bl2, false, false);
    }

    public boolean showScrollButtonsIsUIResource() {
        return this.getShowScrollButtonsUIValue().isUIResource();
    }

    public Boolean getShowScrollButtons() {
        return this.getShowScrollButtonsUIValue().get();
    }

    private UIValue<Boolean> getShowScrollButtonsUIValue() {
        if (this.showScrollButtons == null) {
            this.showScrollButtons = new UIValue();
        }
        return this.showScrollButtons;
    }

    public void setShowPopupButton(Boolean bl) {
        this.setShowPopupButton(bl, false);
    }

    public void setShowPopupButton(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "showPopupButton", this.showPopupButton, this.getShowPopupButton(), bl, bl2, false, false);
    }

    public boolean showPopupButtonIsUIResource() {
        return this.getShowPopupButtonUIValue().isUIResource();
    }

    public Boolean getShowPopupButton() {
        return this.getShowPopupButtonUIValue().get();
    }

    private UIValue<Boolean> getShowPopupButtonUIValue() {
        if (this.showPopupButton == null) {
            this.showPopupButton = new UIValue();
        }
        return this.showPopupButton;
    }

    public void setOverlapTabsInvers(Boolean bl) {
        this.setOverlapTabsInvers(bl, false);
    }

    public void setOverlapTabsInvers(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "overlapTabsInvers", this.overlapTabsInvers, this.getOverlapTabsInvers(), bl, bl2, false, true);
    }

    public boolean overlapTabsInversIsUIResource() {
        return this.getOverlapTabsInversUIValue().isUIResource();
    }

    public Boolean getOverlapTabsInvers() {
        return this.getOverlapTabsInversUIValue().get();
    }

    private UIValue<Boolean> getOverlapTabsInversUIValue() {
        if (this.overlapTabsInvers == null) {
            this.overlapTabsInvers = new UIValue();
        }
        return this.overlapTabsInvers;
    }

    public void setCloseButtonStrategy(ICloseButtonStrategy iCloseButtonStrategy) {
        this.setCloseButtonStrategy(iCloseButtonStrategy, false);
    }

    public void setCloseButtonStrategy(ICloseButtonStrategy iCloseButtonStrategy, boolean bl) {
        WidgetUtils.setUIProperty(this, "closeButtonStrategy", this.closeButtonStrategy, this.getCloseButtonStrategy(), iCloseButtonStrategy, bl, true, true);
    }

    public boolean closeButtonStrategyIsUIResource() {
        return this.getCloseButtonStrategyUIValue().isUIResource();
    }

    public ICloseButtonStrategy getCloseButtonStrategy() {
        return this.getCloseButtonStrategyUIValue().get();
    }

    private UIValue<ICloseButtonStrategy> getCloseButtonStrategyUIValue() {
        if (this.closeButtonStrategy == null) {
            this.closeButtonStrategy = new UIValue();
        }
        return this.closeButtonStrategy;
    }

    public void setTabScrollAnimationEnabled(Boolean bl) {
        this.setTabScrollAnimationEnabled(bl, false);
    }

    public void setTabScrollAnimationEnabled(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "tabScrollAnimationEnabled", this.tabScrollAnimationEnabled, this.getTabScrollAnimationEnabled(), bl, bl2, false, false);
    }

    public boolean tabScrollAnimationEnabledIsUIResource() {
        return this.getTabScrollAnimationEnabledUIValue().isUIResource();
    }

    public Boolean getTabScrollAnimationEnabled() {
        return this.getTabScrollAnimationEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabScrollAnimationEnabledUIValue() {
        if (this.tabScrollAnimationEnabled == null) {
            this.tabScrollAnimationEnabled = new UIValue();
        }
        return this.tabScrollAnimationEnabled;
    }

    public void setTabReorderByDraggingEnabled(Boolean bl) {
        this.setTabReorderByDraggingEnabled(bl, false);
    }

    public void setTabReorderByDraggingEnabled(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "tabReorderByDraggingEnabled", this.tabReorderByDraggingEnabled, this.getTabReorderByDraggingEnabled(), bl, bl2, false, false);
    }

    public boolean tabReorderByDraggingEnabledIsUIResource() {
        return this.getTabReorderByDraggingEnabledUIValue().isUIResource();
    }

    public Boolean getTabReorderByDraggingEnabled() {
        return this.getTabReorderByDraggingEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabReorderByDraggingEnabledUIValue() {
        if (this.tabReorderByDraggingEnabled == null) {
            this.tabReorderByDraggingEnabled = new UIValue();
        }
        return this.tabReorderByDraggingEnabled;
    }

    public void setMinimumTabSize(Integer n) {
        this.setMinimumTabSize(n, false);
    }

    public void setMinimumTabSize(Integer n, boolean bl) {
        WidgetUtils.setUIProperty(this, "minimumTabSize", this.minimumTabSize, this.getMinimumTabSize(), n, bl, false, false);
    }

    public boolean minimumTabSizeIsUIResource() {
        return this.getMinimumTabSizeUIValue().isUIResource();
    }

    public Integer getMinimumTabSize() {
        return this.getMinimumTabSizeUIValue().get();
    }

    private UIValue<Integer> getMinimumTabSizeUIValue() {
        if (this.minimumTabSize == null) {
            this.minimumTabSize = new UIValue();
        }
        return this.minimumTabSize;
    }

    public void setMaximumTabSize(Integer n) {
        this.setMaximumTabSize(n, false);
    }

    public void setMaximumTabSize(Integer n, boolean bl) {
        WidgetUtils.setUIProperty(this, "maximumTabSize", this.maximumTabSize, this.getMaximumTabSize(), n, bl, false, false);
    }

    public boolean maximumTabSizeIsUIResource() {
        return this.getMaximumTabSizeUIValue().isUIResource();
    }

    public Integer getMaximumTabSize() {
        return this.getMaximumTabSizeUIValue().get();
    }

    private UIValue<Integer> getMaximumTabSizeUIValue() {
        if (this.maximumTabSize == null) {
            this.maximumTabSize = new UIValue();
        }
        return this.maximumTabSize;
    }

    public void setTabsStretchedEnabled(Boolean bl) {
        this.setTabsStretchedEnabled(bl, false);
    }

    public void setTabsStretchedEnabled(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "tabsStretchedEnabled", this.tabsStretchedEnabled, this.getTabsStretchedEnabled(), bl, bl2, false, false);
    }

    public boolean tabsStretchedEnabledIsUIResource() {
        return this.getTabsStretchedEnabledUIValue().isUIResource();
    }

    public Boolean getTabsStretchedEnabled() {
        return this.getTabsStretchedEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabsStretchedEnabledUIValue() {
        if (this.tabsStretchedEnabled == null) {
            this.tabsStretchedEnabled = new UIValue();
        }
        return this.tabsStretchedEnabled;
    }

    public void setTabRotationEnabled(Boolean bl) {
        this.setTabRotationEnabled(bl, false);
    }

    public void setTabRotationEnabled(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "tabRotationEnabled", this.tabRotationEnabled, this.getTabRotationEnabled(), bl, bl2, false, false);
    }

    public boolean tabRotationEnabledIsUIResource() {
        return this.getTabRotationEnabledUIValue().isUIResource();
    }

    public Boolean getTabRotationEnabled() {
        return this.getTabRotationEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabRotationEnabledUIValue() {
        if (this.tabRotationEnabled == null) {
            this.tabRotationEnabled = new UIValue();
        }
        return this.tabRotationEnabled;
    }

    public void setShowPlusButton(Boolean bl) {
        this.setShowPlusButton(bl, false);
    }

    public void setShowPlusButton(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "showPlusButton", this.showPlusButton, this.getShowPlusButton(), bl, bl2, false, false);
    }

    public boolean showPlusButtonIsUIResource() {
        return this.getShowPlusButtonUIValue().isUIResource();
    }

    public Boolean getShowPlusButton() {
        return this.getShowPlusButtonUIValue().get();
    }

    private UIValue<Boolean> getShowPlusButtonUIValue() {
        if (this.showPlusButton == null) {
            this.showPlusButton = new UIValue();
        }
        return this.showPlusButton;
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    @Override
    public boolean hasFocus() {
        BasicJYTabbedPaneUI.TabsPanel tabsPanel = this.getTabsPanel();
        if (tabsPanel != null) {
            Tab[] tabArray;
            Tab[] tabArray2 = tabArray = tabsPanel.getTabs().toArray(new Tab[0]);
            int n = tabArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tab tab = tabArray2[n2];
                if (tab.hasFocus()) {
                    return true;
                }
                ++n2;
            }
        }
        return super.hasFocus();
    }

    private BasicJYTabbedPaneUI.TabsPanel getTabsPanel() {
        return (BasicJYTabbedPaneUI.TabsPanel)SyntheticaLookAndFeel.findComponent(BasicJYTabbedPaneUI.TabsPanel.class, (Container)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CloseButtonStrategy implements ICloseButtonStrategy
    {
        NONE(null),
        SELECTED_TAB(new ICloseButtonStrategy(){

            public boolean isButtonVisible(JYTabbedPane jYTabbedPane, Tab tab) {
                int n = jYTabbedPane.getSelectedIndex();
                return n >= 0 && n == tab.getTabIndex();
            }
        }),
        ALL_TABS(new ICloseButtonStrategy(){

            public boolean isButtonVisible(JYTabbedPane jYTabbedPane, Tab tab) {
                return true;
            }
        });

        private ICloseButtonStrategy strategy;

        private CloseButtonStrategy(ICloseButtonStrategy iCloseButtonStrategy) {
            this.strategy = iCloseButtonStrategy;
        }

        @Override
        public boolean isButtonVisible(JYTabbedPane jYTabbedPane, Tab tab) {
            return this.strategy == null ? false : this.strategy.isButtonVisible(jYTabbedPane, tab);
        }
    }

    private class ContentPanel
    extends JPanel
    implements UIResource {
        private static final long serialVersionUID = 3355882484839791206L;

        public ContentPanel() {
            this.setLayout(new BorderLayout(){

                public void layoutContainer(Container container) {
                    super.layoutContainer(container);
                    Insets insets = container.getInsets();
                    int n = insets.top;
                    int n2 = container.getHeight() - insets.bottom;
                    int n3 = insets.left;
                    int n4 = container.getWidth() - insets.right;
                    Component[] componentArray = container.getComponents();
                    int n5 = componentArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Component component = componentArray[n6];
                        component.setBounds(n3, n, n4 - n3, n2 - n);
                        ++n6;
                    }
                }
            });
            this.setName("JYTabbedPane.ContentPanel");
        }

        public void doLayout() {
            Component component;
            if (JYTabbedPane.this.getSelectedIndex() >= 0 && (component = JYTabbedPane.this.getComponentAt(JYTabbedPane.this.getSelectedIndex())) != null && component != ((BorderLayout)this.getLayout()).getLayoutComponent("Center")) {
                ((BorderLayout)this.getLayout()).addLayoutComponent(component, "Center");
            }
            super.doLayout();
        }

        public void updateUI() {
            super.updateUI();
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                JYTabbedPane jYTabbedPane = JYTabbedPane.this;
                SynthStyle synthStyle = SynthLookAndFeel.getStyle(jYTabbedPane, Region.TABBED_PANE_CONTENT);
                SynthContext synthContext = new SynthContext(jYTabbedPane, Region.TABBED_PANE_CONTENT, synthStyle, 0);
                this.setBorder(new EmptyBorder(synthStyle.getInsets(synthContext, null)));
                this.setBackground(synthStyle.getColor(synthContext, ColorType.BACKGROUND));
                this.setOpaque(synthStyle.isOpaque(synthContext));
            }
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            super.paintComponent(graphics);
            JYTabbedPane jYTabbedPane = JYTabbedPane.this;
            int n2 = jYTabbedPane.getTabPlacement();
            if (!(n2 != 2 && n2 != 4 || jYTabbedPane.getComponentOrientation().isLeftToRight())) {
                n2 = n2 == 2 ? 4 : 2;
            }
            BasicJYTabbedPaneUI.TabsPanel tabsPanel = JYTabbedPane.this.getTabsPanel();
            BasicJYTabbedPaneUI.TabsPanelViewport tabsPanelViewport = (BasicJYTabbedPaneUI.TabsPanelViewport)tabsPanel.getParent();
            Rectangle rectangle = SwingUtilities.convertRectangle(tabsPanelViewport.getParent(), tabsPanelViewport.getBounds(), jYTabbedPane);
            if (tabsPanel.getShowPlusButton()) {
                tabsPanelViewport.calculatePlusButtonAwareViewRect(rectangle);
            }
            Rectangle rectangle2 = (n = jYTabbedPane.getSelectedIndex()) < 0 ? rectangle : SwingUtilities.convertRectangle(jYTabbedPane, rectangle.intersection(jYTabbedPane.getBoundsAt(n)), this);
            jYTabbedPane.putClientProperty("JTabbedPane.visibleSelectedTabRect", n < 0 || n >= JYTabbedPane.this.getTabCount() ? null : rectangle2);
            int n3 = ((BasicJYTabbedPaneUI)jYTabbedPane.getUI()).placementToRotation(n2).toAngle();
            SynthContext synthContext = null;
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                synthContext = new SynthContext(jYTabbedPane, Region.TABBED_PANE, SynthLookAndFeel.getStyle(jYTabbedPane, Region.TABBED_PANE), 0);
            }
            boolean bl = ((BasicJYTabbedPaneUI)jYTabbedPane.getUI()).isPaintContentBorderGap4SelectedTabEnabled();
            JYTabbedPanePainter.getInstance(synthContext).paintTabbedPaneContentBorder(jYTabbedPane, new SyntheticaState(0), n2, bl, n3, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TabControlsPosition {
        LEADING,
        TRAILING,
        LEADING_TRAILING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TabControlsShowStrategy {
        ALWAYS,
        NEVER,
        AS_NEEDED;

    }

    private class TabHistoryHandler
    implements PropertyChangeListener,
    ChangeListener {
        private ArrayList<Integer> tabHistory = new ArrayList();

        private TabHistoryHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JYTabbedPane jYTabbedPane = (JYTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("removeTab".equals(string)) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                int n2 = this.tabHistory.size() - 1;
                while (n2 >= 0) {
                    Integer n3 = this.tabHistory.get(n2);
                    if (n == n3) {
                        this.tabHistory.remove(n2);
                    } else if (n3 > n) {
                        this.tabHistory.remove(n2);
                        this.tabHistory.add(n2, n3 - 1);
                    }
                    --n2;
                }
                n2 = this.tabHistory.size() > 0 ? this.tabHistory.get(this.tabHistory.size() - 1) : -1;
                int n4 = 1;
                while (n4 <= this.tabHistory.size() && !JYTabbedPane.this.isEnabledAt(n2)) {
                    n2 = this.tabHistory.get(this.tabHistory.size() - n4);
                    ++n4;
                }
                if (n2 >= 0) {
                    n4 = !JYTabbedPane.this.tabMove && SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabHistory.scrollToVisible", jYTabbedPane, false) ? 1 : 0;
                    jYTabbedPane.setSelectedIndex(n2, n4 != 0);
                }
                if (!JYTabbedPane.this.tabMove) {
                    this.updateSelectedIndex(jYTabbedPane.getSelectedIndex());
                }
            } else if ("insertTab".equals(string)) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                int n5 = this.tabHistory.size() - 1;
                while (n5 >= 0) {
                    Integer n6 = this.tabHistory.get(n5);
                    if (n6 >= n && this.tabHistory.size() > 1) {
                        this.tabHistory.remove(n5);
                        this.tabHistory.add(n5, n6 + 1);
                    }
                    --n5;
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            if (!(JYTabbedPane.this.tabRemove || JYTabbedPane.this.tabMove || JYTabbedPane.this.tabInsert)) {
                this.updateSelectedIndex(jTabbedPane.getSelectedIndex());
            }
        }

        private void updateSelectedIndex(int n) {
            if (n >= 0) {
                this.tabHistory.remove((Object)n);
                this.tabHistory.add(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TabStyle {
        COMMON,
        SELECTED_TAB_ONLY,
        TABS_ON_HOVER;

    }
}

