/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.IFormattedField;
import de.javasoft.swing.IUIPropertySupport;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.JYTextFieldUI;
import de.javasoft.swing.plaf.UIValue;
import de.javasoft.swing.plaf.addons.JYTextFieldAddon;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.text.Document;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JYTextField
extends JFormattedTextField
implements IUIPropertySupport {
    private static final long serialVersionUID = -5577666471656177619L;
    public static final String uiClassID = "JYTextFieldUI";
    private boolean emptyFieldCommittedAsNullValue;
    private JPanel leadingPanel;
    private JPanel trailingPanel;
    private UIValue<String> promptText;
    private UIValue<Color> promptForeground;
    private UIValue<Integer> promptAlignment;
    private UIValue<PromptStrategy> promptStrategy;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYTextFieldAddon());
        if (UIManager.get("TextField.actionMap") == null) {
            // empty if block
        }
        new JTextField();
    }

    public JYTextField() {
        this((String)null);
    }

    public JYTextField(String string) {
        this(string, 0);
    }

    public JYTextField(int n) {
        this((String)null, n);
    }

    public JYTextField(String string, int n) {
        this.setText(string);
        this.setColumns(n);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        return font != null ? font : new FontUIResource(SyntheticaLookAndFeel.getFont());
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>();
        if (!this.isFormattedTextField()) {
            PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
            int n = propertyChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[n2];
                this.removePropertyChangeListener(propertyChangeListener);
                arrayList.add(propertyChangeListener);
                ++n2;
            }
        }
        super.processFocusEvent(focusEvent);
        if (!this.isFormattedTextField()) {
            for (PropertyChangeListener propertyChangeListener : arrayList) {
                this.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private boolean isFormattedTextField() {
        boolean bl = this instanceof IFormattedField || this.getFormatter() != null;
        return bl;
    }

    @Override
    public void setDocument(Document document) {
        super.setDocument(document);
        document.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            private void update(DocumentEvent documentEvent) {
                JYTextField.this.firePropertyChange("documentLength", -1, documentEvent.getDocument().getLength());
            }
        });
    }

    @Override
    public void setMargin(Insets insets) {
        super.setMargin(insets);
        Border border = this.getBorder();
        if (border instanceof MarginBorder) {
            if (insets == null) {
                this.setBorder(((MarginBorder)border).getOutsideBorder());
            } else {
                ((MarginBorder)border).setInsideBorder(new EmptyBorder(insets));
            }
        } else if (insets != null && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            this.setBorder(new MarginBorder(border, new EmptyBorder(insets)));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, JYTextFieldUI.class));
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        Insets insets = this.getInsets();
        boolean bl = this.getComponentOrientation().isLeftToRight();
        insets.left = insets.left + (bl ? this.leadingPanel.getPreferredSize().width : this.trailingPanel.getPreferredSize().width);
        insets.right = insets.right + (bl ? this.trailingPanel.getPreferredSize().width : this.leadingPanel.getPreferredSize().width);
        BoundedRangeModel boundedRangeModel = this.getHorizontalVisibility();
        int n = rectangle.x + boundedRangeModel.getValue() - insets.left;
        int n2 = n + rectangle.width;
        if (n < boundedRangeModel.getValue()) {
            boundedRangeModel.setValue(n);
        } else if (n2 > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
            boundedRangeModel.setValue(n2 - boundedRangeModel.getExtent());
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof BorderLayout) {
            super.setLayout(layoutManager);
        }
    }

    public JPanel getLeadingPanel() {
        if (this.leadingPanel == null) {
            this.leadingPanel = new JPanel();
            this.leadingPanel.setOpaque(false);
            this.leadingPanel.setLayout(new BoxLayout(this.leadingPanel, 2));
        }
        return this.leadingPanel;
    }

    public JPanel getTrailingPanel() {
        if (this.trailingPanel == null) {
            this.trailingPanel = new JPanel();
            this.trailingPanel.setOpaque(false);
            this.trailingPanel.setLayout(new BoxLayout(this.trailingPanel, 2));
        }
        return this.trailingPanel;
    }

    public void addLeadingComponent(JComponent jComponent) {
        this.getLeadingPanel().add(jComponent);
        this.initComponent(jComponent);
        this.revalidate();
    }

    public void addTrailingComponent(JComponent jComponent) {
        this.getTrailingPanel().add(jComponent, null, 0);
        this.initComponent(jComponent);
        this.revalidate();
    }

    protected void initComponent(JComponent jComponent) {
        jComponent.setCursor(Cursor.getDefaultCursor());
    }

    public void setEmptyFieldCommittedAsNullValue(boolean bl) {
        this.emptyFieldCommittedAsNullValue = bl;
    }

    public boolean isEmptyFieldCommittedAsNullValue() {
        return this.emptyFieldCommittedAsNullValue;
    }

    @Override
    public void commitEdit() throws ParseException {
        String string = this.getText();
        if (this.isEmptyFieldCommittedAsNullValue() && string != null && string.length() == 0) {
            this.setValue(null);
        } else {
            super.commitEdit();
        }
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    public void setPromptText(String string) {
        this.setPromptText(string, false);
    }

    public void setPromptText(String string, boolean bl) {
        WidgetUtils.setUIProperty(this, "promptText", this.promptText, this.getPromptText(), string, bl, false, false);
    }

    public boolean promptTextIsUIResource() {
        return this.getPromptTextUIValue().isUIResource();
    }

    public String getPromptText() {
        return this.getPromptTextUIValue().get();
    }

    private UIValue<String> getPromptTextUIValue() {
        if (this.promptText == null) {
            this.promptText = new UIValue();
        }
        return this.promptText;
    }

    public void setPromptForeground(Color color) {
        this.setPromptForeground(color, false);
    }

    public void setPromptForeground(Color color, boolean bl) {
        WidgetUtils.setUIProperty(this, "promptForeground", this.promptForeground, this.getPromptForeground(), color, bl, false, false);
    }

    public boolean promptForegroundIsUIResource() {
        return this.getPromptForegroundUIValue().isUIResource();
    }

    public Color getPromptForeground() {
        return this.getPromptForegroundUIValue().get();
    }

    private UIValue<Color> getPromptForegroundUIValue() {
        if (this.promptForeground == null) {
            this.promptForeground = new UIValue();
        }
        return this.promptForeground;
    }

    public void setPromptAlignment(Integer n) {
        this.setPromptAlignment(n, false);
    }

    public void setPromptAlignment(Integer n, boolean bl) {
        WidgetUtils.setUIProperty(this, "promptAlignment", this.promptAlignment, this.getPromptAlignment(), n, bl, false, false);
    }

    public boolean promptAlignmentIsUIResource() {
        return this.getPromptAlignmentUIValue().isUIResource();
    }

    public Integer getPromptAlignment() {
        return this.getPromptAlignmentUIValue().get();
    }

    private UIValue<Integer> getPromptAlignmentUIValue() {
        if (this.promptAlignment == null) {
            this.promptAlignment = new UIValue();
        }
        return this.promptAlignment;
    }

    public void setPromptStrategy(PromptStrategy promptStrategy) {
        this.setPromptStrategy(promptStrategy, false);
    }

    public void setPromptStrategy(PromptStrategy promptStrategy, boolean bl) {
        WidgetUtils.setUIProperty(this, "promptStrategy", this.promptStrategy, this.getPromptStrategy(), promptStrategy, bl, true, true);
    }

    public boolean promptStrategyIsUIResource() {
        return this.getPromptStrategyUIValue().isUIResource();
    }

    public PromptStrategy getPromptStrategy() {
        return this.getPromptStrategyUIValue().get();
    }

    private UIValue<PromptStrategy> getPromptStrategyUIValue() {
        if (this.promptStrategy == null) {
            this.promptStrategy = new UIValue();
        }
        return this.promptStrategy;
    }

    private static class MarginBorder
    extends CompoundBorder {
        private static final long serialVersionUID = -5681276157290014600L;

        public MarginBorder(Border border, Border border2) {
            super(border, border2);
        }

        public void setInsideBorder(Border border) {
            this.insideBorder = border;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PromptStrategy {
        NO_TEXT_AND_NO_FOCUS,
        NO_TEXT;

    }
}

