/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.swing.IRotatableComponent;
import de.javasoft.swing.IUIPropertySupport;
import de.javasoft.swing.plaf.UIValue;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.DefaultsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetUtils {
    private static Cursor dragCursor;
    private static Cursor stopCursor;

    public static Cursor getDragCursor() {
        if (dragCursor == null) {
            ImageIcon imageIcon = new ImageIcon(WidgetUtils.class.getResource("resources/dragCursor.png"));
            dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(0, 0), "DRAG_CURSOR");
        }
        return dragCursor;
    }

    public static Cursor getStopCursor() {
        if (stopCursor == null) {
            ImageIcon imageIcon = new ImageIcon(WidgetUtils.class.getResource("resources/stopCursor.png"));
            stopCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(0, 0), "STOP_CURSOR");
        }
        return stopCursor;
    }

    public static <T> void setUIProperty(JComponent jComponent, String string, UIValue<T> uIValue, T t, T t2, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            t = null;
        }
        if (t == null || !t.equals(t2)) {
            uIValue.set(t2);
            uIValue.setUIResource(bl);
            ((IUIPropertySupport)((Object)jComponent)).firePropertyChange(string, t, t2);
            if (bl2) {
                jComponent.revalidate();
            }
            if (bl3) {
                jComponent.repaint();
            }
        }
    }

    public static boolean shouldUpdateStyle(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("name".equals(string)) {
            return true;
        }
        return "Synthetica.style".equals(string);
    }

    public static Dimension rotateDimension(Dimension dimension, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            int n = dimension.width;
            dimension.width = dimension.height;
            dimension.height = n;
        }
        return dimension;
    }

    public static Rectangle rotateRectangle(Rectangle rectangle, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            int n = rectangle.width;
            rectangle.width = rectangle.height;
            rectangle.height = n;
        }
        return rectangle;
    }

    public static Border createRotatableEmptyBorder(Insets insets, boolean bl) {
        if (bl) {
            return new RotatableEmptyBorderUIResource(insets);
        }
        return new RotatableEmptyBorder(insets);
    }

    public static Insets rotateInsets(Insets insets, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.REVERSED) {
            int n = insets.top;
            insets.top = insets.bottom;
            insets.bottom = n;
        } else if (rotation == IRotatableComponent.Rotation.RIGHT) {
            int n = insets.top;
            insets.top = insets.left;
            int n2 = insets.right;
            insets.right = n;
            n = insets.bottom;
            insets.bottom = n2;
            insets.left = n;
        } else if (rotation == IRotatableComponent.Rotation.LEFT) {
            int n = insets.top;
            insets.top = insets.right;
            int n3 = insets.left;
            insets.left = n;
            n = insets.bottom;
            insets.bottom = n3;
            insets.right = n;
        }
        return insets;
    }

    public static Border createOrientationAwareEmptyBorder(Insets insets, boolean bl) {
        if (bl) {
            return new OrientationAwareEmptyBorderUIResource(insets);
        }
        return new OrientationAwareEmptyBorder(insets);
    }

    public static void addResourceBundleToDefaults(String string, DefaultsList defaultsList) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            String string3 = resourceBundle.getString(string2);
            defaultsList.add((Object)string2, (Object)string3);
        }
    }

    public static class OrientationAwareEmptyBorder
    extends EmptyBorder {
        private static final long serialVersionUID = 1197462533056882357L;

        public OrientationAwareEmptyBorder(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public OrientationAwareEmptyBorder(Insets insets) {
            super(insets);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            boolean bl = component.getComponentOrientation().isLeftToRight();
            insets.left = bl ? this.left : this.right;
            insets.top = this.top;
            insets.right = bl ? this.right : this.left;
            insets.bottom = this.bottom;
            return insets;
        }
    }

    public static class OrientationAwareEmptyBorderUIResource
    extends OrientationAwareEmptyBorder
    implements UIResource {
        private static final long serialVersionUID = -2425915691737611974L;

        public OrientationAwareEmptyBorderUIResource(Insets insets) {
            super(insets);
        }
    }

    private static class RotatableEmptyBorder
    extends EmptyBorder {
        private static final long serialVersionUID = -3288482079141574369L;

        public RotatableEmptyBorder(Insets insets) {
            super(insets);
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = super.getBorderInsets(component);
            if (component instanceof AbstractButton) {
                Insets insets2 = ((AbstractButton)component).getMargin();
                insets = new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
            }
            if (component instanceof IRotatableComponent) {
                insets = WidgetUtils.rotateInsets(insets, ((IRotatableComponent)((Object)component)).getRotation());
            }
            return insets;
        }
    }

    private static class RotatableEmptyBorderUIResource
    extends RotatableEmptyBorder
    implements UIResource {
        private static final long serialVersionUID = 1764839983093610630L;

        public RotatableEmptyBorderUIResource(Insets insets) {
            super(insets);
        }
    }
}

