/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.filter.BooleanColumnFilter;
import de.javasoft.swing.filter.CollectionColumnFilter;
import de.javasoft.swing.filter.ColumnFilter;
import de.javasoft.swing.filter.ComparableColumnFilter;
import de.javasoft.swing.filter.DateColumnFilter;
import de.javasoft.swing.filter.IColumnFilterFactory;
import de.javasoft.swing.filter.IRowFilterFactory;
import de.javasoft.swing.filter.IRowFilterModel;
import de.javasoft.swing.filter.IRowFilterModelFactory;
import de.javasoft.swing.filter.PatternColumnFilter;
import de.javasoft.swing.filter.SimpleColumnFilter;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JFormattedTextField;
import org.jdesktop.swingx.renderer.StringValue;

public class ColumnFilterFactories {
    private ColumnFilterFactories() {
    }

    public static class BooleanColumnFilterFactory<M>
    implements IColumnFilterFactory<M> {
        private StringValue stringValue;

        public BooleanColumnFilterFactory() {
            this(null);
        }

        public BooleanColumnFilterFactory(StringValue sv) {
            this.stringValue = sv;
        }

        @Override
        public BooleanColumnFilter<M> createColumnFilter(int columnIndex) {
            BooleanColumnFilter filter = new BooleanColumnFilter(columnIndex);
            filter.setStringValue(this.stringValue);
            return filter;
        }
    }

    public static class CollectionColumnFilterFactory<M, T>
    implements IColumnFilterFactory<M> {
        private Collection<T> items;
        private Comparator<? super T> comparator;
        private IRowFilterModelFactory<M> modelFactory;

        public CollectionColumnFilterFactory() {
            this((Collection<T>)null);
        }

        public CollectionColumnFilterFactory(Collection<T> items) {
            this(items, null);
        }

        public CollectionColumnFilterFactory(Collection<T> items, Comparator<? super T> comparator) {
            this.items = items;
            this.comparator = comparator;
        }

        public CollectionColumnFilterFactory(IRowFilterModelFactory<M> modelFactory) {
            this.modelFactory = modelFactory;
        }

        @Override
        public CollectionColumnFilter<M> createColumnFilter(int columnIndex) {
            IRowFilterModel<M> filterModel = this.modelFactory != null ? this.modelFactory.createRowFilterModel(columnIndex) : null;
            CollectionColumnFilter<M> columnFilter = new CollectionColumnFilter<M>(columnIndex, filterModel);
            if (this.items != null) {
                columnFilter.setValues(this.items, this.comparator);
            }
            return columnFilter;
        }
    }

    public static class ComparableColumnFilterFactory<M>
    implements IColumnFilterFactory<M> {
        private JFormattedTextField.AbstractFormatter formatter;
        private JFormattedTextField.AbstractFormatterFactory formatterFactory;
        private IRowFilterModelFactory<M> modelFactory;

        public ComparableColumnFilterFactory() {
        }

        public ComparableColumnFilterFactory(JFormattedTextField.AbstractFormatter formatter) {
            this(formatter, null);
        }

        public ComparableColumnFilterFactory(JFormattedTextField.AbstractFormatterFactory factory) {
            this(factory, null);
        }

        public ComparableColumnFilterFactory(JFormattedTextField.AbstractFormatter formatter, IRowFilterModelFactory<M> modelFactory) {
            this.formatter = formatter;
            this.modelFactory = modelFactory;
        }

        public ComparableColumnFilterFactory(JFormattedTextField.AbstractFormatterFactory factory, IRowFilterModelFactory<M> modelFactory) {
            this.formatterFactory = factory;
            this.modelFactory = modelFactory;
        }

        public ComparableColumnFilterFactory(IRowFilterModelFactory<M> modelFactory) {
            this.modelFactory = modelFactory;
        }

        @Override
        public ComparableColumnFilter<M> createColumnFilter(int columnIndex) {
            IRowFilterModel<M> model = this.modelFactory == null ? null : this.modelFactory.createRowFilterModel(columnIndex);
            ComparableColumnFilter<M> columnFilter = new ComparableColumnFilter<M>(columnIndex, model);
            if (this.formatter != null) {
                columnFilter.setFormatter(this.formatter);
            }
            if (this.formatterFactory != null) {
                columnFilter.setFormatterFactory(this.formatterFactory);
            }
            return columnFilter;
        }
    }

    public static class DateColumnFilterFactory<M>
    implements IColumnFilterFactory<M> {
        private DateFormat formatter;
        private DateFormat[] formatterFactory;
        private IRowFilterModelFactory<M> modelFactory;

        public DateColumnFilterFactory() {
        }

        public DateColumnFilterFactory(DateFormat dateFormat) {
            this(dateFormat, null);
        }

        public DateColumnFilterFactory(DateFormat[] dateFormats) {
            this(dateFormats, null);
        }

        public DateColumnFilterFactory(DateFormat dateFormat, IRowFilterModelFactory<M> modelFactory) {
            this.formatter = dateFormat;
            this.modelFactory = modelFactory;
        }

        public DateColumnFilterFactory(DateFormat[] dateFormats, IRowFilterModelFactory<M> modelFactory) {
            this.formatterFactory = dateFormats;
            this.modelFactory = modelFactory;
        }

        public DateColumnFilterFactory(IRowFilterModelFactory<M> modelFactory) {
            this.modelFactory = modelFactory;
        }

        @Override
        public DateColumnFilter<M> createColumnFilter(int columnIndex) {
            IRowFilterModel<M> model = this.modelFactory == null ? null : this.modelFactory.createRowFilterModel(columnIndex);
            DateColumnFilter<M> columnFilter = new DateColumnFilter<M>(columnIndex, model);
            if (this.formatter != null) {
                columnFilter.setDateFormat(this.formatter);
            }
            if (this.formatterFactory != null) {
                columnFilter.setDateFormats(this.formatterFactory);
            }
            return columnFilter;
        }
    }

    public static class PatternColumnFilterFactory<M>
    implements IColumnFilterFactory<M> {
        private IRowFilterModelFactory<M> modelFactory;

        public PatternColumnFilterFactory() {
        }

        public PatternColumnFilterFactory(IRowFilterModelFactory<M> modelFactory) {
            this.modelFactory = modelFactory;
        }

        @Override
        public ColumnFilter<M> createColumnFilter(int columnIndex) {
            IRowFilterModel<M> model = this.modelFactory == null ? null : this.modelFactory.createRowFilterModel(columnIndex);
            return new PatternColumnFilter<M>(columnIndex, model);
        }
    }

    public static class SimpleColumnFilterFactory<M>
    implements IColumnFilterFactory<M> {
        private JFormattedTextField.AbstractFormatter formatter;
        private JFormattedTextField.AbstractFormatterFactory formatterFactory;
        private IRowFilterFactory<? super M> rowFilterFactory;

        public SimpleColumnFilterFactory() {
        }

        public SimpleColumnFilterFactory(IRowFilterFactory<? super M> rowFilterFactory) {
            this.rowFilterFactory = rowFilterFactory;
        }

        public SimpleColumnFilterFactory(JFormattedTextField.AbstractFormatter formatter) {
            this(formatter, null);
        }

        public SimpleColumnFilterFactory(JFormattedTextField.AbstractFormatterFactory factory) {
            this(factory, null);
        }

        public SimpleColumnFilterFactory(JFormattedTextField.AbstractFormatter formatter, IRowFilterFactory<? super M> rowFilterFactory) {
            this(rowFilterFactory);
            this.formatter = formatter;
        }

        public SimpleColumnFilterFactory(JFormattedTextField.AbstractFormatterFactory factory, IRowFilterFactory<? super M> rowFilterFactory) {
            this(rowFilterFactory);
            this.formatterFactory = factory;
        }

        @Override
        public ColumnFilter<M> createColumnFilter(int columnIndex) {
            SimpleColumnFilter<M> columnFilter = new SimpleColumnFilter<M>(columnIndex, this.rowFilterFactory);
            if (this.formatter != null) {
                columnFilter.setFormatter(this.formatter);
            }
            if (this.formatterFactory != null) {
                columnFilter.setFormatterFactory(this.formatterFactory);
            }
            return columnFilter;
        }
    }
}

