/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.DateComboBox;
import de.javasoft.swing.filter.AbstractComparableColumnFilter;
import de.javasoft.swing.filter.Boundaries;
import de.javasoft.swing.filter.FilterContainer;
import de.javasoft.swing.filter.IRowFilterModel;
import de.javasoft.swing.sort.RowFilters;
import java.awt.Dimension;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jdesktop.swingx.util.Contract;

public class DateColumnFilter<M>
extends AbstractComparableColumnFilter<M> {
    private DateComboBox filterField;
    private DateComboBox toField;
    private Action filterFieldActionListener;
    private static final Logger LOG = Logger.getLogger(DateColumnFilter.class.getName());

    public DateColumnFilter(int columnIndex) {
        super(columnIndex);
    }

    public DateColumnFilter(int columnIndex, IRowFilterModel<M> filterModel) {
        super(columnIndex, filterModel);
    }

    public void setDateFormat(DateFormat format) {
        this.setDateFormats(new DateFormat[]{format});
    }

    public void setDateFormats(DateFormat[] dateFormats) {
        Contract.asNotNull((Object)dateFormats, (String)"formatter/factory must not be null");
        this.getFilteringComponent();
        this.filterField.setDateFormats(dateFormats);
        this.toField.setDateFormats(dateFormats);
    }

    @Override
    protected void doRelease() {
        this.filterField.removeActionListener(this.filterFieldActionListener);
        this.toField.removeActionListener(this.filterFieldActionListener);
        super.doRelease();
    }

    @Override
    protected void matchValueChanged() {
        if (this.getRowFilterModel().getMatchRule() instanceof RowFilters.RangeType) {
            this.getRowFilterModel().setMatchValue(new Boundaries(this.filterField.getDate(), this.toField.getDate()));
        } else {
            this.getRowFilterModel().setMatchValue(this.filterField.getDate());
        }
    }

    @Override
    protected void matchValueChanged(Object oldValue, Object newValue) {
        this.getFilteringComponent();
        if (newValue instanceof Boundaries) {
            Boundaries boundaries = (Boundaries)newValue;
            if (!this.areEqual(this.filterField.getDate(), boundaries.from)) {
                this.filterField.setDate((Date)boundaries.from);
            }
            if (!this.areEqual(this.toField.getDate(), boundaries.to)) {
                this.toField.setDate((Date)boundaries.to);
            }
        } else {
            if (this.areEqual(this.filterField.getDate(), newValue)) {
                return;
            }
            this.filterField.setDate((Date)newValue);
        }
    }

    @Override
    protected void updateComponentsAfterMatchRuleChanged(Object rule) {
        super.updateComponentsAfterMatchRuleChanged(rule);
        this.toField.setVisible(this.unwrapMatchRule(rule) instanceof RowFilters.RangeType);
        this.getFilteringComponent().revalidate();
    }

    private void installFilterFieldListeners(DateComboBox field) {
        if (this.filterFieldActionListener == null) {
            this.filterFieldActionListener = this.createMatchValueChangedAction();
        }
        field.addActionListener(this.filterFieldActionListener);
    }

    protected DateComboBox createDateComboBox() {
        DateComboBox toField = new DateComboBox(){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = 0;
                return dim;
            }
        };
        toField.setInheritsPopupMenu(true);
        toField.setEditable(true);
        toField.setDate((Date)null);
        toField.setCursor(toField.getCursor());
        return toField;
    }

    @Override
    protected JComponent createFilteringComponent() {
        this.filterField = this.createDateComboBox();
        this.installFilterFieldListeners(this.filterField);
        this.toField = this.createDateComboBox();
        this.toField.setVisible(false);
        this.installFilterFieldListeners(this.toField);
        FilterContainer panel = new FilterContainer();
        panel.add(this.getMatchRuleComponent());
        panel.add(this.filterField);
        panel.add(this.toField);
        return panel;
    }
}

