/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.IUIPropertySupport;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.jydocking.DockbarLabel;
import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.plaf.UIValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dockbar
extends JPanel
implements IUIPropertySupport {
    private static final long serialVersionUID = -5801730631751358416L;
    public static final String uiClassID = "JYDockingDockbarUI";
    protected int placement;
    protected DockbarManager manager;
    protected ArrayList<DockbarLabel> dockbarLabels = new ArrayList();
    private UIValue<Integer> dockbarItemGap;

    public Dockbar(DockbarManager dockbarManager, int n) {
        this.manager = dockbarManager;
        this.setPlacement(n);
        this.addAncestorListener(new AncestorListener(){

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                DockbarManager.removeDockbarManager(Dockbar.this.manager);
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }
        });
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public String getName() {
        String string = super.getName();
        return string == null ? "JYDocking.Dockbar" : string;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.manager == null) {
            return;
        }
        for (IDockable iDockable : this.manager.getDockables(this.placement)) {
            SwingUtilities.updateComponentTreeUI(iDockable.getComponent());
        }
    }

    public void dock(IDockable iDockable) {
        DockbarLabel dockbarLabel = new DockbarLabel(iDockable.getID(), this.getPlacement());
        this.add(dockbarLabel);
        this.add(this.createItemGap(iDockable.getID()));
        this.dockbarLabels.add(dockbarLabel);
    }

    void undock(IDockable iDockable) {
        DockbarLabel dockbarLabel = this.getLabel(iDockable);
        this.remove(dockbarLabel);
        this.dockbarLabels.remove(dockbarLabel);
        this.remove(SyntheticaLookAndFeel.findComponent(iDockable.getID(), (Container)this));
    }

    public boolean contains(IDockable iDockable) {
        return this.getLabel(iDockable) != null;
    }

    public DockbarLabel getLabel(IDockable iDockable) {
        for (DockbarLabel dockbarLabel : this.dockbarLabels) {
            if (dockbarLabel.getDockable() != iDockable) continue;
            return dockbarLabel;
        }
        return null;
    }

    private Component createItemGap(String string) {
        int n = this.getDockbarItemGap();
        Component component = this.placement == 3 ? Box.createHorizontalStrut(n) : Box.createVerticalStrut(n);
        component.setName(string);
        return component;
    }

    public int getPlacement() {
        return this.placement;
    }

    private void setPlacement(int n) {
        int n2 = this.placement;
        this.placement = n;
        int n3 = n == 1 || n == 3 ? 2 : 3;
        this.setLayout(new BoxLayout(this, n3));
        this.firePropertyChange("placement", n2, n);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.dockbarLabels.size() == 0) {
            return new Dimension(0, 0);
        }
        return super.getPreferredSize();
    }

    void activate(String string, boolean bl) {
        if (this.manager != null) {
            this.manager.setActiveDockable(string);
            if (bl) {
                this.manager.lockSlidePanel();
            }
        }
    }

    public static String placementAsString(int n) {
        return n == 3 ? "bottom" : (n == 4 ? "right" : "left");
    }

    public void setDockbarItemGap(Integer n) {
        this.setDockbarItemGap(n, false);
    }

    public void setDockbarItemGap(Integer n, boolean bl) {
        WidgetUtils.setUIProperty(this, "dockbarItemGap", this.dockbarItemGap, this.getDockbarItemGap(), n, bl, false, false);
    }

    public boolean dockbarItemGapIsUIResource() {
        return this.getDockbarItemGapUIValue().isUIResource();
    }

    public Integer getDockbarItemGap() {
        return this.getDockbarItemGapUIValue().get();
    }

    private UIValue<Integer> getDockbarItemGapUIValue() {
        if (this.dockbarItemGap == null) {
            this.dockbarItemGap = new UIValue();
        }
        return this.dockbarItemGap;
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }
}

