/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.ActiveDockableTracker;
import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockbarDeactivator;
import de.javasoft.swing.jydocking.DockbarEvent;
import de.javasoft.swing.jydocking.DockbarLabel;
import de.javasoft.swing.jydocking.DockbarLayout;
import de.javasoft.swing.jydocking.DockbarSlidePanel;
import de.javasoft.swing.jydocking.DockbarTracker;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.FloatingDialog;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockbarEventListener;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.RestorationManager;
import de.javasoft.swing.jydocking.RootWindow;
import de.javasoft.swing.jydocking.SlidePanelAnimation;
import de.javasoft.swing.jydocking.StatusDockbar;
import de.javasoft.swing.jydocking.StatusDockbarManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DockbarManager {
    public static final Integer DOCKBAR_LAYER = new Integer(JLayeredPane.PALETTE_LAYER - 5);
    public static final int DEFAULT_PLACEMENT = 2;
    private static WeakHashMap<RootWindow, DockbarManager> managers = new WeakHashMap();
    private static String dockbarManagerClassName;
    private static DockbarManager currentManager;
    protected WeakReference<RootWindow> windowRef;
    protected Dockbar leftBar;
    protected Dockbar rightBar;
    protected Dockbar bottomBar;
    protected DockbarSlidePanel slidePanel;
    protected DockbarLayout dockbarLayout;
    private List<IDockbarEventListener> dockbarListeners = new ArrayList<IDockbarEventListener>();
    private DockbarDeactivator dockbarDeactivator;
    private HashMap<String, Integer> dockables;
    private int activePlacement = -1;
    private String activeDockableId;
    private boolean animating;
    private boolean dragging;
    private PropertyChangeListener dockablePropertyHandler = new DockablePropertyChangeHandler();

    static {
        DockbarTracker.register();
    }

    protected DockbarManager(RootWindow rootWindow) {
        this.dockbarLayout = new DockbarLayout(this);
        this.dockbarDeactivator = new DockbarDeactivator(this);
        this.leftBar = new Dockbar(this, 2);
        this.rightBar = new Dockbar(this, 4);
        this.bottomBar = new StatusDockbar(this, 3);
        this.slidePanel = new DockbarSlidePanel(this);
        this.windowRef = new WeakReference<RootWindow>(rootWindow);
        this.dockables = new HashMap();
        this.addDockbarListener(new IDockbarEventListener(){

            public void dockableExpanded(DockbarEvent dockbarEvent) {
            }

            public void dockableLocked(DockbarEvent dockbarEvent) {
                IDockable iDockable = (IDockable)dockbarEvent.getSource();
                ActiveDockableTracker.requestDockableActivation(iDockable.getComponent(), false);
            }

            public void dockableCollapsed(DockbarEvent dockbarEvent) {
            }

            public void minimizeStarted(DockbarEvent dockbarEvent) {
            }

            public void minimizeCompleted(DockbarEvent dockbarEvent) {
            }
        });
    }

    static DockbarManager getInstance(Component component) {
        RootWindow rootWindow = RootWindow.getRootWindow(component);
        return DockbarManager.getInstance(rootWindow);
    }

    static void removeDockbarManager(RootWindow rootWindow) {
        DockbarManager dockbarManager = managers.get(rootWindow);
        managers.remove(rootWindow);
        if (currentManager == dockbarManager) {
            currentManager = null;
        }
        if (dockbarManager != null) {
            if (dockbarManager.slidePanel != null) {
                rootWindow.getLayeredPane().remove(dockbarManager.slidePanel);
            }
            dockbarManager.dockables.clear();
        }
    }

    static void removeDockbarManager(DockbarManager dockbarManager) {
        for (Map.Entry<RootWindow, DockbarManager> entry : managers.entrySet()) {
            RootWindow rootWindow = entry.getKey();
            DockbarManager dockbarManager2 = entry.getValue();
            if (rootWindow == null || dockbarManager2 != dockbarManager) continue;
            DockbarManager.removeDockbarManager(rootWindow);
            break;
        }
    }

    static DockbarManager getInstance(RootWindow rootWindow) {
        Component component = rootWindow.getRootComponent();
        if (component instanceof FloatingDialog) {
            component = ((Window)component).getOwner();
            return DockbarManager.getInstance(component);
        }
        DockbarManager dockbarManager = managers.get(rootWindow);
        if (dockbarManager == null) {
            dockbarManager = DockbarManager.createDockbarManager(rootWindow);
            managers.put(rootWindow, dockbarManager);
            dockbarManager.install();
        }
        if (currentManager == null) {
            currentManager = dockbarManager;
        }
        return dockbarManager;
    }

    private static DockbarManager createDockbarManager(RootWindow rootWindow) {
        if (dockbarManagerClassName == null) {
            return new StatusDockbarManager(rootWindow);
        }
        DockbarManager dockbarManager = null;
        try {
            Class<?> clazz = Class.forName(dockbarManagerClassName);
            Constructor<?> constructor = clazz.getConstructor(RootWindow.class);
            dockbarManager = (DockbarManager)constructor.newInstance(rootWindow);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return dockbarManager;
    }

    public static void setDockbarManager(String string) {
        dockbarManagerClassName = string;
    }

    public static DockbarManager getCurrent() {
        return currentManager;
    }

    public static DockbarManager getCurrent(IDockable iDockable) {
        for (Map.Entry<RootWindow, DockbarManager> entry : managers.entrySet()) {
            RootWindow rootWindow = entry.getKey();
            DockbarManager dockbarManager = entry.getValue();
            if (!dockbarManager.isOwner(iDockable) || !rootWindow.isAlive()) continue;
            return dockbarManager;
        }
        return null;
    }

    protected void install() {
        RootWindow rootWindow = this.getWindow();
        if (rootWindow == null) {
            return;
        }
        JLayeredPane jLayeredPane = rootWindow.getLayeredPane();
        boolean bl = this.install(this.leftBar, jLayeredPane);
        bl |= this.install(this.rightBar, jLayeredPane);
        bl |= this.install(this.bottomBar, jLayeredPane);
        if (bl |= this.install(this.slidePanel, jLayeredPane)) {
            jLayeredPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    if (componentEvent.getSource() instanceof JLayeredPane) {
                        DockbarManager.this.revalidate();
                    }
                }
            });
        }
        this.revalidate();
    }

    private boolean install(Component component, JLayeredPane jLayeredPane) {
        if (component.getParent() != jLayeredPane) {
            if (component.getParent() != null) {
                component.getParent().remove(component);
            }
            jLayeredPane.add(component, DOCKBAR_LAYER);
            return true;
        }
        return false;
    }

    public static void windowChanged(Component component) {
        currentManager = DockbarManager.getInstance(component);
    }

    public static void activate(String string, boolean bl) {
        IDockable iDockable = DockingManager.getDockable(string);
        DockbarManager.activate(iDockable, bl);
    }

    public static void activate(IDockable iDockable, boolean bl) {
        if (iDockable == null) {
            return;
        }
        DockbarManager dockbarManager = DockbarManager.getCurrent(iDockable);
        if (dockbarManager == null || !dockbarManager.contains(iDockable)) {
            return;
        }
        dockbarManager.setActiveDockable(iDockable);
        if (bl) {
            dockbarManager.lockSlidePanel();
        }
    }

    public void lockSlidePanel() {
        this.getSlidePanel().setLocked(true);
        IDockable iDockable = this.getActiveDockable();
        DockbarEvent dockbarEvent = new DockbarEvent(iDockable, 1, this.getActivePlacement());
        this.dispatchEvent(dockbarEvent);
    }

    public boolean isSlidePanelLocked() {
        return this.getSlidePanel().isLocked();
    }

    DockbarLayout getDockbarLayout() {
        return this.dockbarLayout;
    }

    public RootWindow getWindow() {
        return (RootWindow)this.windowRef.get();
    }

    public Dockbar getBottomBar() {
        return this.bottomBar;
    }

    public Dockbar getLeftBar() {
        return this.leftBar;
    }

    public Dockbar getRightBar() {
        return this.rightBar;
    }

    public DockbarSlidePanel getSlidePanel() {
        return this.slidePanel;
    }

    public void revalidate() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DockbarManager.this.validate();
            }
        });
    }

    public void validate() {
        this.toggleDockbars();
        this.dockbarLayout.layout();
        this.slidePanel.revalidate();
        this.slidePanel.repaint();
    }

    private void toggleDockbars() {
        this.leftBar.setVisible(this.leftBar.getComponentCount() != 0);
        this.rightBar.setVisible(this.rightBar.getComponentCount() != 0);
        this.bottomBar.setVisible(this.bottomBar.getComponentCount() != 0);
    }

    private int findDockbarPlacement(IDockable iDockable) {
        RootWindow rootWindow = RootWindow.getRootWindow(iDockable.getComponent());
        if (rootWindow == null) {
            return 2;
        }
        JComponent jComponent = iDockable.getComponent();
        Container container = rootWindow.getContentPane();
        Rectangle rectangle = new Rectangle(0, 0, container.getWidth(), container.getHeight());
        Rectangle rectangle2 = SwingUtilities.convertRectangle(jComponent.getParent(), jComponent.getBounds(), container);
        Point point = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
        Point point2 = new Point(0, rectangle.height / 2);
        Point point3 = new Point(rectangle.width / 2, rectangle.height);
        Point point4 = new Point(rectangle.width, rectangle.height / 2);
        double d = Math.abs(point.distance(point2));
        int n = 2;
        double d2 = Math.abs(point.distance(point4));
        if (d2 < d) {
            d = d2;
            n = 4;
        }
        if ((d2 = Math.abs(point.distance(point3))) < d) {
            d = d2;
            n = 3;
        }
        return n;
    }

    public int getPlacement(String string) {
        IDockable iDockable = DockingManager.getDockable(string);
        return this.getPlacement(iDockable);
    }

    public int getPlacement(IDockable iDockable) {
        Dockbar dockbar = this.getDockbar(iDockable);
        if (dockbar == this.leftBar) {
            return 2;
        }
        if (dockbar == this.rightBar) {
            return 4;
        }
        if (dockbar == this.bottomBar) {
            return 3;
        }
        return -1;
    }

    public Dockbar getDockbar(IDockable iDockable) {
        if (iDockable == null) {
            return null;
        }
        if (this.leftBar.contains(iDockable)) {
            return this.leftBar;
        }
        if (this.rightBar.contains(iDockable)) {
            return this.rightBar;
        }
        if (this.bottomBar.contains(iDockable)) {
            return this.bottomBar;
        }
        return null;
    }

    public Dockbar getDockbar(int n) {
        switch (n) {
            case 4: {
                return this.rightBar;
            }
            case 3: {
                return this.bottomBar;
            }
        }
        return this.leftBar;
    }

    void minimize(IDockable iDockable, Perspective perspective) {
        if (iDockable == null) {
            return;
        }
        int n = 2;
        RootWindow rootWindow = this.getWindow();
        if (rootWindow != null && DockingManager.isDocked(iDockable)) {
            n = this.findDockbarPlacement(iDockable);
        }
        this.minimize(iDockable, perspective, n);
    }

    void minimize(IDockable iDockable, Perspective perspective, int n) {
        if (iDockable == null) {
            return;
        }
        if (this.isDockingCancelled(iDockable, n)) {
            return;
        }
        this.install(iDockable, perspective, n);
        this.dockables.put(iDockable.getID(), n);
        iDockable.getComponent().addPropertyChangeListener(this.dockablePropertyHandler);
        DockbarEvent dockbarEvent = new DockbarEvent(iDockable, 11, n);
        this.dispatchEvent(dockbarEvent);
    }

    void reAdd(IDockable iDockable, Perspective perspective) {
        if (iDockable == null || this.contains(iDockable)) {
            return;
        }
        Integer n = this.dockables.get(iDockable.getID());
        if (n != null) {
            this.install(iDockable, perspective, n);
        }
    }

    List<IDockable> getDockables(int n) {
        ArrayList<IDockable> arrayList = new ArrayList<IDockable>();
        for (Map.Entry<String, Integer> entry : this.dockables.entrySet()) {
            if (entry.getValue() != n) continue;
            arrayList.add(DockingManager.getDockable(entry.getKey()));
        }
        return arrayList;
    }

    private void install(IDockable iDockable, Perspective perspective, int n) {
        Dockbar dockbar = this.getDockbar(n);
        DockingManager.undock(iDockable);
        dockbar.dock(iDockable);
        iDockable.setDockingEnabled(false);
        DockingState dockingState = perspective.getDockingState(iDockable, false);
        dockingState.setPlacement(n);
        this.revalidate();
    }

    private boolean isDockingCancelled(IDockable iDockable, int n) {
        DockbarEvent dockbarEvent = new DockbarEvent(iDockable, 10, n);
        this.dispatchEvent(dockbarEvent);
        return dockbarEvent.isConsumed();
    }

    void restore(IDockable iDockable, Perspective perspective) {
        boolean bl = RestorationManager.getInstance().restore(iDockable, perspective);
        if (bl) {
            this.remove(iDockable);
            this.dockables.remove(iDockable.getID());
            iDockable.getComponent().removePropertyChangeListener(this.dockablePropertyHandler);
        }
    }

    public boolean remove(IDockable iDockable) {
        Dockbar dockbar;
        if (iDockable == null) {
            return false;
        }
        if (this.getActiveDockable() == iDockable) {
            this.setActiveDockable((IDockable)null);
        }
        if ((dockbar = this.getDockbar(iDockable)) == null) {
            return false;
        }
        dockbar.undock(iDockable);
        iDockable.setDockingEnabled(true);
        this.revalidate();
        return true;
    }

    public int getActivePlacement() {
        return this.activePlacement;
    }

    private void setActivePlacement(int n) {
        this.activePlacement = n;
    }

    String getActiveDockableId() {
        return this.activeDockableId;
    }

    private void setActiveDockableId(String string) {
        this.activeDockableId = string;
    }

    public IDockable getActiveDockable() {
        String string = this.getActiveDockableId();
        IDockable iDockable = DockingManager.getDockable(string);
        return iDockable;
    }

    public Cursor getResizeCursor() {
        return this.slidePanel.getResizeCursor();
    }

    public boolean isActive() {
        return this.getActiveDockable() != null;
    }

    public boolean isDockbarActive() {
        return this.isActive() && !this.isAnimating() && !this.isDragging();
    }

    public void setActiveDockable(String string) {
        IDockable iDockable = DockingManager.getDockable(string);
        this.setActiveDockable(iDockable);
    }

    public void setActiveDockable(IDockable iDockable) {
        int n = this.getPlacement(iDockable);
        if (n == -1) {
            iDockable = null;
        }
        IDockable iDockable2 = this.getActiveDockable();
        String string = iDockable == null ? null : iDockable.getID();
        String string2 = this.getActiveDockableId();
        boolean bl = DockingUtility.isChanged(string2, string);
        if (bl |= n != this.getActivePlacement()) {
            this.slidePanel.setLocked(false);
            this.setActivePlacement(n);
            this.setActiveDockableId(string);
            this.startAnimation(iDockable2, iDockable, string, n);
        }
    }

    private void dispatchEvent(IDockable iDockable, IDockable iDockable2) {
        int n = 0;
        if (iDockable2 == null && iDockable != null) {
            iDockable2 = iDockable;
            n = 2;
        }
        if (iDockable2 != null) {
            DockbarEvent dockbarEvent = new DockbarEvent(iDockable2, n, this.getActivePlacement());
            this.dispatchEvent(dockbarEvent);
        }
    }

    private void startAnimation(final IDockable iDockable, final IDockable iDockable2, final String string, final int n) {
        SlidePanelAnimation slidePanelAnimation = iDockable == null ? null : new SlidePanelAnimation(this, true);
        Runnable runnable = new Runnable(){

            public void run() {
                DockbarManager.this.setActivePlacement(n);
                DockbarManager.this.setActiveDockableId(string);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        (this).DockbarManager.this.slidePanel.updatePlacement();
                        (this).DockbarManager.this.slidePanel.updateContents();
                    }
                });
            }
        };
        SlidePanelAnimation slidePanelAnimation2 = string == null ? null : new SlidePanelAnimation(this, false);
        Runnable runnable2 = new Runnable(){

            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        (this).DockbarManager.this.slidePanel.setPrefSize(-1);
                        (this).DockbarManager.this.slidePanel.updatePlacement();
                        (this).DockbarManager.this.slidePanel.updateContents();
                        DockbarManager.this.dispatchEvent(iDockable, iDockable2);
                    }
                });
            }
        };
        ActivationQueue activationQueue = new ActivationQueue(slidePanelAnimation, runnable, slidePanelAnimation2, runnable2);
        activationQueue.start();
    }

    public int getPreferredViewpaneSize() {
        return this.dockbarLayout.getDesiredViewpaneSize();
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void setAnimating(boolean bl) {
        this.animating = bl;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean bl) {
        this.dragging = bl;
    }

    DockbarDeactivator getDockbarDeactivator() {
        return this.dockbarDeactivator;
    }

    public boolean contains(IDockable iDockable) {
        return this.getDockbar(iDockable) != null;
    }

    private boolean isOwner(IDockable iDockable) {
        return iDockable == null ? false : this.dockables.containsKey(iDockable.getID());
    }

    DockbarLayout getLayout() {
        return this.dockbarLayout;
    }

    public void addDockbarListener(IDockbarEventListener iDockbarEventListener) {
        this.dockbarListeners.add(iDockbarEventListener);
    }

    public List<IDockbarEventListener> getDockbarListeners() {
        return this.dockbarListeners;
    }

    public void removeDockbarListener(IDockbarEventListener iDockbarEventListener) {
        this.dockbarListeners.remove(iDockbarEventListener);
    }

    private void dispatchEvent(DockbarEvent dockbarEvent) {
        for (IDockbarEventListener iDockbarEventListener : this.getDockbarListeners()) {
            switch (dockbarEvent.getEventType()) {
                case 0: {
                    iDockbarEventListener.dockableExpanded(dockbarEvent);
                    break;
                }
                case 1: {
                    iDockbarEventListener.dockableLocked(dockbarEvent);
                    break;
                }
                case 2: {
                    iDockbarEventListener.dockableCollapsed(dockbarEvent);
                    break;
                }
                case 10: {
                    iDockbarEventListener.minimizeStarted(dockbarEvent);
                    break;
                }
                case 11: {
                    iDockbarEventListener.minimizeCompleted(dockbarEvent);
                }
            }
        }
    }

    private static class ActivationQueue
    extends Thread {
        private SlidePanelAnimation deactivation;
        private Runnable postDeactivate;
        private SlidePanelAnimation activation;
        private Runnable postActivate;

        public ActivationQueue(SlidePanelAnimation slidePanelAnimation, Runnable runnable, SlidePanelAnimation slidePanelAnimation2, Runnable runnable2) {
            this.deactivation = slidePanelAnimation;
            this.postDeactivate = runnable;
            this.activation = slidePanelAnimation2;
            this.postActivate = runnable2;
        }

        public void run() {
            if (this.deactivation != null) {
                this.deactivation.run();
            }
            this.postDeactivate.run();
            if (this.activation != null) {
                this.activation.run();
            }
            this.postActivate.run();
        }
    }

    private static class DockablePropertyChangeHandler
    implements PropertyChangeListener {
        private DockablePropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DockbarLabel dockbarLabel;
            IDockable iDockable = (IDockable)propertyChangeEvent.getSource();
            DockbarManager dockbarManager = DockbarManager.getCurrent();
            if (dockbarManager == null || !DockingManager.isMinimized(iDockable, DockingManager.getPerspectiveManager().getCurrentPerspective())) {
                return;
            }
            Dockbar dockbar = dockbarManager.getDockbar(iDockable);
            DockbarLabel dockbarLabel2 = dockbarLabel = dockbar == null ? null : dockbar.getLabel(iDockable);
            if (dockbarLabel == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if ("dockbarIcon".equals(string)) {
                dockbarLabel.setIcon(iDockable.getDockbarIcon());
            } else if ("tabText".equals(string)) {
                dockbarLabel.setText(iDockable.getTabText());
            }
        }
    }
}

