/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.FloatingDialog;
import de.javasoft.swing.jydocking.FloatingFrame;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DockingPortTracker
implements HierarchyListener,
AncestorListener {
    private static final DockingPortTracker INSTANCE = new DockingPortTracker();
    private static WeakHashMap<RootWindow, RootDockingPortList> TRACKERS_BY_WINDOW = new WeakHashMap();
    private static WeakHashMap<IDockingPort, Object> DOCKING_PORTS = new WeakHashMap();
    private static final Object DUMMY = new Object();

    private DockingPortTracker() {
    }

    public static DockingPortTracker getInstance() {
        return INSTANCE;
    }

    public static IDockingPort getRootDockingPort(Window window, boolean bl) {
        RootWindow rootWindow;
        RootWindow rootWindow2 = rootWindow = window == null ? null : RootWindow.getRootWindow(window);
        if (rootWindow != null) {
            return DockingPortTracker.getRootDockingPort(rootWindow.getRootComponent());
        }
        for (IDockingPort iDockingPort : DockingPortTracker.getRootDockingPorts()) {
            boolean bl2;
            Window window2 = SwingUtilities.getWindowAncestor(iDockingPort.getComponent());
            boolean bl3 = bl2 = window2 instanceof FloatingDialog || window2 instanceof FloatingFrame;
            if (!bl && bl2) continue;
            return iDockingPort;
        }
        return null;
    }

    private static Set<IDockingPort> getRootDockingPorts() {
        HashSet<IDockingPort> hashSet = new HashSet<IDockingPort>();
        for (IDockingPort iDockingPort : DockingPortTracker.getDockingPorts()) {
            if (!iDockingPort.isRoot()) continue;
            hashSet.add(iDockingPort);
        }
        return hashSet;
    }

    private static Set<IDockingPort> getDockingPorts() {
        HashSet<IDockingPort> hashSet = new HashSet<IDockingPort>();
        for (IDockingPort iDockingPort : DOCKING_PORTS.keySet()) {
            hashSet.add(iDockingPort);
        }
        return hashSet;
    }

    public static IDockingPort getRootDockingPort(Component component) {
        Component component2 = component;
        IDockingPort iDockingPort = null;
        while (component2 != null) {
            if (component2 instanceof IDockingPort) {
                iDockingPort = (IDockingPort)((Object)component2);
            }
            component2 = component2.getParent();
        }
        if (iDockingPort == null) {
            RootDockingPortList rootDockingPortList = DockingPortTracker.getRootDockingPortList(RootWindow.getRootWindow(component));
            iDockingPort = rootDockingPortList == null ? null : rootDockingPortList.getPort();
        }
        return iDockingPort;
    }

    static void updateIndex(IDockingPort iDockingPort) {
        DOCKING_PORTS.put(iDockingPort, DUMMY);
        RootDockingPortList rootDockingPortList = DockingPortTracker.getRootDockingPortList(iDockingPort);
        if (rootDockingPortList != null) {
            rootDockingPortList.remove(iDockingPort);
            rootDockingPortList.add(iDockingPort);
        }
    }

    static IDockingPort getRootDockingPort(String string) {
        for (RootDockingPortList rootDockingPortList : TRACKERS_BY_WINDOW.values()) {
            IDockingPort iDockingPort = rootDockingPortList.getPort(string);
            if (iDockingPort == null) continue;
            return iDockingPort;
        }
        return null;
    }

    private static RootDockingPortList getRootDockingPortList(IDockingPort iDockingPort) {
        for (RootDockingPortList rootDockingPortList : TRACKERS_BY_WINDOW.values()) {
            if (!rootDockingPortList.contains(iDockingPort)) continue;
            return rootDockingPortList;
        }
        return null;
    }

    private static RootDockingPortList getRootDockingPortList(RootWindow rootWindow) {
        if (rootWindow == null) {
            return null;
        }
        RootDockingPortList rootDockingPortList = TRACKERS_BY_WINDOW.get(rootWindow);
        if (rootDockingPortList == null) {
            rootDockingPortList = new RootDockingPortList();
            TRACKERS_BY_WINDOW.put(rootWindow, rootDockingPortList);
        }
        return rootDockingPortList;
    }

    private void dockingPortAdded(RootWindow rootWindow, IDockingPort iDockingPort) {
        RootDockingPortList rootDockingPortList = DockingPortTracker.getRootDockingPortList(rootWindow);
        if (rootDockingPortList != null) {
            rootDockingPortList.add(iDockingPort);
        }
    }

    private void dockingPortRemoved(RootWindow rootWindow, IDockingPort iDockingPort) {
        RootDockingPortList rootDockingPortList = DockingPortTracker.getRootDockingPortList(rootWindow);
        if (rootDockingPortList != null) {
            rootDockingPortList.remove(iDockingPort);
        }
        DockingManager.removeMaximizedState(iDockingPort);
    }

    static List<RootWindow> getDockingRootWindows() {
        return new ArrayList<RootWindow>(new HashSet<RootWindow>(TRACKERS_BY_WINDOW.keySet()));
    }

    static void remove(RootWindow rootWindow) {
        TRACKERS_BY_WINDOW.remove(rootWindow);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        IDockingPort iDockingPort = (IDockingPort)hierarchyEvent.getSource();
        if (!iDockingPort.isRoot()) {
            return;
        }
        if (!this.isParentChange(hierarchyEvent)) {
            return;
        }
        Container container = hierarchyEvent.getChangedParent();
        RootWindow rootWindow = RootWindow.getRootWindow(container);
        if (rootWindow == null) {
            return;
        }
        if (hierarchyEvent.getChanged().getParent() == null) {
            this.dockingPortRemoved(rootWindow, iDockingPort);
        } else {
            this.dockingPortAdded(rootWindow, iDockingPort);
        }
    }

    private boolean isParentChange(HierarchyEvent hierarchyEvent) {
        return hierarchyEvent.getID() == 1400 && hierarchyEvent.getChangeFlags() == 1L;
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        IDockingPort iDockingPort = (IDockingPort)((Object)ancestorEvent.getComponent());
        RootWindow rootWindow = RootWindow.getRootWindow(iDockingPort.getComponent());
        if (!iDockingPort.isRoot() || rootWindow == null) {
            return;
        }
        this.dockingPortRemoved(rootWindow, iDockingPort);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    private static class RootDockingPortList {
        private ArrayList<IDockingPort> rootPorts = new ArrayList(2);

        public void add(IDockingPort iDockingPort) {
            if (!this.rootPorts.contains(iDockingPort)) {
                this.rootPorts.add(iDockingPort);
            }
        }

        public void remove(IDockingPort iDockingPort) {
            this.rootPorts.remove(iDockingPort);
        }

        public boolean contains(IDockingPort iDockingPort) {
            return this.rootPorts.contains(iDockingPort);
        }

        public IDockingPort getPort() {
            return this.rootPorts.isEmpty() ? null : this.rootPorts.get(0);
        }

        public IDockingPort getPort(String string) {
            for (IDockingPort iDockingPort : this.rootPorts) {
                if (!iDockingPort.getID().equals(string)) continue;
                return iDockingPort;
            }
            return null;
        }
    }
}

