/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.DragManager;
import de.javasoft.swing.jydocking.DragOperation;
import de.javasoft.swing.jydocking.DragOutlinePreview;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IDragPreview;
import de.javasoft.swing.jydocking.NestedComponents;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DragGlassPane
extends JComponent {
    private static final long serialVersionUID = -837777168697616982L;
    private NestedComponents currentDropTargets;
    private Component cachedGlassPane;
    private RootWindow rootWindow;
    private IDragPreview previewDelegate;
    private Polygon previewPoly;
    private DragOperation currentDragOperation;

    public DragGlassPane() {
        this.setLayout(null);
    }

    public void clear() {
        this.currentDropTargets = null;
        this.currentDragOperation = null;
        this.repaint();
    }

    public Component getCachedGlassPane() {
        return this.cachedGlassPane;
    }

    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    public void setCachedGlassPane(Component component) {
        this.cachedGlassPane = component;
    }

    public void setRootWindow(RootWindow rootWindow) {
        this.rootWindow = rootWindow;
    }

    private NestedComponents getDropTargets(DragOperation dragOperation) {
        Container container = this.rootWindow.getContentPane();
        Point point = dragOperation.getCurrentMouse(container);
        Component component = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        return NestedComponents.find(component, IDockable.class, IDockingPort.class);
    }

    public void processDragEvent(DragOperation dragOperation) {
        this.currentDragOperation = dragOperation;
        NestedComponents nestedComponents = this.getDropTargets(dragOperation);
        if (this.currentDropTargets == null && nestedComponents == null || nestedComponents == null) {
            dragOperation.setTarget(null, "UNKNOWN");
            this.currentDragOperation = null;
            this.repaint();
            return;
        }
        IDockingPort iDockingPort = (IDockingPort)((Object)nestedComponents.parent);
        if (iDockingPort == null) {
            dragOperation.setTarget(null, "UNKNOWN");
            this.currentDragOperation = null;
            this.repaint();
            return;
        }
        this.currentDropTargets = nestedComponents;
        IDockable iDockable = this.getHoverDockable(nestedComponents);
        Point point = dragOperation.getCurrentMouse(iDockingPort.getComponent());
        String string = this.findRegion(iDockingPort, iDockable, point);
        int n = -1;
        if (DockingManager.isTabReorderByDraggingEnabled() && iDockable != null) {
            Container container = iDockable.getComponent().getParent();
            if (string == "CENTER" && (container instanceof JTabbedPane || container != null && container.getParent() instanceof JYTabbedPane)) {
                JTabbedPane jTabbedPane = container instanceof JTabbedPane ? (JTabbedPane)container : (JTabbedPane)container.getParent();
                Point point2 = SwingUtilities.convertPoint(iDockingPort.getComponent(), point, jTabbedPane);
                int n2 = 0;
                while (n2 < jTabbedPane.getTabCount()) {
                    if (jTabbedPane.getBoundsAt(n2).contains(point2)) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            }
        }
        dragOperation.setDropTabIndex(n);
        if (!iDockingPort.isDockingAllowed(dragOperation.getDockableReference().getComponent(), string)) {
            string = "UNKNOWN";
        }
        dragOperation.setTarget(iDockingPort, string);
        this.previewPoly = this.createPreviewPolygon(dragOperation, iDockingPort, iDockable, string);
        this.repaint();
    }

    private String findRegion(IDockingPort iDockingPort, IDockable iDockable, Point point) {
        if (iDockingPort == null) {
            return "UNKNOWN";
        }
        if (iDockable != null) {
            return iDockingPort.getRegion(point);
        }
        JComponent jComponent = iDockingPort.getDockedComponent();
        if (jComponent == null) {
            return iDockingPort.getRegion(point);
        }
        return "UNKNOWN";
    }

    private IDockable getHoverDockable(NestedComponents nestedComponents) {
        Component component;
        Component component2 = component = nestedComponents == null ? null : nestedComponents.child;
        if (component instanceof IDockable) {
            return (IDockable)((Object)component);
        }
        return DockingManager.getDockable(component);
    }

    protected Polygon createPreviewPolygon(DragOperation dragOperation, IDockingPort iDockingPort, IDockable iDockable, String string) {
        Map<Object, Object> map = this.getDragContext(dragOperation);
        if (dragOperation != null) {
            map.put("DROP_TAB_INDEX", dragOperation.getDropTabIndex());
        }
        JComponent jComponent = dragOperation.getDockableComponent();
        return this.getPreviewDelegate(jComponent, iDockingPort).createPreviewPolygon(jComponent, iDockingPort, iDockable, string, this, map);
    }

    private IDragPreview getPreviewDelegate(Component component, IDockingPort iDockingPort) {
        if (this.previewDelegate == null) {
            this.previewDelegate = this.createPreview(UIManager.getString("JYDocking.dragPreview.className"));
        }
        return this.previewDelegate;
    }

    private IDragPreview createPreview(String string) {
        if (string == null) {
            string = DragOutlinePreview.class.getName();
        }
        return (IDragPreview)DockingUtility.createInstance(string, IDragPreview.class);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.currentDragOperation != null && this.previewDelegate != null && this.previewPoly != null) {
            this.getRootPane().setCursor(WidgetUtils.getDragCursor());
        } else {
            this.getRootPane().setCursor(WidgetUtils.getStopCursor());
        }
        if (this.currentDragOperation != null && this.previewDelegate != null && this.previewPoly != null) {
            IDockable iDockable = this.currentDragOperation.getDockableReference();
            Map<Object, Object> map = this.getDragContext(this.currentDragOperation);
            this.previewDelegate.drawPreview((Graphics2D)graphics, this.previewPoly, iDockable, map);
        }
    }

    private Map<Object, Object> getDragContext(DragOperation dragOperation) {
        if (dragOperation == null) {
            return null;
        }
        IDockable iDockable = dragOperation.getDockableReference();
        return DragManager.getDragContext(iDockable);
    }
}

