/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.jydocking.ActiveDockableTracker;
import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.DragOperation;
import de.javasoft.swing.jydocking.DragPipeline;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IDockingStrategy;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.FocusManager;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DragManager
extends MouseAdapter
implements MouseMotionListener {
    private static final String DRAG_CONTEXT = "DragManager.DRAG_CONTEXT";
    private static DragOperation currentDragOperation;
    private IDockable dockable;
    private DragPipeline pipeline;
    private boolean enabled;
    private Point dragOrigin;
    private HashMap<Object, Object> dragContexts;
    private JRootPane dragStartRootPane;
    private PropertyChangeListener focusOwnerListener;

    public static void prime() {
    }

    public DragManager(IDockable iDockable) {
        this.dockable = iDockable;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.startDrag(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.finishDrag(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        if (this.dragOrigin == null) {
            this.dragOrigin = mouseEvent.getPoint();
        }
        if (this.pipeline == null || !this.pipeline.isOpen()) {
            if (this.passedDragThreshold(mouseEvent)) {
                this.dragStartRootPane = SwingUtilities.getRootPane(this.dockable.getComponent());
                this.dragStartRootPane.setCursor(WidgetUtils.getDragCursor());
                this.openPipeline(mouseEvent);
            } else {
                mouseEvent.consume();
            }
        } else {
            this.pipeline.processDragEvent(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private boolean passedDragThreshold(MouseEvent mouseEvent) {
        float f;
        double d = this.dragOrigin.distance(mouseEvent.getPoint());
        return d > (double)(f = this.dockable.getDragThreshold());
    }

    private void openPipeline(MouseEvent mouseEvent) {
        DragPipeline dragPipeline;
        DragOperation dragOperation = new DragOperation(this.dockable.getComponent(), this.dragOrigin, mouseEvent);
        dragOperation.setDragListener(this);
        DragManager.initializeListenerCaching(dragOperation);
        this.focusOwnerListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("focusedWindow".equals(string)) {
                    DragManager.cancelCurrentDragOperation();
                }
            }
        };
        FocusManager.getCurrentManager().addPropertyChangeListener(this.focusOwnerListener);
        this.pipeline = dragPipeline = new DragPipeline();
        dragPipeline.open(dragOperation);
    }

    private void startDrag(MouseEvent mouseEvent) {
        if (this.dockable == null || this.dockable.isDockingEnabled() == Boolean.FALSE.booleanValue()) {
            this.enabled = false;
        } else {
            this.toggleDragContext(true);
            this.enabled = !DragManager.isDragCanceled(this.dockable, mouseEvent);
        }
    }

    private void finishDrag(MouseEvent mouseEvent) {
        if (this.pipeline == null || !this.dockable.isDockingEnabled()) {
            return;
        }
        this.drop(this.dockable, this.pipeline.getDragOperation(), mouseEvent);
        if (this.pipeline != null) {
            this.pipeline.close();
            RootWindow[] rootWindowArray = RootWindow.getVisibleWindows();
            int n = rootWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                RootWindow rootWindow = rootWindowArray[n2];
                rootWindow.getRootPane().setCursor(null);
                ++n2;
            }
        }
        this.toggleDragContext(false);
        this.dragOrigin = null;
        this.pipeline = null;
    }

    private void drop(IDockable iDockable, DragOperation dragOperation, MouseEvent mouseEvent) {
        IDockable iDockable2;
        FocusManager.getCurrentManager().removePropertyChangeListener(this.focusOwnerListener);
        if (DockingManager.isMaximized(iDockable)) {
            DockingManager.setMaximized(iDockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), false);
        }
        if ((iDockable2 = DockingManager.getMaximizedDockable(dragOperation.getTargetPort())) != null) {
            DockingManager.toggleMaximized(iDockable2, DockingManager.getPerspectiveManager().getCurrentPerspective());
        }
        IDockingStrategy iDockingStrategy = DockingManager.getDockingStrategy(iDockable);
        IDockingPort iDockingPort = DockingUtility.getParentDockingPort(iDockable);
        IDockingPort iDockingPort2 = dragOperation.getTargetPort();
        String string = dragOperation.getTargetRegion();
        boolean bl = dragOperation.isOverWindow();
        DragManager.restoreCachedListeners(dragOperation);
        DockingEvent dockingEvent = new DockingEvent(iDockable, iDockingPort, iDockingPort2, 3, mouseEvent, DragManager.getDragContext(this.dockable));
        dockingEvent.setRegion(string);
        dockingEvent.setOverWindow(bl);
        if (!dragOperation.isCanceled()) {
            DockingManager.dispatchEvent(dockingEvent);
        }
        if (!dragOperation.isCanceled() && !dockingEvent.isConsumed()) {
            Component component = SwingUtilities.getWindowAncestor(iDockable.getComponent()).getFocusOwner();
            if (dragOperation.getDropTabIndex() >= 0 && iDockingPort2 != null && iDockingPort2.getDockedComponent() instanceof JYTabbedPane) {
                final JYTabbedPane jYTabbedPane = (JYTabbedPane)iDockingPort2.getDockedComponent();
                int n = jYTabbedPane.getSelectedIndex();
                final int n2 = dragOperation.getDropTabIndex();
                if (jYTabbedPane.getComponentAt(n) == iDockable.getComponent()) {
                    jYTabbedPane.moveTab(n, n2);
                } else {
                    iDockingStrategy.dock(iDockable, iDockingPort2, DockingManager.getPerspectiveManager().getCurrentPerspective(), string);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jYTabbedPane.moveTab(jYTabbedPane.getSelectedIndex(), n2);
                        }
                    });
                }
            } else {
                iDockingStrategy.dock(iDockable, iDockingPort2, DockingManager.getPerspectiveManager().getCurrentPerspective(), string);
            }
            ActiveDockableTracker.requestDockableActivation(iDockable.getComponent(), component, true);
        }
    }

    private static void initializeListenerCaching(DragOperation dragOperation) {
        Component component = dragOperation.getDragSource();
        EventListener[] eventListenerArray = component.getListeners(MouseMotionListener.class);
        dragOperation.setCachedListeners(eventListenerArray);
        DragManager dragManager = dragOperation.getDragListener();
        int n = 0;
        while (n < eventListenerArray.length) {
            component.removeMouseMotionListener((MouseMotionListener)eventListenerArray[n]);
            ++n;
        }
        if (dragManager != null) {
            component.addMouseMotionListener(dragManager);
        }
    }

    private static void restoreCachedListeners(DragOperation dragOperation) {
        Component component = dragOperation.getDragSource();
        EventListener[] eventListenerArray = dragOperation.getCachedListeners();
        DragManager dragManager = dragOperation.getDragListener();
        if (dragManager != null) {
            component.removeMouseMotionListener(dragManager);
        }
        int n = 0;
        while (n < eventListenerArray.length) {
            component.addMouseMotionListener((MouseMotionListener)eventListenerArray[n]);
            ++n;
        }
    }

    private static boolean isDragCanceled(IDockable iDockable, MouseEvent mouseEvent) {
        IDockingPort iDockingPort = DockingUtility.getParentDockingPort(iDockable);
        Map<Object, Object> map = DragManager.getDragContext(iDockable);
        DockingEvent dockingEvent = new DockingEvent(iDockable, iDockingPort, null, 2, mouseEvent, map);
        DockingManager.dispatchEvent(dockingEvent);
        return dockingEvent.isConsumed();
    }

    private void toggleDragContext(boolean bl) {
        if (bl) {
            if (this.dragContexts == null) {
                this.dragContexts = new HashMap();
                this.dockable.getComponent().putClientProperty(DRAG_CONTEXT, this.dragContexts);
            }
        } else {
            if (this.dragContexts != null) {
                this.dragContexts.clear();
                this.dragContexts = null;
            }
            this.dockable.getComponent().putClientProperty(DRAG_CONTEXT, null);
        }
    }

    static DragOperation getCurrentDragOperation() {
        return currentDragOperation;
    }

    static void cancelCurrentDragOperation() {
        currentDragOperation.setCanceled(true);
        DragManager dragManager = DockingManager.getDragListener(currentDragOperation.getDockableReference());
        dragManager.finishDrag(null);
    }

    static void setCurrentDragOperation(DragOperation dragOperation) {
        currentDragOperation = dragOperation;
    }

    static Map<Object, Object> getDragContext(IDockable iDockable) {
        return iDockable == null ? null : (Map)iDockable.getComponent().getClientProperty(DRAG_CONTEXT);
    }
}

