/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DragManager;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingPort;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class DragOperation
implements IDockingConstants {
    private Component dragSource;
    private JComponent dockable;
    private IDockingPort parentDockingPort;
    private Point mouseOffset;
    private Point currentMouse;
    private Point currentMouseOnScreen;
    private EventListener[] cachedListeners;
    private DragManager dragListener;
    private IDockingPort targetPort;
    private String targetRegion;
    private boolean overWindow;
    private boolean pseudoDrag;
    private long started;
    private IDockable dockableRef;
    private IDockingPort sourcePort;
    private boolean canceled;
    private int dropTabIndex;

    public DragOperation(JComponent jComponent, Point point, MouseEvent mouseEvent) {
        if (jComponent == null) {
            throw new NullPointerException("'dockable' parameter cannot be null.");
        }
        if (mouseEvent == null) {
            throw new NullPointerException("'evt' parameter cannot be null.");
        }
        if (!(mouseEvent.getSource() instanceof Component)) {
            throw new IllegalArgumentException("'evt.getSource()' must be an instance of java.awt.Component.");
        }
        if (point == null) {
            point = mouseEvent.getPoint();
        }
        this.init(jComponent, (Component)mouseEvent.getSource(), point, false);
    }

    private void init(JComponent jComponent, Component component, Point point, boolean bl) {
        this.dockable = jComponent;
        this.dragSource = component;
        this.currentMouse = point;
        this.mouseOffset = this.calculateMouseOffset(point);
        this.pseudoDrag = bl;
        if (!bl) {
            this.parentDockingPort = (IDockingPort)((Object)SwingUtilities.getAncestorOfClass(IDockingPort.class, jComponent));
        }
        this.sourcePort = DockingManager.getDockingPort(jComponent);
        this.started = -1L;
    }

    private Point calculateMouseOffset(Point point) {
        if (point == null) {
            return null;
        }
        Point point2 = this.dockable.getLocationOnScreen();
        Point point3 = new Point(point);
        SwingUtilities.convertPointToScreen(point3, this.dragSource);
        Point point4 = new Point();
        point4.x = point2.x - point3.x;
        point4.y = point2.y - point3.y;
        return point4;
    }

    public JComponent getDockableComponent() {
        return this.dockable;
    }

    public IDockable getDockableReference() {
        if (this.dockableRef == null) {
            this.dockableRef = DockingManager.getDockable(this.dockable);
        }
        return this.dockableRef;
    }

    public Point getMouseOffset() {
        return (Point)this.mouseOffset.clone();
    }

    public void updateMouse(MouseEvent mouseEvent) {
        if (mouseEvent != null && mouseEvent.getSource() == this.dragSource) {
            this.currentMouse = mouseEvent.getPoint();
            this.currentMouseOnScreen = (Point)this.currentMouse.clone();
            SwingUtilities.convertPointToScreen(this.currentMouseOnScreen, this.dragSource);
        }
    }

    public Point getCurrentMouse() {
        return this.getCurrentMouse(false);
    }

    public Point getCurrentMouse(boolean bl) {
        return bl ? new Point(this.currentMouseOnScreen) : new Point(this.currentMouse);
    }

    public Rectangle getDragRect(boolean bl) {
        Point point = this.getCurrentMouse(bl);
        Point point2 = this.getMouseOffset();
        point.x += point2.x;
        point.y += point2.y;
        Rectangle rectangle = new Rectangle(this.getDragSize());
        rectangle.setLocation(point);
        return rectangle;
    }

    public Point getCurrentMouse(Component component) {
        if (component == null || !component.isVisible()) {
            return null;
        }
        return SwingUtilities.convertPoint(this.dragSource, this.currentMouse, component);
    }

    public Dimension getDragSize() {
        return this.dockable.getSize();
    }

    public Component getDragSource() {
        return this.dragSource;
    }

    public void setTarget(IDockingPort iDockingPort, String string) {
        this.targetPort = iDockingPort;
        this.targetRegion = string == null ? "UNKNOWN" : string;
    }

    public IDockingPort getTargetPort() {
        return this.targetPort;
    }

    public String getTargetRegion() {
        return this.targetRegion;
    }

    public EventListener[] getCachedListeners() {
        return this.cachedListeners == null ? new EventListener[]{} : this.cachedListeners;
    }

    public void setCachedListeners(EventListener[] eventListenerArray) {
        this.cachedListeners = eventListenerArray;
    }

    public DragManager getDragListener() {
        return this.dragListener;
    }

    public void setDragListener(DragManager dragManager) {
        this.dragListener = dragManager;
    }

    public boolean isOverWindow() {
        return this.overWindow;
    }

    public void setOverWindow(boolean bl) {
        this.overWindow = bl;
    }

    public boolean isPseudoDrag() {
        return this.pseudoDrag;
    }

    public IDockingPort getParentDockingPort() {
        return this.parentDockingPort;
    }

    public void start() {
        if (this.started == -1L) {
            this.started = System.currentTimeMillis();
        }
    }

    public long getStartTime() {
        return this.started;
    }

    public IDockingPort getSourcePort() {
        return this.sourcePort;
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public int getDropTabIndex() {
        return this.dropTabIndex;
    }

    public void setDropTabIndex(int n) {
        this.dropTabIndex = n;
    }
}

