/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.ILayoutNode;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatingGroup
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -891385529699322982L;
    private String id;
    private HashSet<String> dockableIDs;
    private Rectangle windowBounds;
    private transient Window floatingWindow;
    private ILayoutNode restorationLayout;

    public FloatingGroup(String string) {
        this.id = string == null ? UUID.randomUUID().toString() : string;
        this.dockableIDs = new HashSet();
    }

    private FloatingGroup(String string, HashSet<String> hashSet) {
        this.id = string;
        this.dockableIDs = hashSet;
    }

    void setFloatingWindow(Window window) {
        this.floatingWindow = window;
    }

    public Window getFloatingWindow() {
        return this.floatingWindow;
    }

    public void setBounds(Rectangle rectangle) {
        this.windowBounds = rectangle == null ? null : new Rectangle(rectangle);
    }

    public Rectangle getBounds() {
        return this.windowBounds == null ? null : (Rectangle)this.windowBounds.clone();
    }

    public String getID() {
        return this.id;
    }

    public void addDockable(String string) {
        this.dockableIDs.add(string);
    }

    public void removeDockable(String string) {
        this.dockableIDs.remove(string);
    }

    public boolean hasDockable(String string) {
        return this.dockableIDs.contains(string);
    }

    Iterator<String> getDockableIterator() {
        return this.dockableIDs.iterator();
    }

    public List<IDockable> getDockables() {
        ArrayList<IDockable> arrayList = new ArrayList<IDockable>();
        for (String string : this.dockableIDs) {
            arrayList.add(DockingManager.getDockable(string));
        }
        return arrayList;
    }

    public int getDockableCount() {
        return this.dockableIDs.size();
    }

    public void destroy() {
        this.dockableIDs.clear();
        this.setFloatingWindow(null);
        this.setBounds(null);
    }

    ILayoutNode getRestorationLayout() {
        return this.restorationLayout;
    }

    void setRestorationLayout(ILayoutNode iLayoutNode) {
        this.restorationLayout = iLayoutNode;
    }

    public Object clone() {
        FloatingGroup floatingGroup = new FloatingGroup(this.id, new HashSet<String>(this.dockableIDs));
        floatingGroup.floatingWindow = this.floatingWindow;
        floatingGroup.windowBounds = this.windowBounds == null ? null : new Rectangle(this.windowBounds);
        floatingGroup.restorationLayout = this.restorationLayout;
        return floatingGroup;
    }
}

