/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jytable.sort;

import de.javasoft.swing.sort.ISortController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.sort.SortUtils;
import org.jdesktop.swingx.sort.TableSortController;

public class JYTableSortController<M extends TableModel>
extends TableSortController<M>
implements ISortController<M> {
    public JYTableSortController() {
        this(null);
    }

    public JYTableSortController(M model) {
        super(model);
        this.init();
    }

    private void init() {
        this.setMaxSortKeys(1);
    }

    @Override
    public int getSortCount() {
        return this.getSortKeys().size();
    }

    @Override
    public int getSortIndex(int columnIndex) {
        List sortKeys = this.getSortKeys();
        RowSorter.SortKey key = SortUtils.getFirstSortKeyForColumn((List)sortKeys, (int)columnIndex);
        return key != null ? sortKeys.indexOf(key) : -1;
    }

    @Override
    public void toggleSortOrder(int columnIndex, boolean isMultipleSort) {
        this.checkColumn(columnIndex);
        if (!this.isSortable(columnIndex)) {
            return;
        }
        if (isMultipleSort) {
            this.toggleMultipleSort(columnIndex);
        } else {
            this.toggleSingleSort(columnIndex);
        }
    }

    public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        super.setSortKeys(this.removeUnsorted(sortKeys));
    }

    public void setMaxSortKeys(int max) {
        super.setMaxSortKeys(max);
    }

    protected List<? extends RowSorter.SortKey> removeUnsorted(List<? extends RowSorter.SortKey> original) {
        ArrayList<? extends RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(original);
        Iterator iterator = sortKeys.iterator();
        while (iterator.hasNext()) {
            RowSorter.SortKey item = (RowSorter.SortKey)iterator.next();
            if (item.getSortOrder() != SortOrder.UNSORTED) continue;
            iterator.remove();
        }
        return sortKeys;
    }

    protected void toggleSingleSort(int columnIndex) {
        super.toggleSortOrder(columnIndex);
    }

    protected void toggleMultipleSort(int columnIndex) {
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        RowSorter.SortKey key = SortUtils.getFirstSortKeyForColumn(sortKeys, (int)columnIndex);
        if (key != null) {
            SortOrder order = this.getNextInCycle(this.getCycle(), key.getSortOrder());
            if (order != null) {
                RowSorter.SortKey toggled = new RowSorter.SortKey(columnIndex, order);
                sortKeys.set(sortKeys.indexOf(key), toggled);
                this.setSortKeys(sortKeys);
            }
        } else {
            SortOrder order = this.getFirstInCycle(this.getCycle());
            if (order != null) {
                sortKeys.add(new RowSorter.SortKey(columnIndex, order));
                this.setSortKeys(sortKeys);
            }
        }
    }

    private List<SortOrder> getCycle() {
        return Arrays.asList(this.getSortOrderCycle());
    }

    private SortOrder getNextInCycle(List<SortOrder> sortCycle, SortOrder current) {
        int pos = sortCycle.indexOf((Object)current);
        if (pos < 0) {
            return this.getFirstInCycle(sortCycle);
        }
        if (++pos >= sortCycle.size()) {
            pos = 0;
        }
        return sortCycle.get(pos);
    }

    private SortOrder getFirstInCycle(List<SortOrder> sortCycle) {
        return sortCycle.size() > 0 ? sortCycle.get(0) : null;
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }
}

