/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jytable.sort;

import de.javasoft.swing.JYTable;
import de.javasoft.swing.sort.ISortIconProvider;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class SortIconProvider
implements ISortIconProvider {
    private JLabel iconLabel;

    @Override
    public Icon getSortIcon(JComponent component, int column, boolean withText) {
        if (!(component instanceof JYTable)) {
            return null;
        }
        JYTable table = (JYTable)((Object)component);
        SortOrder sortOrder = this.getColumnSortOrder((JTable)((Object)table), column);
        Icon sortIcon = null;
        if (sortOrder != null) {
            switch (sortOrder) {
                case ASCENDING: {
                    sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                    break;
                }
                case DESCENDING: {
                    sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                    break;
                }
                case UNSORTED: {
                    sortIcon = UIManager.getIcon("Table.naturalSortIcon");
                }
            }
        }
        return withText ? this.getDecoratedIcon((JTable)((Object)table), sortIcon, column) : sortIcon;
    }

    @Override
    public String getSortText(JComponent component, int column) {
        if (!(component instanceof JYTable)) {
            return null;
        }
        JYTable table = (JYTable)((Object)component);
        int sortIndex = this.getSortIndex((JTable)((Object)table), column);
        if (sortIndex < 0 || this.getSortCount((JTable)((Object)table)) <= 1) {
            return null;
        }
        return "" + (sortIndex + 1);
    }

    private Icon getDecoratedIcon(JTable table, Icon icon, int column) {
        if (table == null || icon == null) {
            return icon;
        }
        int sortIndex = this.getSortIndex(table, column);
        if (this.getSortCount(table) <= 1 || sortIndex < 0) {
            return icon;
        }
        if (this.iconLabel == null) {
            this.iconLabel = new JLabel();
            this.iconLabel.setIconTextGap(0);
            this.iconLabel.setOpaque(false);
        }
        Font base = table.getTableHeader() != null ? table.getTableHeader().getFont() : table.getFont();
        Font font = this.getSortTextFont(base);
        String text = "" + (sortIndex + 1);
        this.iconLabel.setFont(font);
        this.iconLabel.setIcon(icon);
        this.iconLabel.setText(text);
        this.iconLabel.setComponentOrientation(table.getComponentOrientation());
        this.iconLabel.setSize(this.iconLabel.getPreferredSize().width, icon.getIconHeight() + 1);
        this.iconLabel.doLayout();
        BufferedImage image = GraphicsUtilities.createCompatibleTranslucentImage((int)this.iconLabel.getWidth(), (int)this.iconLabel.getHeight());
        Graphics2D g = image.createGraphics();
        this.iconLabel.paint(g);
        ImageIcon decorated = new ImageIcon(image);
        g.dispose();
        return decorated;
    }

    protected Font getSortTextFont(Font base) {
        Font font = base.deriveFont(0, base.getSize() - 3);
        return font;
    }

    protected int getSortIndex(JTable table, int column) {
        if (!(table instanceof JYTable)) {
            return -1;
        }
        return ((JYTable)((Object)table)).getSortIndex(column);
    }

    protected int getSortCount(JTable table) {
        if (!(table instanceof JYTable)) {
            return -1;
        }
        return ((JYTable)((Object)table)).getSortCount();
    }

    public SortOrder getColumnSortOrder(JTable table, int column) {
        if (!(table instanceof JYTable)) {
            return null;
        }
        return ((JYTable)((Object)table)).getSortOrder(column);
    }
}

