/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.JYButtonPainter;
import de.javasoft.swing.IRotatableComponent;
import de.javasoft.swing.JYButton;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.JYButtonUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class BasicJYButtonUI
extends JYButtonUI
implements PropertyChangeListener {
    protected int textShiftOffset;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJYButtonUI();
    }

    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        abstractButton.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removePropertyChangeListener(this);
    }

    protected void installDefaults(AbstractButton abstractButton) {
        Border border;
        super.installDefaults(abstractButton);
        abstractButton.setOpaque(false);
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        Insets insets3 = abstractButton.getMargin();
        if (insets3 == null || insets3 instanceof UIResource) {
            abstractButton.setMargin(new InsetsUIResource(insets.top, insets.left, insets.bottom, insets.right));
        }
        if ((border = abstractButton.getBorder()) == null || border instanceof UIResource) {
            abstractButton.setBorder(WidgetUtils.createRotatableEmptyBorder(insets2, true));
        }
        LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
            this.installDefaults((AbstractButton)jComponent);
        }
        if ("rotation".equals(string)) {
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JYButton jYButton = (JYButton)jComponent;
        int n = jYButton.getRotation().toAngle();
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        ButtonModel buttonModel = jYButton.getModel();
        SyntheticaState syntheticaState = new SyntheticaState();
        if (!buttonModel.isEnabled()) {
            syntheticaState.setState(SyntheticaState.State.DISABLED);
        }
        if (buttonModel.isSelected()) {
            syntheticaState.setState(SyntheticaState.State.SELECTED);
        }
        if (buttonModel.isPressed()) {
            syntheticaState.setState(SyntheticaState.State.PRESSED);
        }
        if (buttonModel.isRollover()) {
            syntheticaState.setState(SyntheticaState.State.HOVER);
        }
        if (jYButton.hasFocus()) {
            syntheticaState.setState(SyntheticaState.State.FOCUSED);
        }
        String string = (String)jYButton.getClientProperty("JButton.segmentPosition");
        if (jYButton.isContentAreaFilled()) {
            JYButtonPainter.getInstance().paintButtonBackground(jComponent, syntheticaState, string, n, graphics, 0, 0, n == 0 ? n2 : n3, n == 0 ? n3 : n2);
        }
        Font font = jYButton.getFont();
        FontMetrics fontMetrics = jYButton.getFontMetrics(font);
        String string2 = jYButton.getText();
        Icon icon2 = icon = jYButton.isEnabled() ? jYButton.getIcon() : jYButton.getDisabledIcon();
        if (icon == null && string2 == null) {
            return;
        }
        IRotatableComponent.Rotation rotation = jYButton.getRotation();
        Insets insets = jYButton.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n2 - insets.left - insets.right, n3 - insets.top - insets.bottom);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        string2 = this.layoutButton(jYButton, fontMetrics, string2, icon, rectangle, rectangle3, rectangle2);
        if (buttonModel.isPressed()) {
            rectangle2.x += this.textShiftOffset;
            rectangle2.y += this.textShiftOffset;
            rectangle3.x += this.textShiftOffset;
            rectangle3.y += this.textShiftOffset;
        }
        if (icon != null) {
            this.paintIcon(jYButton, graphics, icon, rectangle3, rotation);
        }
        this.paintText(jYButton, graphics, font, fontMetrics, string2, rectangle2, rotation);
    }

    private void paintText(AbstractButton abstractButton, Graphics graphics, Font font, FontMetrics fontMetrics, String string, Rectangle rectangle, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = rotation == IRotatableComponent.Rotation.RIGHT ? (rectangle.width - rectangle.height) / 2 : -(rectangle.width - rectangle.height) / 2;
            graphics2D.translate(d, d);
            graphics2D.rotate(Math.toRadians(rotation.toAngle()), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            this.paintButtonText(abstractButton, string, graphics, rectangle);
            graphics2D.rotate(-Math.toRadians(rotation.toAngle()), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            graphics2D.translate(-d, -d);
        } else {
            this.paintButtonText(abstractButton, string, graphics, rectangle);
        }
    }

    protected void paintButtonText(AbstractButton abstractButton, String string, Graphics graphics, Rectangle rectangle) {
        View view = (View)abstractButton.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            this.paintText(graphics, abstractButton, rectangle, string);
        }
    }

    private void paintIcon(JComponent jComponent, Graphics graphics, Icon icon, Rectangle rectangle, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = rotation == IRotatableComponent.Rotation.LEFT ? -(rectangle.width - rectangle.height) / 2 : (rectangle.width - rectangle.height) / 2;
            graphics2D.translate(d, d);
            graphics2D.rotate(Math.toRadians(rotation.toAngle()), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
            graphics2D.rotate(-Math.toRadians(rotation.toAngle()), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            graphics2D.translate(-d, -d);
        } else {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
    }

    private String layoutButton(AbstractButton abstractButton, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        IRotatableComponent.Rotation rotation = ((JYButton)abstractButton).getRotation();
        WidgetUtils.rotateRectangle(rectangle, rotation);
        string = this.layoutButton_(abstractButton, fontMetrics, string, icon, rectangle, rectangle2, rectangle3);
        WidgetUtils.rotateRectangle(rectangle, rotation);
        this.rotatePosition(rectangle, rectangle3, rotation);
        WidgetUtils.rotateRectangle(rectangle3, rotation);
        this.rotatePosition(rectangle, rectangle2, rotation);
        WidgetUtils.rotateRectangle(rectangle2, rotation);
        return string;
    }

    private String layoutButton_(AbstractButton abstractButton, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = abstractButton.getVerticalAlignment();
        int n2 = abstractButton.getHorizontalAlignment();
        int n3 = abstractButton.getVerticalTextPosition();
        int n4 = abstractButton.getHorizontalTextPosition();
        string = SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, abstractButton.getIconTextGap());
        return string;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle3, rectangle2, string == null ? 0 : abstractButton.getIconTextGap());
        IRotatableComponent.Rotation rotation = null;
        if (abstractButton instanceof IRotatableComponent) {
            rotation = ((IRotatableComponent)((Object)jComponent)).getRotation();
        }
        Rectangle rectangle4 = WidgetUtils.rotateRectangle(rectangle3.union(rectangle2), rotation);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        return rectangle4.getSize();
    }

    private void rotatePosition(Rectangle rectangle, Rectangle rectangle2, IRotatableComponent.Rotation rotation) {
        int n = rectangle2.x - rectangle.x;
        int n2 = rectangle2.y - rectangle.y;
        if (rotation == IRotatableComponent.Rotation.LEFT) {
            rectangle2.x = rectangle.x + n2;
            rectangle2.y = rectangle.y - n + rectangle.height - rectangle2.width;
        } else if (rotation == IRotatableComponent.Rotation.RIGHT) {
            rectangle2.x = rectangle.x - n2 + rectangle.width - rectangle2.height;
            rectangle2.y = rectangle.y + n;
        }
    }
}

