/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYSwitchButton;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.JYSwitchButtonUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicJYSwitchButtonUI
extends JYSwitchButtonUI {
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJYSwitchButtonUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installComponents(jComponent);
        this.installDefaults(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallComponents(jComponent);
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
        abstractButton.setLayout(new BorderLayout());
    }

    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        this.propertyChangeListener = this.createPropertyChangeListener();
        abstractButton.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installDefaults(JComponent jComponent) {
        Object object;
        JYSwitchButton jYSwitchButton = (JYSwitchButton)jComponent;
        JLabel jLabel = this.getSwitch(jYSwitchButton, true);
        JLabel jLabel2 = this.getSwitch(jYSwitchButton, false);
        jYSwitchButton.setOpaque(SyntheticaLookAndFeel.getBoolean("JYSwitchButton.opaque", jYSwitchButton));
        if (jYSwitchButton.getBorder() == null || jYSwitchButton.getBorder() instanceof UIResource) {
            jYSwitchButton.setBorder(WidgetUtils.createOrientationAwareEmptyBorder(SyntheticaLookAndFeel.getInsets("JYSwitchButton.insets", (Component)jComponent, new Insets(4, 4, 4, 4)), true));
        }
        if (jYSwitchButton.onForegroundIsUIResource()) {
            object = SyntheticaLookAndFeel.getColor("JYSwitchButton.switch.onForeground", jYSwitchButton, new Color(0xFFFFFF));
            jYSwitchButton.setOnForeground((Color)object, true);
        } else {
            jLabel.setForeground(this.getSwitchForeground(jYSwitchButton, true));
        }
        if (jYSwitchButton.onTextIsUIResource()) {
            object = SyntheticaLookAndFeel.getString("JYSwitchButton.switch.onText", jYSwitchButton);
            jYSwitchButton.setOnText((String)object, true);
        } else {
            jLabel.setText(jYSwitchButton.getOnText());
        }
        if (jYSwitchButton.onFontSizeIsUIResource()) {
            int n = SyntheticaLookAndFeel.getInt("JYSwitchButton.switch.onFontSize", jYSwitchButton, SyntheticaLookAndFeel.getFontSize());
            if (n == 0) {
                n = jYSwitchButton.getFont().getSize() - 1;
            }
            jYSwitchButton.setOnFontSize(n, true);
        } else {
            jLabel.setFont(new Font(SyntheticaLookAndFeel.getFontName(), (int)jYSwitchButton.getOnFontStyle(), jYSwitchButton.getOnFontSize()));
        }
        if (jYSwitchButton.onFontStyleIsUIResource()) {
            int n = SyntheticaLookAndFeel.getInt("JYSwitchButton.switch.onFontStyle", jYSwitchButton, 0);
            jYSwitchButton.setOnFontStyle(n, true);
        } else {
            jLabel.setFont(new Font(SyntheticaLookAndFeel.getFontName(), (int)jYSwitchButton.getOnFontStyle(), jYSwitchButton.getOnFontSize()));
        }
        if (jYSwitchButton.offForegroundIsUIResource()) {
            Color color = SyntheticaLookAndFeel.getColor("JYSwitchButton.switch.offForeground", jYSwitchButton, new Color(0));
            jYSwitchButton.setOffForeground(color, true);
        } else {
            jLabel2.setForeground(this.getSwitchForeground(jYSwitchButton, false));
        }
        if (jYSwitchButton.offTextIsUIResource()) {
            String string = SyntheticaLookAndFeel.getString("JYSwitchButton.switch.offText", jYSwitchButton);
            jYSwitchButton.setOffText(string, true);
        } else {
            jLabel2.setText(jYSwitchButton.getOffText());
        }
        if (jYSwitchButton.offFontSizeIsUIResource()) {
            int n = SyntheticaLookAndFeel.getInt("JYSwitchButton.switch.offFontSize", jYSwitchButton, SyntheticaLookAndFeel.getFontSize());
            if (n == 0) {
                n = jYSwitchButton.getFont().getSize() - 1;
            }
            jYSwitchButton.setOffFontSize(n, true);
        } else {
            jLabel2.setFont(new Font(SyntheticaLookAndFeel.getFontName(), (int)jYSwitchButton.getOffFontStyle(), jYSwitchButton.getOffFontSize()));
        }
        if (jYSwitchButton.offFontStyleIsUIResource()) {
            int n = SyntheticaLookAndFeel.getInt("JYSwitchButton.switch.offFontStyle", jYSwitchButton, 0);
            jYSwitchButton.setOffFontStyle(n, true);
        } else {
            jLabel2.setFont(new Font(SyntheticaLookAndFeel.getFontName(), (int)jYSwitchButton.getOffFontStyle(), jYSwitchButton.getOffFontSize()));
        }
        if (jYSwitchButton.textGapIsUIResource()) {
            int n = SyntheticaLookAndFeel.getInt("JYSwitchButton.textGap", jYSwitchButton, 6);
            jYSwitchButton.setTextGap(n);
        }
        Insets insets = SyntheticaLookAndFeel.getInsets("JYSwitchButton.switch.onInsets", (Component)jYSwitchButton, new Insets(1, 6, 1, 6));
        this.getSwitch(jYSwitchButton, true).setBorder(WidgetUtils.createOrientationAwareEmptyBorder(insets, false));
        Insets insets2 = SyntheticaLookAndFeel.getInsets("JYSwitchButton.switch.offInsets", (Component)jYSwitchButton, new Insets(1, 6, 1, 6));
        this.getSwitch(jYSwitchButton, false).setBorder(WidgetUtils.createOrientationAwareEmptyBorder(insets2, false));
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removePropertyChangeListener(this.propertyChangeListener);
    }

    private void installComponents(JComponent jComponent) {
        final AbstractButton abstractButton = (AbstractButton)jComponent;
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 5641577238552939577L;

            protected void paintComponent(Graphics graphics) {
                BasicJYSwitchButtonUI.this.paintSwitchBackground(abstractButton, abstractButton.isSelected(), graphics, 0, 0, this.getWidth(), this.getHeight());
            }

            public boolean hasFocus() {
                Container container = this.getParent();
                return container == null ? false : container.hasFocus();
            }
        };
        jPanel.setName("JYSwitchButton.SwitchPanel");
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(new OnOffSwitch(true));
        jPanel.add(new OnOffSwitch(false));
        jComponent.add((Component)jPanel, "Before");
    }

    private void uninstallComponents(JComponent jComponent) {
        jComponent.removeAll();
    }

    private Color getSwitchForeground(JYSwitchButton jYSwitchButton, boolean bl) {
        Color color = bl ? jYSwitchButton.getOnForeground() : jYSwitchButton.getOffForeground();
        boolean bl2 = SyntheticaLookAndFeel.getBoolean("JYSwitchButton.switch.disabledForegroundSupport.enabled", jYSwitchButton, true);
        color = jYSwitchButton.isEnabled() || !bl2 ? new Color(color.getRGB(), color.getAlpha() < 255) : new Color(Integer.MIN_VALUE | 0xFFFFFF & color.getRGB(), true);
        return color;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JYSwitchButton jYSwitchButton = (JYSwitchButton)propertyChangeEvent.getSource();
                String string = propertyChangeEvent.getPropertyName();
                if ("onForeground".equals(string)) {
                    BasicJYSwitchButtonUI.this.getSwitch(jYSwitchButton, true).setForeground(BasicJYSwitchButtonUI.this.getSwitchForeground(jYSwitchButton, true));
                } else if ("onText".equals(string)) {
                    BasicJYSwitchButtonUI.this.getSwitch(jYSwitchButton, true).setText((String)propertyChangeEvent.getNewValue());
                } else if ("offForeground".equals(string)) {
                    BasicJYSwitchButtonUI.this.getSwitch(jYSwitchButton, false).setForeground(BasicJYSwitchButtonUI.this.getSwitchForeground(jYSwitchButton, false));
                } else if ("offText".equals(string)) {
                    BasicJYSwitchButtonUI.this.getSwitch(jYSwitchButton, false).setText((String)propertyChangeEvent.getNewValue());
                } else if ("enabled".equals(string)) {
                    BasicJYSwitchButtonUI.this.getSwitch(jYSwitchButton, true).setForeground(BasicJYSwitchButtonUI.this.getSwitchForeground(jYSwitchButton, true));
                    BasicJYSwitchButtonUI.this.getSwitch(jYSwitchButton, false).setForeground(BasicJYSwitchButtonUI.this.getSwitchForeground(jYSwitchButton, false));
                } else if ("textGap".equals(string)) {
                    jYSwitchButton.setIconTextGap((Integer)propertyChangeEvent.getNewValue());
                } else if ("onFontSize".equals(string) || "onFontStyle".equals(string)) {
                    int n = jYSwitchButton.getOnFontSize();
                    Integer n2 = jYSwitchButton.getOnFontStyle();
                    Font font = new Font(SyntheticaLookAndFeel.getFontName(), n2 == null ? 0 : n2, n);
                    BasicJYSwitchButtonUI.this.getSwitch(jYSwitchButton, true).setFont(font);
                } else if ("offFontSize".equals(string) || "offFontStyle".equals(string)) {
                    int n = jYSwitchButton.getOffFontSize();
                    Integer n3 = jYSwitchButton.getOffFontStyle();
                    Font font = new Font(SyntheticaLookAndFeel.getFontName(), n3 == null ? 0 : n3, n);
                    BasicJYSwitchButtonUI.this.getSwitch(jYSwitchButton, false).setFont(font);
                }
            }
        };
    }

    private JLabel getSwitch(JYSwitchButton jYSwitchButton, boolean bl) {
        Component component = ((BorderLayout)jYSwitchButton.getLayout()).getLayoutComponent("Before");
        OnOffSwitch onOffSwitch = (OnOffSwitch)((Container)component).getComponent(bl ? 0 : 1);
        return (JLabel)onOffSwitch.getComponent(0);
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        this.paintBackground(jComponent, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        super.paint(graphics, jComponent);
    }

    protected void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    protected void paintSwitchBackground(JComponent jComponent, boolean bl, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(bl ? new Color(35020) : new Color(0xCCCCCC));
        graphics.fillRect(n, n2, n3, n4);
    }

    protected void paintSwitch(JComponent jComponent, boolean bl, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.GRAY);
        graphics.fillRect(n, n2, n3, n4);
    }

    private class OnOffSwitch
    extends JPanel {
        private static final long serialVersionUID = -9102350711337593954L;
        private boolean isOnSwitch;

        public OnOffSwitch(boolean bl) {
            this.isOnSwitch = bl;
            this.setLayout(new BorderLayout());
            this.add(this.createLabel(bl));
            this.setOpaque(false);
        }

        private JYSwitchButton getSwitchButton() {
            return (JYSwitchButton)this.getParent().getParent();
        }

        private JLabel createLabel(final boolean bl) {
            JLabel jLabel = new JLabel(" "){
                private static final long serialVersionUID = 4027249822886417331L;

                protected void paintComponent(Graphics graphics) {
                    boolean bl4 = SyntheticaLookAndFeel.getBoolean("JYSwitchButton.switch.dynamicForeground.enabled", OnOffSwitch.this.getSwitchButton(), false);
                    Color color = this.getForeground();
                    if (bl4) {
                        this.setForeground(BasicJYSwitchButtonUI.this.getSwitch(OnOffSwitch.this.getSwitchButton(), bl ? OnOffSwitch.this.getSwitchButton().isSelected() : !OnOffSwitch.this.getSwitchButton().isSelected()).getForeground());
                    }
                    super.paintComponent(graphics);
                    boolean bl2 = OnOffSwitch.this.isOnSwitch;
                    boolean bl3 = OnOffSwitch.this.getSwitchButton().isSelected();
                    if (!(bl2 && bl3 || !bl2 && !bl3)) {
                        BasicJYSwitchButtonUI.this.paintSwitch(OnOffSwitch.this.getSwitchButton(), bl3, graphics, 0, 0, this.getWidth(), this.getHeight());
                    }
                    if (bl4) {
                        this.setForeground(color);
                    }
                }
            };
            jLabel.setHorizontalAlignment(0);
            jLabel.setFocusable(false);
            jLabel.setName(bl ? "JYSwitchButton.OnSwitch" : "JYSwitchButton.OffSwitch");
            return jLabel;
        }

        public Dimension getPreferredSize() {
            JYSwitchButton jYSwitchButton = this.getSwitchButton();
            int n = Math.max(((BasicJYSwitchButtonUI)BasicJYSwitchButtonUI.this).getSwitch((JYSwitchButton)jYSwitchButton, (boolean)true).getPreferredSize().width, ((BasicJYSwitchButtonUI)BasicJYSwitchButtonUI.this).getSwitch((JYSwitchButton)jYSwitchButton, (boolean)false).getPreferredSize().width);
            return new Dimension(n, super.getPreferredSize().height);
        }
    }
}

