/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYFormattedTextField;
import de.javasoft.swing.JYTextField;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.JYTextFieldUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class BasicJYTextFieldUI
extends JYTextFieldUI {
    private JLabel promptLabel;
    private FocusListener focusListener;

    protected String getPropertyPrefix() {
        return this.getComponent() instanceof JYFormattedTextField ? "FormattedTextField" : "TextField";
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJYTextFieldUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installComponents(jComponent);
        this.installDefaults(jComponent);
    }

    protected void installComponents(JComponent jComponent) {
    }

    protected void installDefaults(JComponent jComponent) {
        Object object;
        jComponent.setLayout(new BorderLayout());
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                JYTextField jYTextField = (JYTextField)BasicJYTextFieldUI.this.getComponent();
                if (jYTextField != null && jYTextField.getPromptStrategy() == JYTextField.PromptStrategy.NO_TEXT_AND_NO_FOCUS && jYTextField.getDocument().getLength() == 0) {
                    BasicJYTextFieldUI.this.promptLabel.setText("");
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                JYTextField jYTextField = (JYTextField)BasicJYTextFieldUI.this.getComponent();
                if (jYTextField != null && jYTextField.getPromptStrategy() == JYTextField.PromptStrategy.NO_TEXT_AND_NO_FOCUS && jYTextField.getDocument().getLength() == 0) {
                    BasicJYTextFieldUI.this.promptLabel.setText(jYTextField.getPromptText());
                }
            }
        };
        jComponent.addFocusListener(this.focusListener);
        JPanel jPanel = ((JYTextField)jComponent).getLeadingPanel();
        jComponent.add((Component)jPanel, "Before");
        JPanel jPanel2 = ((JYTextField)jComponent).getTrailingPanel();
        jComponent.add((Component)jPanel2, "After");
        JYTextField jYTextField = (JYTextField)jComponent;
        this.promptLabel = new JLabel();
        this.promptLabel.setFocusable(false);
        jYTextField.add(this.promptLabel);
        if (jYTextField.promptTextIsUIResource()) {
            object = SyntheticaLookAndFeel.getString("JYTextField.promptText", jComponent);
            if (object == null) {
                object = "";
            }
            jYTextField.setPromptText((String)object, true);
        }
        this.promptLabel.setText(jYTextField.getDocument().getLength() == 0 ? jYTextField.getPromptText() : "");
        if (jYTextField.promptForegroundIsUIResource()) {
            object = SyntheticaLookAndFeel.getColor("JYTextField.promptForeground", jComponent, new Color(0xA0A0A0));
            jYTextField.setPromptForeground((Color)object, true);
        } else {
            this.promptLabel.setForeground(jYTextField.getPromptForeground());
        }
        if (jYTextField.promptAlignmentIsUIResource()) {
            jYTextField.setPromptAlignment(SyntheticaLookAndFeel.getInt("JYTextField.promptAlignment", jComponent, 2), true);
        }
        this.promptLabel.setHorizontalAlignment(jYTextField.getPromptAlignment());
        if (jYTextField.promptStrategyIsUIResource()) {
            object = SyntheticaLookAndFeel.getString("JYTextField.promptStrategy", jComponent);
            if (object == null) {
                object = JYTextField.PromptStrategy.NO_TEXT_AND_NO_FOCUS.name();
            }
            jYTextField.setPromptStrategy(JYTextField.PromptStrategy.valueOf((String)object), true);
        }
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.getComponent().removeFocusListener(this.focusListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        JYTextField jYTextField = (JYTextField)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
            this.installDefaults();
            this.installDefaults(jYTextField);
        }
        if ("documentLength".equals(string)) {
            if ((Integer)propertyChangeEvent.getNewValue() == 0) {
                this.promptLabel.setText(jYTextField.getPromptText());
            } else {
                this.promptLabel.setText("");
            }
        } else if ("promptText".equals(string) && jYTextField.getDocument().getLength() == 0) {
            if (jYTextField.getPromptStrategy() != JYTextField.PromptStrategy.NO_TEXT_AND_NO_FOCUS || !jYTextField.hasFocus()) {
                this.promptLabel.setText((String)propertyChangeEvent.getNewValue());
            }
        } else if ("promptForeground".equals(string) && propertyChangeEvent.getNewValue() != null) {
            this.promptLabel.setForeground(new Color(((Color)propertyChangeEvent.getNewValue()).getRGB()));
        } else if ("promptAlignment".equals(string)) {
            this.promptLabel.setHorizontalAlignment((Integer)propertyChangeEvent.getNewValue());
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, (JYTextField)jComponent);
    }

    protected Rectangle getVisibleEditorRect() {
        JTextComponent jTextComponent = this.getComponent();
        Rectangle rectangle = jTextComponent.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = jTextComponent.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            Dimension dimension = ((JYTextField)jTextComponent).getLeadingPanel().getPreferredSize();
            Dimension dimension2 = ((JYTextField)jTextComponent).getTrailingPanel().getPreferredSize();
            rectangle.x = rectangle.x + (jTextComponent.getComponentOrientation().isLeftToRight() ? dimension.width : dimension2.width);
            rectangle.width -= dimension.width + dimension2.width;
            return rectangle;
        }
        return null;
    }

    protected void paint(Graphics graphics, JYTextField jYTextField) {
        super.paint(graphics, jYTextField);
    }
}

