/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jysearchfield;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.JYButtonIcon;
import de.javasoft.swing.JYSearchField;
import de.javasoft.swing.SimpleDropDownButton;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.jysearchfield.IButtonFactory;
import de.javasoft.swing.plaf.jysearchfield.SearchActionEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;

public class ButtonFactory
implements IButtonFactory,
SwingConstants {
    public AbstractButton createSearchButton(final JYSearchField jYSearchField, Action action) {
        JButton jButton = new JButton(action){
            private static final long serialVersionUID = 2285809691111940943L;

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            public boolean isEnabled() {
                return jYSearchField.isEnabled();
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setSearchButtonDefaults(this, jYSearchField);
            }

            protected void fireActionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    SearchActionEvent searchActionEvent = new SearchActionEvent(jYSearchField, 1001, actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers(), SearchActionEvent.Initiator.SEARCH_BUTTON);
                    if (objectArray[n] == ActionListener.class) {
                        ((ActionListener)objectArray[n + 1]).actionPerformed(searchActionEvent);
                    }
                    n -= 2;
                }
            }
        };
        jButton.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = -777014533975461232L;

            public boolean isEnabled() {
                return jYSearchField.isEnabled();
            }
        });
        if (action != null && action.getValue("ShortDescription") == null) {
            action.putValue("ShortDescription", UIManager.get("JYSearchField.searchButton.toolTip"));
        }
        if (jYSearchField.getShowSearchButton() != null) {
            jButton.setVisible(jYSearchField.getShowSearchButton());
        }
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setContentAreaFilled(false);
        jButton.setFocusable(false);
        jButton.setCursor(Cursor.getDefaultCursor());
        jButton.setName("JYSearchField.SearchButton");
        this.setSearchButtonDefaults(jButton, jYSearchField);
        return jButton;
    }

    private void setSearchButtonDefaults(AbstractButton abstractButton, JYSearchField jYSearchField) {
        if (abstractButton.getAction() != null && abstractButton.getAction().getValue("SmallIcon") != null) {
            abstractButton.setIcon((Icon)abstractButton.getAction().getValue("SmallIcon"));
        } else {
            abstractButton.setIcon(this.createSearchIcon(abstractButton, jYSearchField));
        }
        Insets insets = SyntheticaLookAndFeel.getInsets("JYSearchField.searchButton.insets", (Component)abstractButton, new Insets(0, 1, 0, 4));
        abstractButton.setBorder(new ButtonBorder(jYSearchField, insets));
    }

    protected Icon createSearchIcon(AbstractButton abstractButton, JYSearchField jYSearchField) {
        return new JYButtonIcon(abstractButton, "JYSearchField.searchButton.icon", 14, 14){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(ButtonFactory.this.getSearchPaintColor(syntheticaState));
                Ellipse2D.Float float_ = new Ellipse2D.Float(4.0f, 1.0f, 8.0f, 8.0f);
                graphics2D.setPaint(ButtonFactory.this.getSearchPaintColor(syntheticaState));
                graphics2D.draw(float_);
                graphics2D.setStroke(new BasicStroke(1.0f));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(0.0f, 13.0f);
                generalPath.lineTo(4.0f, 9.0f);
                graphics2D.draw(generalPath);
                graphics2D.draw(generalPath);
            }

            protected BasicStroke createStroke(SynthContext synthContext) {
                return new BasicStroke(1.2f);
            }
        };
    }

    public AbstractButton createSearchPopupButton(final JYSearchField jYSearchField, Action action) {
        SimpleDropDownButton simpleDropDownButton = new SimpleDropDownButton(action){
            private static final long serialVersionUID = -588740562435809693L;

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            public boolean isEnabled() {
                return jYSearchField.isEnabled();
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setSearchPopupButtonDefaults(this, jYSearchField);
            }

            protected void fireActionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    SearchActionEvent searchActionEvent = new SearchActionEvent(jYSearchField, 1001, actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers(), SearchActionEvent.Initiator.SEARCH_POPUP_BUTTON);
                    if (objectArray[n] == ActionListener.class) {
                        ((ActionListener)objectArray[n + 1]).actionPerformed(searchActionEvent);
                    }
                    n -= 2;
                }
            }
        };
        simpleDropDownButton.setPopupMenu(jYSearchField.getSearchPopupMenu());
        simpleDropDownButton.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = -8516576038545240736L;

            public boolean isEnabled() {
                return jYSearchField.isEnabled();
            }
        });
        if (action != null && action.getValue("ShortDescription") == null) {
            action.putValue("ShortDescription", UIManager.get("JYSearchField.searchButton.toolTip"));
        }
        if (jYSearchField.getShowSearchButton() != null) {
            simpleDropDownButton.setVisible(jYSearchField.getShowSearchButton());
        }
        simpleDropDownButton.setArrowVisible(false);
        simpleDropDownButton.setMargin(new Insets(0, 0, 0, 0));
        simpleDropDownButton.setBorderPainted(false);
        simpleDropDownButton.setContentAreaFilled(false);
        simpleDropDownButton.setFocusable(false);
        simpleDropDownButton.setCursor(Cursor.getDefaultCursor());
        simpleDropDownButton.setName("JYSearchField.SearchButton");
        this.setSearchPopupButtonDefaults(simpleDropDownButton, jYSearchField);
        return simpleDropDownButton;
    }

    private void setSearchPopupButtonDefaults(AbstractButton abstractButton, JYSearchField jYSearchField) {
        if (abstractButton.getAction() != null && abstractButton.getAction().getValue("SmallIcon") != null) {
            abstractButton.setIcon((Icon)abstractButton.getAction().getValue("SmallIcon"));
        } else {
            abstractButton.setIcon(this.createPopupIcon(abstractButton, jYSearchField));
        }
        Insets insets = SyntheticaLookAndFeel.getInsets("JYSearchField.searchPopupButton.insets", (Component)abstractButton, new Insets(0, 1, 0, 4));
        abstractButton.setBorder(new ButtonBorder(jYSearchField, insets));
    }

    protected Icon createPopupIcon(AbstractButton abstractButton, JYSearchField jYSearchField) {
        return new JYButtonIcon(abstractButton, "JYSearchField.searchPopupButton.icon", 14, 14){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(ButtonFactory.this.getSearchPaintColor(syntheticaState));
                Ellipse2D.Float float_ = new Ellipse2D.Float(4.0f, 1.0f, 8.0f, 8.0f);
                graphics2D.setPaint(ButtonFactory.this.getSearchPaintColor(syntheticaState));
                graphics2D.draw(float_);
                graphics2D.setStroke(new BasicStroke(1.0f));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(0.0f, 13.0f);
                generalPath.lineTo(4.0f, 9.0f);
                graphics2D.draw(generalPath);
                graphics2D.draw(generalPath);
                generalPath = new GeneralPath();
                generalPath.moveTo(f3 - 4.5f, f4 - 1.1f);
                generalPath.lineTo(f3 - 1.5f, f4 - 1.1f);
                generalPath.lineTo(f3 - 3.0f, f4);
                generalPath.closePath();
                graphics2D.draw(generalPath);
            }

            protected BasicStroke createStroke(SynthContext synthContext) {
                return new BasicStroke(1.2f);
            }
        };
    }

    public AbstractButton createDeleteButton(final JYSearchField jYSearchField, Action action) {
        JButton jButton = new JButton(action){
            private static final long serialVersionUID = -1350228247067269391L;

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            public boolean isEnabled() {
                return jYSearchField.isEnabled() && jYSearchField.isEditable();
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setDeleteButtonDefaults(this, jYSearchField);
            }
        };
        jButton.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = -8516576038545240736L;

            public boolean isEnabled() {
                return jYSearchField.isEnabled() && jYSearchField.isEditable();
            }
        });
        action.putValue("ShortDescription", UIManager.get("JYSearchField.deleteButton.toolTip"));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setContentAreaFilled(false);
        jButton.setVisible(jYSearchField.getDocument().getLength() > 0);
        jButton.setFocusable(false);
        jButton.setCursor(Cursor.getDefaultCursor());
        jButton.setName("JYSearchField.DeleteButton");
        this.setDeleteButtonDefaults(jButton, jYSearchField);
        return jButton;
    }

    private void setDeleteButtonDefaults(AbstractButton abstractButton, JYSearchField jYSearchField) {
        abstractButton.setIcon(this.createDeleteIcon(abstractButton, jYSearchField));
        Insets insets = SyntheticaLookAndFeel.getInsets("JYSearchField.deleteButton.insets", (Component)abstractButton, new Insets(0, 2, 0, 0));
        abstractButton.setBorder(new ButtonBorder(jYSearchField, insets));
    }

    protected Icon createDeleteIcon(AbstractButton abstractButton, JYSearchField jYSearchField) {
        return new JYButtonIcon(abstractButton, "JYSearchField.deleteButton.icon", 10, 10){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(ButtonFactory.this.getDeletePaintColor(syntheticaState));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(2.0f, 2.0f);
                generalPath.lineTo(7.0f, 7.0f);
                generalPath.moveTo(7.0f, 2.0f);
                generalPath.lineTo(2.0f, 7.0f);
                graphics2D.draw(generalPath);
            }
        };
    }

    private Color getDeletePaintColor(SyntheticaState syntheticaState) {
        Color color = null;
        color = syntheticaState.isSet(SyntheticaState.State.DISABLED) || syntheticaState.isSet(SyntheticaState.State.LOCKED) ? new Color(0xA0A0A0) : (syntheticaState.isSet(SyntheticaState.State.PRESSED) ? new Color(0x606060) : (syntheticaState.isSet(SyntheticaState.State.HOVER) ? new Color(0xE70000) : new Color(0)));
        return color;
    }

    private Color getSearchPaintColor(SyntheticaState syntheticaState) {
        Color color = null;
        color = syntheticaState.isSet(SyntheticaState.State.DISABLED) ? new Color(0xA0A0A0) : (syntheticaState.isSet(SyntheticaState.State.PRESSED) ? new Color(0x555555) : (syntheticaState.isSet(SyntheticaState.State.HOVER) ? new Color(0x808080) : new Color(0x222222)));
        return color;
    }

    private static class ButtonBorder
    extends WidgetUtils.OrientationAwareEmptyBorderUIResource {
        private static final long serialVersionUID = -4886609230446983952L;
        private JYSearchField searchField;

        public ButtonBorder(JYSearchField jYSearchField, Insets insets) {
            super(insets);
            this.searchField = jYSearchField;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = super.getBorderInsets(component, insets);
            if (this.searchField.getSearchControlsPosition() == JYSearchField.SearchControlsPosition.CLEAR_LEADING_SEARCH_TRAILING) {
                int n = insets2.left;
                insets2.left = insets2.right;
                insets2.right = n;
            }
            return insets2;
        }
    }
}

