/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jytabbedpane;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.JYButton;
import de.javasoft.swing.JYButtonIcon;
import de.javasoft.swing.JYPopupMenu;
import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.SimpleDropDownButton;
import de.javasoft.swing.plaf.basic.BasicJYTabbedPaneUI;
import de.javasoft.swing.plaf.jytabbedpane.IButtonFactory;
import de.javasoft.swing.plaf.jytabbedpane.Tab;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.SynthContext;

public class ButtonFactory
implements IButtonFactory,
SwingConstants {
    private Icon scrollIconLeft;
    private Icon scrollIconRight;
    private Icon scrollIconUp;
    private Icon scrollIconDown;
    private Icon plusIcon;

    public JButton createCloseTabButton(final JYTabbedPane jYTabbedPane, final Tab tab, Action action) {
        JYButton jYButton = new JYButton(action){
            private static final long serialVersionUID = 8203468458830011176L;

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            public boolean isEnabled() {
                return tab.isEnabled();
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setCloseTabButtonDefaults(this, jYTabbedPane, tab);
            }
        };
        jYButton.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = 8214819089269580673L;

            public boolean isEnabled() {
                return tab.isEnabled();
            }

            public boolean isSelected() {
                return tab.isSelected();
            }
        });
        jYButton.setRotation(((BasicJYTabbedPaneUI)jYTabbedPane.getUI()).placementToRotation(jYTabbedPane.getTabPlacement()));
        jYButton.setMargin(new Insets(0, 0, 0, 0));
        jYButton.setContentAreaFilled(false);
        jYButton.setVisible(false);
        jYButton.setFocusable(false);
        jYButton.setName("JYTabbedPane.CloseButton");
        String string = (String)jYTabbedPane.getClientProperty("Synthetica.style");
        jYButton.putClientProperty("Synthetica.style", string == null ? jYTabbedPane.getName() : string);
        this.setCloseTabButtonDefaults(jYButton, jYTabbedPane, tab);
        return jYButton;
    }

    protected void setCloseTabButtonDefaults(AbstractButton abstractButton, JYTabbedPane jYTabbedPane, Tab tab) {
        abstractButton.setToolTipText(UIManager.getString("JYTabbedPane.closeButton.toolTip"));
        abstractButton.setIcon(this.createCloseIcon(abstractButton, jYTabbedPane, tab));
        Insets insets = SyntheticaLookAndFeel.getInsets("JYTabbedPane.tab.closeButton.insets", (Component)abstractButton, false);
        abstractButton.setBorder(new EmptyBorder(insets));
    }

    private Icon createCloseIcon(AbstractButton abstractButton, final JYTabbedPane jYTabbedPane, final Tab tab) {
        return new JYButtonIcon(abstractButton, "JYTabbedPane.tab.closeButton.icon", 10, 10){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                if (!jYTabbedPane.isEnabledAt(tab.getTabIndex())) {
                    graphics2D.setPaint(new Color(0xA0A0A0));
                } else if (syntheticaState.isSet(SyntheticaState.State.PRESSED)) {
                    graphics2D.setPaint(new Color(0x606060));
                } else if (syntheticaState.isSet(SyntheticaState.State.HOVER)) {
                    graphics2D.setPaint(new Color(0xE70000));
                } else {
                    graphics2D.setPaint(new Color(0));
                }
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(3.0f, 2.0f);
                generalPath.lineTo(8.0f, 7.0f);
                generalPath.moveTo(8.0f, 2.0f);
                generalPath.lineTo(3.0f, 7.0f);
                graphics2D.draw(generalPath);
            }

            public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
                int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
                n4 = 31 * n4 + (jYTabbedPane.isEnabledAt(tab.getTabIndex()) ? 0 : 1);
                return n4;
            }
        };
    }

    public SimpleDropDownButton createPopupButton(final JYTabbedPane jYTabbedPane) {
        SimpleDropDownButton simpleDropDownButton = new SimpleDropDownButton(){
            private static final long serialVersionUID = 1437991807270111435L;

            public float getAlignmentX() {
                return ((BasicJYTabbedPaneUI)jYTabbedPane.getUI()).getTabControlsAlignment(true);
            }

            public float getAlignmentY() {
                return ((BasicJYTabbedPaneUI)jYTabbedPane.getUI()).getTabControlsAlignment(false);
            }

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            protected JPopupMenu createPopupMenu() {
                JYPopupMenu jYPopupMenu = new JYPopupMenu();
                jYPopupMenu.setName("JYTabbedPane.PopupMenu");
                return jYPopupMenu;
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setPopupButtonDefaults(this, jYTabbedPane);
            }
        };
        simpleDropDownButton.setArrowVisible(false);
        simpleDropDownButton.setMargin(new Insets(0, 0, 0, 0));
        simpleDropDownButton.setBorderPainted(false);
        simpleDropDownButton.setContentAreaFilled(false);
        simpleDropDownButton.setFocusable(false);
        simpleDropDownButton.setName("JYTabbedPane.PopupButton");
        this.setPopupButtonDefaults(simpleDropDownButton, jYTabbedPane);
        return simpleDropDownButton;
    }

    protected void setPopupButtonDefaults(AbstractButton abstractButton, JYTabbedPane jYTabbedPane) {
        abstractButton.setToolTipText(UIManager.getString("JYTabbedPane.popupButton.toolTip"));
        abstractButton.setIcon(this.createPopupIcon(abstractButton, jYTabbedPane));
        Insets insets = SyntheticaLookAndFeel.getInsets("JYTabbedPane.popupButton.insets", (Component)abstractButton, new Insets(4, 4, 4, 4));
        abstractButton.setBorder(new EmptyBorder(insets));
    }

    private Icon createPopupIcon(AbstractButton abstractButton, final JYTabbedPane jYTabbedPane) {
        return new JYButtonIcon(abstractButton, "JYTabbedPane.popupButton.icon", 12, 12){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(ButtonFactory.this.getPaintColor(syntheticaState));
                boolean bl = jYTabbedPane.getComponentOrientation().isLeftToRight();
                GeneralPath generalPath = new GeneralPath();
                if (bl) {
                    generalPath.moveTo(0.0f, 1.0f);
                    generalPath.lineTo(3.0f, 3.0f);
                    generalPath.lineTo(0.0f, 5.0f);
                    generalPath.moveTo(4.0f, 1.0f);
                    generalPath.lineTo(7.0f, 3.0f);
                    generalPath.lineTo(4.0f, 5.0f);
                } else {
                    generalPath.moveTo(11.0f, 1.0f);
                    generalPath.lineTo(8.0f, 3.0f);
                    generalPath.lineTo(11.0f, 5.0f);
                    generalPath.moveTo(7.0f, 1.0f);
                    generalPath.lineTo(4.0f, 3.0f);
                    generalPath.lineTo(7.0f, 5.0f);
                }
                graphics2D.draw(generalPath);
            }

            public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
                int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
                n4 = 31 * n4 + (jYTabbedPane.getComponentOrientation().isLeftToRight() ? 0 : 1);
                return n4;
            }
        };
    }

    public JButton createScrollForwardButton(JYTabbedPane jYTabbedPane, Action action) {
        return this.createScrollButton(jYTabbedPane, action, true);
    }

    public JButton createScrollBackwardButton(JYTabbedPane jYTabbedPane, Action action) {
        return this.createScrollButton(jYTabbedPane, action, false);
    }

    private JButton createScrollButton(final JYTabbedPane jYTabbedPane, Action action, final boolean bl) {
        JButton jButton = new JButton(action){
            private static final long serialVersionUID = 6140418110240325555L;

            public float getAlignmentX() {
                return ((BasicJYTabbedPaneUI)jYTabbedPane.getUI()).getTabControlsAlignment(true);
            }

            public float getAlignmentY() {
                return ((BasicJYTabbedPaneUI)jYTabbedPane.getUI()).getTabControlsAlignment(false);
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            public Icon getIcon() {
                boolean bl2 = jYTabbedPane.getComponentOrientation().isLeftToRight();
                int n = jYTabbedPane.getTabPlacement();
                if (n == 1 || n == 3) {
                    if (bl2 && bl || !bl2 && !bl) {
                        return ButtonFactory.this.scrollIconRight;
                    }
                    return ButtonFactory.this.scrollIconLeft;
                }
                return bl ? ButtonFactory.this.scrollIconDown : ButtonFactory.this.scrollIconUp;
            }

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setScrollButtonDefaults(this, jYTabbedPane, bl);
            }
        };
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusable(false);
        if (bl) {
            jButton.setName("JYTabbedPane.ScrollForwardButton");
        } else {
            jButton.setName("JYTabbedPane.ScrollBackwardButton");
        }
        this.setScrollButtonDefaults(jButton, jYTabbedPane, bl);
        return jButton;
    }

    protected void setScrollButtonDefaults(AbstractButton abstractButton, JYTabbedPane jYTabbedPane, boolean bl) {
        Insets insets = SyntheticaLookAndFeel.getInsets("JYTabbedPane.scrollButton.insets", (Component)abstractButton, new Insets(4, 4, 4, 4));
        abstractButton.setBorder(new EmptyBorder(insets));
        if (bl) {
            abstractButton.setToolTipText(UIManager.getString("JYTabbedPane.scrollButton.forward.toolTip"));
            this.scrollIconRight = this.getScrollIcon(abstractButton, jYTabbedPane, "right");
            this.scrollIconDown = this.getScrollIcon(abstractButton, jYTabbedPane, "down");
        } else {
            abstractButton.setToolTipText(UIManager.getString("JYTabbedPane.scrollButton.backward.toolTip"));
            this.scrollIconLeft = this.getScrollIcon(abstractButton, jYTabbedPane, "left");
            this.scrollIconUp = this.getScrollIcon(abstractButton, jYTabbedPane, "up");
        }
    }

    protected Icon getScrollIcon(AbstractButton abstractButton, final JYTabbedPane jYTabbedPane, String string) {
        String string2 = "JYTabbedPane.scrollButton.icon." + string;
        return new JYButtonIcon(abstractButton, string2, 12, 12){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(ButtonFactory.this.getPaintColor(syntheticaState));
                GeneralPath generalPath = new GeneralPath();
                String string = this.getUIKey().split("\\.")[3];
                if (string.equals("left")) {
                    generalPath.moveTo(9.0f, 2.0f);
                    generalPath.lineTo(2.0f, 5.5f);
                    generalPath.lineTo(9.0f, 9.0f);
                } else if (string.equals("right")) {
                    generalPath.moveTo(2.0f, 2.0f);
                    generalPath.lineTo(9.0f, 5.5f);
                    generalPath.lineTo(2.0f, 9.0f);
                } else if (string.equals("up")) {
                    generalPath.moveTo(2.0f, 9.0f);
                    generalPath.lineTo(5.5f, 2.0f);
                    generalPath.lineTo(9.0f, 9.0f);
                } else if (string.equals("down")) {
                    generalPath.moveTo(2.0f, 2.0f);
                    generalPath.lineTo(5.5f, 9.0f);
                    generalPath.lineTo(9.0f, 2.0f);
                }
                graphics2D.fill(generalPath);
            }

            public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
                int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
                n4 = 31 * n4 + jYTabbedPane.getTabPlacement();
                n4 = 31 * n4 + (jYTabbedPane.getComponentOrientation().isLeftToRight() ? 0 : 1);
                return n4;
            }
        };
    }

    public JButton createPlusButton(final JYTabbedPane jYTabbedPane, Action action) {
        JYButton jYButton = new JYButton(action){
            private static final long serialVersionUID = -8491794353997273950L;

            public String getToolTipText(MouseEvent mouseEvent) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            public Icon getIcon() {
                return ButtonFactory.this.plusIcon;
            }

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setPlusButtonDefaults(this, jYTabbedPane);
            }
        };
        jYButton.setMargin(new Insets(0, 0, 0, 0));
        jYButton.setFocusable(false);
        jYButton.setName("JYTabbedPane.PlusButton");
        this.setPlusButtonDefaults(jYButton, jYTabbedPane);
        return jYButton;
    }

    protected void setPlusButtonDefaults(AbstractButton abstractButton, JYTabbedPane jYTabbedPane) {
        Insets insets = SyntheticaLookAndFeel.getInsets("JYTabbedPane.plusButton.insets", (Component)abstractButton, new Insets(4, 4, 4, 4));
        abstractButton.setBorder(new EmptyBorder(insets));
        this.plusIcon = this.createPlusIcon(abstractButton, jYTabbedPane);
    }

    private Icon createPlusIcon(AbstractButton abstractButton, final JYTabbedPane jYTabbedPane) {
        String string = "JYTabbedPane.plusButton.icon";
        return new JYButtonIcon(abstractButton, string, 12, 12){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                syntheticaState.resetState(SyntheticaState.State.HOVER);
                graphics2D.setPaint(ButtonFactory.this.getPaintColor(syntheticaState));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(5.5, 2.0);
                generalPath.lineTo(5.5, 9.0);
                generalPath.moveTo(2.0, 5.5);
                generalPath.lineTo(9.0, 5.5);
                graphics2D.draw(generalPath);
            }

            protected BasicStroke createStroke(SynthContext synthContext) {
                return new BasicStroke(1.2f);
            }

            public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
                int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
                n4 = 31 * n4 + jYTabbedPane.getTabPlacement();
                n4 = 31 * n4 + (jYTabbedPane.getComponentOrientation().isLeftToRight() ? 0 : 1);
                return n4;
            }
        };
    }

    private Color getPaintColor(SyntheticaState syntheticaState) {
        Color color = Color.BLACK;
        if (syntheticaState.isSet(SyntheticaState.State.DISABLED)) {
            color = new Color(0xAAAAAA);
        } else if (!syntheticaState.isSet(SyntheticaState.State.PRESSED) && syntheticaState.isSet(SyntheticaState.State.HOVER)) {
            color = new Color(0x606060);
        }
        return color;
    }
}

