/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jytabbedpane;

import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.plaf.basic.BasicJYTabbedPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;

public class JYTabbedPaneLayout
extends BorderLayout
implements SwingConstants {
    private static final long serialVersionUID = 7748703031702632025L;
    private JTabbedPane tabPane;
    private BasicJYTabbedPaneUI ui;

    public JYTabbedPaneLayout(JTabbedPane jTabbedPane, BasicJYTabbedPaneUI basicJYTabbedPaneUI) {
        this.ui = basicJYTabbedPaneUI;
        this.tabPane = jTabbedPane;
    }

    public void addLayoutComponent(Component component, Object object) {
        super.addLayoutComponent(component, object);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateSize(false);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateSize(true);
    }

    protected Dimension calculateSize(boolean bl) {
        int n = this.tabPane.getTabPlacement();
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.ui.getContentBorderInsets(n);
        Insets insets3 = this.ui.getTabAreaInsets(n);
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.tabPane.getTabCount()) {
            Component component = this.tabPane.getComponentAt(n6);
            if (component != null) {
                Dimension dimension2 = dimension;
                Dimension dimension3 = dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension2 != null) {
                    n5 = Math.max(dimension2.height, n5);
                    n4 = Math.max(dimension2.width, n4);
                }
            }
            ++n6;
        }
        n3 += n4;
        n2 += n5;
        n6 = 0;
        switch (n) {
            case 2: 
            case 4: {
                n2 = Math.max(n2, this.ui.calculateMaxTabHeight(n));
                n6 = this.preferredTabAreaWidth(n, n2 - insets3.top - insets3.bottom);
                n3 += n6;
                break;
            }
            default: {
                n3 = Math.max(n3, this.ui.calculateMaxTabWidth(n));
                n6 = this.preferredTabAreaHeight(n, n3 - insets3.left - insets3.right);
                n2 += n6;
            }
        }
        return new Dimension(n3 + insets.left + insets.right + insets2.left + insets2.right, n2 + insets.bottom + insets.top + insets2.top + insets2.bottom);
    }

    protected int preferredTabAreaHeight(int n, int n2) {
        return this.ui.calculateMaxTabHeight(n);
    }

    protected int preferredTabAreaWidth(int n, int n2) {
        return this.ui.calculateMaxTabWidth(n);
    }

    private void updateControlsPanelVisibility() {
        int n;
        BasicJYTabbedPaneUI.TabsPanel tabsPanel = this.ui.getTabsPanel();
        BasicJYTabbedPaneUI.TabsPanelViewport tabsPanelViewport = this.ui.getTabsPanelViewport();
        JPanel jPanel = this.ui.getLeadingTabControlsPanel();
        JPanel jPanel2 = this.ui.getTrailingTabControlsPanel();
        int n2 = jPanel.getWidth() + jPanel2.getWidth();
        int n3 = jPanel.getHeight() + jPanel2.getHeight();
        boolean bl = jPanel.isVisible() | jPanel2.isVisible();
        boolean bl2 = this.tabPane.getTabPlacement() == 2 || this.tabPane.getTabPlacement() == 4;
        int n4 = n = bl2 ? tabsPanel.getPreferredSize().height : tabsPanel.getPreferredSize().width;
        int n5 = bl2 ? tabsPanelViewport.getSize().height + (bl ? n3 : 0) : tabsPanelViewport.getSize().width + (bl ? n2 : 0);
        boolean bl3 = n5 < n;
        switch (((JYTabbedPane)this.tabPane).getTabControlsShowStrategy()) {
            case ALWAYS: {
                bl3 = true;
                break;
            }
            case NEVER: {
                bl3 = false;
            }
        }
        jPanel.setVisible(bl3);
        jPanel2.setVisible(bl3);
    }

    public void layoutContainer(Container container) {
        this.ui.updateTabCloseButtons();
        this.ui.updateTabFontStyle();
        BasicJYTabbedPaneUI.TabsPanel tabsPanel = this.ui.getTabsPanel();
        this.updateControlsPanelVisibility();
        int n = this.tabPane.getSelectedIndex();
        if (n >= 0) {
            Component component = this.tabPane.getComponentAt(n);
            Component[] componentArray = ((JYTabbedPane)this.tabPane).getContentPanel().getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Component component2 = componentArray[n3];
                if (component == component2 && !component2.isVisible()) {
                    component2.setVisible(true);
                } else if (component != component2 && component2.isVisible()) {
                    component2.setVisible(false);
                }
                ++n3;
            }
        }
        super.layoutContainer(container);
        tabsPanel.updateTabRects();
    }
}

