/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jytabbedpane;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.JYTabbedPanePainter;
import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.plaf.basic.BasicJYTabbedPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;

public class Tab
extends JPanel
implements SwingConstants {
    private static final long serialVersionUID = 5244598924076258816L;
    private BasicJYTabbedPaneUI ui;
    private BasicJYTabbedPaneUI.TabsPanel tabsPanel;
    private JPanel tabContentPanel;
    private JButton closeButton;
    private static FocusListener repaintFocusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            ((Tab)focusEvent.getSource()).repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            ((Tab)focusEvent.getSource()).repaint();
        }
    };

    public Tab(JYTabbedPane jYTabbedPane, JComponent jComponent) {
        this.ui = (BasicJYTabbedPaneUI)jYTabbedPane.getUI();
        this.tabsPanel = this.ui.getTabsPanel();
        this.setOpaque(false);
        this.setName("JYTabbedPane.Tab");
        this.setLayout(new OverlayLayout(this));
        this.tabContentPanel = new JPanel(new BorderLayout());
        this.tabContentPanel.setName("JYTabbedPane.TabContentPanel");
        this.tabContentPanel.setOpaque(false);
        this.closeButton = this.createCloseButton();
        int n = jYTabbedPane.getTabPlacement();
        if (!jYTabbedPane.getTabRotationEnabled().booleanValue()) {
            n = 1;
        }
        if (SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tab.reversedCloseButtonPlacement", jYTabbedPane, false)) {
            this.tabContentPanel.add((Component)this.closeButton, n == 1 || n == 3 ? "Before" : (n == 2 ? "Last" : "First"));
        } else {
            this.tabContentPanel.add((Component)this.closeButton, n == 1 || n == 3 ? "After" : (n == 2 ? "First" : "Last"));
        }
        super.add(this.tabContentPanel);
        if (jComponent != null) {
            this.setComponent(jComponent);
        }
        this.applyComponentOrientation(jYTabbedPane.getComponentOrientation());
        String string = "selectNextTab";
        this.getActionMap().put(string, new SelectNextTabAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), string);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), string);
        String string2 = "selectPreviousTab";
        this.getActionMap().put(string2, new SelectPreviousTabAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), string2);
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), string2);
        this.addFocusListener(repaintFocusListener);
    }

    JPanel getContentPanel() {
        return this.tabContentPanel;
    }

    private JYTabbedPane getTabbedPane() {
        return this.ui.getTabbedPane();
    }

    private JButton createCloseButton() {
        Action action = this.getTabbedPane().getActionMap().get("closeTab");
        JButton jButton = this.ui.getButtonFactory().createCloseTabButton(this.getTabbedPane(), this, action);
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JYTabbedPane jYTabbedPane = Tab.this.getTabbedPane();
                Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), jYTabbedPane);
                MouseEvent mouseEvent2 = new MouseEvent(jYTabbedPane, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                Tab.this.getTabbedPane().dispatchEvent(mouseEvent2);
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        return jButton;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getTabIndex();
        if (n5 < 0) {
            return;
        }
        JYTabbedPane jYTabbedPane = this.getTabbedPane();
        super.setBounds(n, n2, n3, n4);
        this.ui.assureRectsCreated(this.tabsPanel.getTabCount());
        Rectangle rectangle = SwingUtilities.convertRectangle(this.tabsPanel, this.getBounds(), jYTabbedPane);
        this.tabsPanel.setTabRect(n5, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getTabIndex() {
        int n = -1;
        if (this.getParent() == null) {
            return n;
        }
        return ((BasicJYTabbedPaneUI.TabsPanel)this.getParent()).getTabIndex(this);
    }

    public boolean isSelected() {
        return this.getTabbedPane().getSelectedIndex() == this.getTabIndex();
    }

    public boolean isEnabled() {
        JYTabbedPane jYTabbedPane = this.getTabbedPane();
        int n = this.getTabIndex();
        return n >= 0 && n < jYTabbedPane.getTabCount() ? jYTabbedPane.isEnabledAt(n) : super.isEnabled();
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JComponent getComponent() {
        return (JComponent)((BorderLayout)this.tabContentPanel.getLayout()).getLayoutComponent("Center");
    }

    public void setComponent(JComponent jComponent) {
        JComponent jComponent2 = this.getComponent();
        if (jComponent2 != null) {
            this.tabContentPanel.remove(jComponent2);
        }
        this.tabContentPanel.add((Component)jComponent, "Center");
    }

    public float getAlignmentX() {
        JYTabbedPane jYTabbedPane = this.getTabbedPane();
        int n = jYTabbedPane.getTabPlacement();
        boolean bl = jYTabbedPane.getComponentOrientation().isLeftToRight();
        return n == 2 && bl || n == 4 && !bl ? 1.0f : 0.0f;
    }

    public float getAlignmentY() {
        return this.getTabbedPane().getTabPlacement() == 1 ? 1.0f : 0.0f;
    }

    public Component add(Component component) {
        throw new UnsupportedOperationException("Use Tab.setComponent(JComponent c)");
    }

    public Component add(Component component, int n) {
        throw new UnsupportedOperationException("Use Tab.setComponent(JComponent c)");
    }

    public void add(Component component, Object object) {
        throw new UnsupportedOperationException("Use Tab.setComponent(JComponent c)");
    }

    public void add(Component component, Object object, int n) {
        throw new UnsupportedOperationException("Use Tab.setComponent(JComponent c)");
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        JYTabbedPane jYTabbedPane = this.getTabbedPane();
        boolean bl = jYTabbedPane.getTabPlacement() == 1 || jYTabbedPane.getTabPlacement() == 3;
        int n = jYTabbedPane.getMinimumTabSize();
        int n2 = jYTabbedPane.getMaximumTabSize();
        if (bl && n > 0 && dimension.width < n) {
            dimension.width = n;
        } else if (!bl && n > 0 && dimension.height < n) {
            dimension.height = n;
        }
        if (bl && n2 > 0 && dimension.width > n2) {
            dimension.width = n2;
        } else if (!bl && n2 > 0 && dimension.height > n2) {
            dimension.height = n2;
        }
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        int n = this.getTabbedPane().getTabPlacement();
        if (n == 1 || n == 3) {
            for (Component component : this.tabsPanel.getTabs()) {
                dimension.height = Math.max(dimension.height, component.getPreferredSize().height);
            }
            if (this.getTabbedPane().getTabsStretchedEnabled().booleanValue()) {
                dimension.width = 0x1FFFFFFF;
            }
        } else {
            for (Component component : this.tabsPanel.getTabs()) {
                dimension.width = Math.max(dimension.width, component.getPreferredSize().width);
            }
            if (this.getTabbedPane().getTabsStretchedEnabled().booleanValue()) {
                dimension.height = 0x1FFFFFFF;
            }
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(Graphics graphics) {
        Integer n;
        super.paintComponent(graphics);
        JYTabbedPane jYTabbedPane = this.getTabbedPane();
        boolean bl = jYTabbedPane.getComponentOrientation().isLeftToRight();
        int n2 = jYTabbedPane.getTabPlacement();
        if (this.ui.isVerticalTabPlacement() && !bl) {
            n2 = n2 == 2 ? 4 : 2;
        }
        int n3 = -1;
        if (this.tabsPanel.getFirstTab() == this && this.tabsPanel.getLastTab() == this) {
            n3 = n2 == 1 || n2 == 3 ? 2 : 5;
        } else if (this.tabsPanel.getFirstTab() == this) {
            n3 = n2 == 1 || n2 == 3 ? (bl ? 0 : 1) : 3;
        } else if (this.tabsPanel.getLastTab() == this) {
            n3 = n2 == 1 || n2 == 3 ? (bl ? 1 : 0) : 4;
        }
        int n4 = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.styleIsRotated", jYTabbedPane) ? 0 : this.ui.placementToRotation(this, n2).toAngle();
        int n5 = n4 == 0 ? this.getWidth() : this.getHeight();
        int n6 = n4 == 0 ? this.getHeight() : this.getWidth();
        int n7 = this.getTabIndex();
        SyntheticaState syntheticaState = new SyntheticaState();
        if (!jYTabbedPane.isEnabledAt(n7)) {
            syntheticaState.setState(SyntheticaState.State.DISABLED);
        }
        if (n7 == jYTabbedPane.getSelectedIndex()) {
            syntheticaState.setState(SyntheticaState.State.SELECTED);
        }
        if ((n = (Integer)jYTabbedPane.getClientProperty("Synthetica.MOUSE_OVER")) != null && n7 == n) {
            syntheticaState.setState(SyntheticaState.State.HOVER);
        }
        if (this.hasFocus()) {
            syntheticaState.setState(SyntheticaState.State.FOCUSED);
        }
        int n8 = n2 == 3 ? 3 : (jYTabbedPane.getTabRotationEnabled() != false ? 1 : n2);
        jYTabbedPane.putClientProperty("JTabbedPane.focusPlacement", n8);
        if ((jYTabbedPane.getTabStyle() != JYTabbedPane.TabStyle.SELECTED_TAB_ONLY || syntheticaState.isSet(SyntheticaState.State.SELECTED)) && (jYTabbedPane.getTabStyle() != JYTabbedPane.TabStyle.TABS_ON_HOVER || syntheticaState.isSet(SyntheticaState.State.SELECTED) || syntheticaState.isSet(SyntheticaState.State.HOVER))) {
            SynthContext synthContext = null;
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                synthContext = new SynthContext(jYTabbedPane, Region.TABBED_PANE, SynthLookAndFeel.getStyle(jYTabbedPane, Region.TABBED_PANE), 0);
            }
            JYTabbedPanePainter.getInstance(synthContext).paintTabbedPaneTab(jYTabbedPane, syntheticaState, n7, n2, n3, n4, graphics, 0, 0, n5, n6);
        }
    }

    public static class CloseTabAction
    extends AbstractAction {
        private static final long serialVersionUID = -5930144793277991373L;

        public CloseTabAction() {
            this.putValue("ShortDescription", UIManager.get("JYTabbedPane.closeButton.toolTip"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            Tab tab = (Tab)abstractButton.getParent().getParent();
            tab.getTabbedPane().removeTabAt(tab.getTabIndex());
        }
    }

    static class SelectNextTabAction
    extends AbstractAction {
        private static final long serialVersionUID = -3862735253975360860L;

        SelectNextTabAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JYTabbedPane jYTabbedPane = ((Tab)actionEvent.getSource()).getTabbedPane();
            boolean bl = jYTabbedPane.getComponentOrientation().isLeftToRight();
            boolean bl2 = jYTabbedPane.getTabPlacement() == 2 || jYTabbedPane.getTabPlacement() == 4;
            Action action = jYTabbedPane.getActionMap().get(bl || bl2 ? "navigateNext" : "navigatePrevious");
            action.actionPerformed(new ActionEvent(jYTabbedPane, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
        }
    }

    static class SelectPreviousTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 5033780496276748010L;

        SelectPreviousTabAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JYTabbedPane jYTabbedPane = ((Tab)actionEvent.getSource()).getTabbedPane();
            boolean bl = jYTabbedPane.getComponentOrientation().isLeftToRight();
            boolean bl2 = jYTabbedPane.getTabPlacement() == 2 || jYTabbedPane.getTabPlacement() == 4;
            Action action = jYTabbedPane.getActionMap().get(bl || bl2 ? "navigatePrevious" : "navigateNext");
            action.actionPerformed(new ActionEvent(jYTabbedPane, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
        }
    }
}

