/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableCellRenderer<T extends JComponent>
extends JLabel
implements TableCellRenderer {
    protected TableCellRenderer delegate;
    protected T rendererComponent;
    private Color arrowForegroundSelected;
    private Color arrowForeground;

    public AbstractTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.delegate = tableCellRenderer;
        this.arrowForegroundSelected = UIManager.getColor("Synthetica.table.cellRenderer.selected.arrowButton.foreground");
        this.arrowForeground = UIManager.getColor("Synthetica.table.cellRenderer.arrowButton.foreground");
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        this.rendererComponent = this.createRendererComponent();
        this.add((Component)this.rendererComponent);
    }

    protected abstract T createRendererComponent();

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = (JComponent)this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.setBorder(jComponent.getBorder());
        this.setOpaque(jComponent.isOpaque());
        this.setBackground(jComponent.getBackground());
        this.setValue(this.rendererComponent, object);
        this.configureRendererComponent(this.rendererComponent, jComponent, jTable, object, bl, bl2, n, n2);
        return this;
    }

    protected abstract void setValue(T var1, Object var2);

    protected void configureRendererComponent(T t, JComponent jComponent, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ((JComponent)t).setForeground(new Color(jComponent.getForeground().getRGB()));
        ((JComponent)t).putClientProperty("Synthetica.table.cellRenderer.arrowButton.foreground", bl ? this.arrowForegroundSelected : this.arrowForeground);
    }
}

