unit undebfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, dpkg_deb;

type
  TForm1 = class(TForm)
    ListView1: TListView;
    Button1: TButton;
    Edit1: TEdit;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListView1DblClick(Sender: TObject);
  private
    { Private declarations }
    DebPkg: TDebianPackage;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
uses
   filectrl;

procedure TForm1.Button1Click(Sender: TObject);
var
    lvi: TListItem;
    i: integer;
begin
    if OpenDialog1.Execute then
    begin
        Edit1.Text := OpenDialog1.FileName;
        if DebPkg.ReadFromFile(OpenDialog1.FileName)>1 then
        begin
            ListView1.Items.Clear;
            //member 0 is ignored
            for i:=1 to High(DebPkg.FMemberList) do
            begin
                 lvi := ListView1.Items.Add;
                 with DebPkg.FMemberList[i] do
                 begin
	                 lvi.Caption := trim(ar_name);
    	             lvi.SubItems.Add(ar_date);
                     lvi.SubItems.Add(ar_uid);
                     lvi.Subitems.Add(ar_gid);
                     lvi.Subitems.Add(ar_mode);
                     lvi.Subitems.Add(ar_size);
                     lvi.Subitems.Add(ar_fmag);
                     //DebPkg.ExtractMemberToFile(i, ExtractFilePath(Application.ExeName)+Trim(ar_name));
	                 (*if Trim(ar_name)='data.tar.gz' then
    	                 DebPkg.ExtractMemberToFile(i,
                     	ExtractFilePath(Application.ExeName)
                        + ChangeFileExt(ExtractFileName(OpenDialog1.FileName), '.tar.gz')); *)
                    
                 end;
            end;
        end;
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    DebPkg := TDebianPackage.Create;
    DebPkg.CheckHeader := true;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    DebPkg.Free;
end;

//test use deb_io implemented by filehandle
procedure TForm1.ListView1DblClick(Sender: TObject);
begin
  if ListView1.Selected<>nil then
  begin
    SaveDialog1.FileName := ListView1.Selected.Caption;
    if SaveDialog1.Execute then
          if ListView1.Selected.Caption='control.tar.gz' then
            DebPkg.ExtractMemberToFile(1, SaveDialog1.FileName)
          else
            DebPkg.ExtractMemberToFile(2, SaveDialog1.FileName)
  end;
end;

end.
