/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.Activation.InvalidPath;
import com.visigenic.vbroker.Activation.OAD;
import com.visigenic.vbroker.activationImpl.ExecForwarder;
import com.visigenic.vbroker.activationImpl.ExecPrinterThread;
import com.visigenic.vbroker.activationImpl.Forwarder;
import com.visigenic.vbroker.activationImpl.ForwarderFactory;
import com.visigenic.vbroker.activationImpl.OADImpl;
import com.visigenic.vbroker.extension.CreationImplDef;
import java.io.File;
import org.omg.CORBA.BOA;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;

class ExecForwarderFactory
extends ForwarderFactory {
    private ExecPrinterThread _printerThread;
    private OADImpl _oad;
    private BOA _boa;
    private boolean _verbose;
    private boolean _destroy_on_removal;
    private boolean _quoteStringsWithSpaces;
    private int _uidCounter;

    ExecForwarderFactory(BOA bOA, OADImpl oADImpl, boolean bl) {
        this._boa = bOA;
        this._oad = oADImpl;
        this._verbose = bl;
        this._printerThread = null;
        this._destroy_on_removal = false;
        this._uidCounter = 0;
        String string = System.getProperty("OADquoteSpaces");
        this._quoteStringsWithSpaces = string != null && !string.toLowerCase().equals("false");
    }

    synchronized ExecPrinterThread printerThread() {
        if (this._printerThread == null) {
            this._printerThread = new ExecPrinterThread(this._verbose);
        }
        return this._printerThread;
    }

    public Forwarder createForwarder(CreationImplDef creationImplDef) throws InvalidPath {
        java.lang.Object object;
        if (this._oad.verify_registration()) {
            if (creationImplDef.path_name().startsWith("vbj")) {
                if (!creationImplDef.args()[0].startsWith("-")) {
                    try {
                        if (this._verbose) {
                            System.out.println("Verifying classname [" + creationImplDef.args()[0] + "]");
                        }
                        Class.forName(creationImplDef.args()[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidPath();
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        throw new InvalidPath();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new InvalidPath();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new INTERNAL("Expected classname not found in slot 0 of argument list");
                    }
                }
            } else {
                object = new File(creationImplDef.path_name());
                if (!((File)object).isFile()) {
                    throw new InvalidPath();
                }
            }
        }
        object = new ExecForwarder(creationImplDef, this, this._verbose, this._quoteStringsWithSpaces);
        this.boa().obj_is_ready((Object)object);
        return object;
    }

    public synchronized OAD oad() {
        return this._oad;
    }

    public synchronized BOA boa() {
        return this._boa;
    }

    public synchronized int timeout() {
        return this._oad.Timeout();
    }

    public synchronized void destroy_on_removal(boolean bl) {
        this._destroy_on_removal = bl;
    }

    public synchronized boolean destroy_on_removal() {
        return this._destroy_on_removal;
    }

    public synchronized int nextUID() {
        ++this._uidCounter;
        if (this._uidCounter == 0) {
            ++this._uidCounter;
        }
        return this._uidCounter;
    }
}

