/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.ds.DSAMessage;
import com.visigenic.vbroker.ds.IStream;
import com.visigenic.vbroker.ds.OStream;
import org.omg.CORBA.MARSHAL;

public class DSAReply
extends DSAMessage {
    private static final int VERSION_MISMATCH = -100;
    private static final int TIME_OUT = -99;
    private static final int FAIL = -98;
    private static final int NO_MORE_LICENSES = -97;
    private static final int SUCCESS = 0;
    static final int REPLY_ACK = 1;
    static final int REPLY_ARE_YOU_ALIVE = 2;
    static final int REPLY_GET_PROVIDER = 3;
    static final int REPLY_NEW_PROVIDER = 4;
    static final int REPLY_GET_CLIENT_HANDLER_ADDR = 5;
    static final int REPLY_NO_MORE_LICENSES = 6;
    static final int REPLY_UNKNOWN_REQ = 7;
    static final int REPLY_GET_TCP_HANDLER_ADDR = 8;
    private static final String[] _replyTypeString = new String[]{null, "REPLY_ACK", "REPLY_ARE_YOU_ALIVE", "REPLY_GET_PROVIDER", "REPLY_NEW_PROVIDER", "REPLY_GET_CLIENT_HANDLER_ADDR", "REPLY_NO_MORE_LICENSES", "REPLY_UNKNOWN_REQ", "REPLY_GET_TCP_HANDLER_ADDR"};
    private int _replyType;
    private int _requestNumber;
    private int _status;

    DSAReply() {
    }

    public void read(IStream iStream) {
        super.read(iStream);
        this._replyType = iStream.read_int();
        if (this._replyType < 1 || this._replyType > 8) {
            throw new MARSHAL();
        }
        this._requestNumber = iStream.read_int();
        this._status = iStream.read_int();
    }

    public void write(OStream oStream) {
        super.write(oStream);
        oStream.write_int(this._replyType);
        oStream.write_int(this._requestNumber);
        oStream.write_int(this._status);
    }

    boolean ok() {
        return this._status == 0;
    }

    int replyType() {
        return this._replyType;
    }

    int requestNumber() {
        return this._requestNumber;
    }

    public String toString() {
        String string = "DSAReply[super=" + super.toString() + ", replyType=" + _replyTypeString[this._replyType] + ", requestNumber=" + this._requestNumber + ", status=";
        switch (this._status) {
            case -100: {
                string = String.valueOf(string) + "VERSION_MISMATCH";
                break;
            }
            case -99: {
                string = String.valueOf(string) + "TIME_OUT";
                break;
            }
            case -98: {
                string = String.valueOf(string) + "FAIL";
                break;
            }
            case -97: {
                string = String.valueOf(string) + "NO_MORE_LICENSES";
                break;
            }
            case 0: {
                string = String.valueOf(string) + "SUCCESS";
                break;
            }
            default: {
                string = String.valueOf(string) + "<invalid status: " + this._status + ">";
            }
        }
        return String.valueOf(string) + "]";
    }
}

