/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.ds.DSResource;
import com.visigenic.vbroker.ds.IStream;
import com.visigenic.vbroker.ds.OStream;
import com.visigenic.vbroker.orb.ORB;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;

class DSAddr
implements DSResource {
    private int _inetNumber;
    private int _portNumber;
    private String _hostName;
    private InetAddress _inetAddress;

    DSAddr(String string, int n) {
        byte[] byArray = this.getAddress(string).getAddress();
        if (byArray.length != 4) {
            throw new INTERNAL();
        }
        this._inetNumber = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        this._portNumber = n;
    }

    DSAddr() {
    }

    DSAddr(IStream iStream) {
        this.read(iStream);
    }

    public void read(IStream iStream) {
        this._inetNumber = iStream.read_int();
        this._portNumber = iStream.read_int();
    }

    public void write(OStream oStream) {
        oStream.write_int(this._inetNumber);
        oStream.write_int(this._portNumber);
    }

    private InetAddress getAddress(String string) {
        String string2 = string.toLowerCase();
        try {
            return InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new INITIALIZE("\nWARNING:\n    The host \"" + string2 + "\" could not be resolved by\n" + "    java.net.InetAddress.getByName.  This may be due to a bug in\n" + "    the JDK version 1.0.X.  Please specify the \"OSAGENT_ADDR\"\n" + "    parameter in a different form (i.e., as a host name, not as\n" + "    numeric IP address).\n" + "    Exception: " + unknownHostException);
        }
    }

    String hostName() {
        if (this._hostName == null) {
            byte[] byArray = new byte[]{(byte)(this._inetNumber >> 24), (byte)(this._inetNumber >> 16), (byte)(this._inetNumber >> 8), (byte)this._inetNumber};
            this._hostName = ORB.inetAddressBytesToString(byArray);
        }
        return this._hostName;
    }

    InetAddress inetAddress() {
        if (this._inetAddress == null) {
            this._inetAddress = this.getAddress(this.hostName());
        }
        return this._inetAddress;
    }

    int portNumber() {
        return this._portNumber;
    }

    public String toString() {
        String string = "DSAddr[hostName=" + this.hostName() + ", portNumber=" + this._portNumber + "]";
        return string;
    }
}

