/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.ds.DSAddr;
import com.visigenic.vbroker.ds.DSName;
import com.visigenic.vbroker.ds.DSResource;
import com.visigenic.vbroker.ds.IStream;
import com.visigenic.vbroker.ds.OStream;

class DSProvider
implements DSResource {
    private static int DSPROV_TCP;
    private static int DSPROV_UDP;
    private DSName _name;
    private DSAddr _addr;
    private DSAddr _clientAddr;
    private DSAddr _agentAddr;
    private int _protocol;
    private int _adminPort;

    DSProvider(String string, DSAddr dSAddr, DSAddr dSAddr2, DSAddr dSAddr3, int n) {
        this._name = new DSName(string);
        this._addr = dSAddr;
        this._clientAddr = dSAddr2;
        this._agentAddr = dSAddr3;
        this._protocol = DSPROV_UDP;
        this._adminPort = n;
    }

    DSProvider(DSName dSName, DSAddr dSAddr, DSAddr dSAddr2, DSAddr dSAddr3, int n) {
        this._name = dSName;
        this._addr = dSAddr;
        this._clientAddr = dSAddr2;
        this._agentAddr = dSAddr3;
        this._protocol = DSPROV_UDP;
        this._adminPort = n;
    }

    DSProvider() {
    }

    public void read(IStream iStream) {
        this._name = new DSName(iStream);
        this._addr = new DSAddr(iStream);
        this._clientAddr = new DSAddr(iStream);
        this._agentAddr = new DSAddr(iStream);
        this._protocol = iStream.read_int();
        this._adminPort = iStream.read_int();
    }

    public void write(OStream oStream) {
        this._name.write(oStream);
        this._addr.write(oStream);
        this._clientAddr.write(oStream);
        this._agentAddr.write(oStream);
        oStream.write_int(this._protocol);
        oStream.write_int(this._adminPort);
    }

    DSAddr addr() {
        return this._addr;
    }

    DSAddr agentAddr() {
        return this._agentAddr;
    }

    public DSName name() {
        return this._name;
    }

    public String toString() {
        String string = "DSProvider[name=" + this._name + ", addr=" + this._addr + ", clientAddr=" + this._clientAddr + ", agentAddr=" + this._agentAddr + ", protocol=" + this._protocol + ", adminPort=" + this._adminPort + "]";
        return string;
    }

    static {
        DSPROV_UDP = 1;
    }
}

