/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.ds.DSMessage;
import com.visigenic.vbroker.ds.DSRequest;
import com.visigenic.vbroker.ds.DSResource;
import com.visigenic.vbroker.ds.IStream;
import com.visigenic.vbroker.ds.OStream;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;

class DSReply
extends DSMessage {
    private static final int VERSION_MISMATCH = -100;
    private static final int UNAUTHORIZED_USER = -99;
    private static final int ALREADY_LOGGED_IN = -98;
    private static final int NOT_LOGGED_IN = -97;
    private static final int TIME_OUT = -96;
    private static final int FAIL = -95;
    private static final int SUCCESS = 0;
    static final int REPLY_ACK = 1;
    static final int REPLY_LOGIN = 2;
    static final int REPLY_LOGOUT = 3;
    static final int REPLY_ARE_YOU_ALIVE = 4;
    static final int REPLY_GET_PROVIDER = 5;
    static final int REPLY_TRIGGER_SERVICE = 6;
    static final int REPLY_REGISTER_SERVICE = 7;
    static final int REPLY_UNREGISTER_SERVICE = 8;
    static final int REPLY_REMOVE_TRIGGER = 9;
    static final int REPLY_ALL_AGENT_ADDRESSES = 10;
    static final int REPLY_ALL_PROVIDERS = 11;
    static final int REPLY_CLOSE = 12;
    static final int REPLY_ALL_NAMES = 13;
    static final int REPLY_NO_MORE_LICENSES = 14;
    static final int REPLY_UNKNOWN_REQ = 15;
    private static final String[] _replyTypeString = new String[]{null, "REPLY_ACK", "REPLY_LOGIN", "REPLY_LOGOUT", "REPLY_ARE_YOU_ALIVE", "REPLY_GET_PROVIDER", "REPLY_TRIGGER_SERVICE", "REPLY_REGISTER_SERVICE", "REPLY_UNREGISTER_SERVICE", "REPLY_REMOVE_TRIGGER", "REPLY_ALL_AGENT_ADDRESSES", "REPLY_ALL_PROVIDERS", "REPLY_CLOSE", "REPLY_ALL_NAMES", "REPLY_NO_MORE_LICENSES", "REPLY_UNKNOWN_REQ"};
    private int _replyType;
    private int _requestNumber;
    private int _status;
    private DSResource _reply;

    DSReply(DSRequest dSRequest) {
        super(2);
        switch (dSRequest.requestType()) {
            case 2: {
                this._replyType = 4;
                break;
            }
            case 10: {
                this._replyType = 12;
                break;
            }
            default: {
                throw new INTERNAL("Could not handle request: " + dSRequest);
            }
        }
        this._requestNumber = dSRequest.messageNumber();
        this._status = 0;
    }

    DSReply() {
    }

    public void read(IStream iStream) {
        super.read(iStream);
        this._replyType = iStream.read_int();
        if (this._replyType < 1 || this._replyType > 15) {
            throw new MARSHAL("Illegal reply type: " + this._replyType);
        }
        this._requestNumber = iStream.read_int();
        this._status = iStream.read_int();
        this._reply = iStream.read_Resource();
    }

    public void write(OStream oStream) {
        super.write(oStream);
        oStream.write_int(this._replyType);
        oStream.write_int(this._requestNumber);
        oStream.write_int(this._status);
        oStream.write_Resource(this._reply);
    }

    boolean ok() {
        return this._status == 0;
    }

    int replyType() {
        return this._replyType;
    }

    int requestNumber() {
        return this._requestNumber;
    }

    DSResource reply() {
        return this._reply;
    }

    public String toString() {
        String string = "DSReply[super=" + super.toString() + ", replyType=" + _replyTypeString[this._replyType] + ", requestNumber=" + this._requestNumber + ", status=";
        switch (this._status) {
            case -100: {
                string = String.valueOf(string) + "VERSION_MISMATCH";
                break;
            }
            case -99: {
                string = String.valueOf(string) + "UNAUTHORIZED_USER";
                break;
            }
            case -98: {
                string = String.valueOf(string) + "ALREADY_LOGGED_IN";
                break;
            }
            case -97: {
                string = String.valueOf(string) + "NOT_LOGGED_IN";
                break;
            }
            case -96: {
                string = String.valueOf(string) + "TIME_OUT";
                break;
            }
            case -95: {
                string = String.valueOf(string) + "FAIL";
                break;
            }
            case 0: {
                string = String.valueOf(string) + "SUCCESS";
                break;
            }
            default: {
                string = String.valueOf(string) + "<invalid status: " + this._status + ">";
            }
        }
        return String.valueOf(string) + ", reply=" + this._reply + "]";
    }
}

