/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.LIOP.ProfileBody;
import com.visigenic.vbroker.LIOP.ProfileBodyHelper;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.Delegate;
import com.visigenic.vbroker.orb.GiopConnectionFactory;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.LiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.ProtocolAdapter;
import com.visigenic.vbroker.orb.ProtocolManager;
import java.util.Enumeration;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;

public class LiopProtocolImpl
implements ProtocolManager.Profile,
LiopProtocol,
OrbObject {
    private ORB _orb;
    private int LIOP_TAG = 1447645953;

    public void init(ORB oRB, java.lang.Object[] objectArray) {
        this._orb = oRB;
    }

    public boolean supports(IOR iOR) {
        int n = 0;
        while (n < iOR.profiles.length) {
            if (iOR.profiles[n].tag == this.LIOP_TAG) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean supports(int n) {
        return n == this.LIOP_TAG;
    }

    public void addComponent(int n, ProtocolManager.Profile.Component component) {
        throw new NO_IMPLEMENT("Does not implement addComponent");
    }

    public ProtocolManager.Profile.Component removeComponent(int n) {
        throw new NO_IMPLEMENT("Does not implement removeComponent");
    }

    public Enumeration components() {
        throw new NO_IMPLEMENT("Does not implement components");
    }

    public ProtocolManager.Protocol getProtocol(TaggedProfile taggedProfile) {
        ProfileBody profileBody = this.profileBody(taggedProfile);
        if (profileBody.liop_version.major != 1) {
            throw new INV_OBJREF("Unsupported LIOP major version: " + profileBody.liop_version.major);
        }
        if (profileBody.liop_version.minor == 1) {
            return this;
        }
        throw new INV_OBJREF("Unknown LIOP version: " + profileBody.liop_version);
    }

    public Delegate createStubDelegate(Object object, IOR iOR) {
        java.lang.Object[] objectArray = new java.lang.Object[]{iOR, object, this};
        return (Delegate)this._orb.create(1, objectArray);
    }

    public ProtocolAdapter createProtocolAdapter(Adapter adapter) {
        throw new NO_IMPLEMENT("Does not implement createProtocolAdapter");
    }

    public GiopConnectionFactory giopConnectionFactory() {
        throw new NO_IMPLEMENT("Does not implement giopConnectionFactory");
    }

    public ConnectionFactory connectionFactory() {
        throw new NO_IMPLEMENT("Does not implement connectionFactory");
    }

    public ProfileBody profileBody(TaggedProfile taggedProfile) {
        if (taggedProfile.tag != this.LIOP_TAG) {
            throw new BAD_PARAM("Invalid tagged profile: " + taggedProfile);
        }
        GiopInputStream giopInputStream = this._orb.newGiopInputStream(taggedProfile.profile_data);
        giopInputStream.byteOrder(giopInputStream.read_boolean());
        return ProfileBodyHelper.read(giopInputStream);
    }

    public TaggedProfile taggedProfile(ProfileBody profileBody) {
        GiopOutputStream giopOutputStream = this._orb.newGiopOutputStream();
        giopOutputStream.byteOrder(false);
        giopOutputStream.write_boolean(false);
        ProfileBodyHelper.write(giopOutputStream, profileBody);
        byte[] byArray = giopOutputStream.toByteArray();
        TaggedProfile taggedProfile = new TaggedProfile(this.LIOP_TAG, byArray);
        return taggedProfile;
    }

    public byte[] objectKey(TaggedProfile taggedProfile) {
        return this.profileBody((TaggedProfile)taggedProfile).object_key;
    }

    public String prettyPrint(TaggedProfile taggedProfile) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        ProfileBody profileBody = this.profileBody(taggedProfile);
        stringBuffer.append("LIOP Profile:" + string);
        stringBuffer.append("    version: " + profileBody.liop_version.major + "." + profileBody.liop_version.minor + string);
        stringBuffer.append("    host: " + profileBody.host + string);
        stringBuffer.append("    pid: " + profileBody.pid + string);
        stringBuffer.append("    unique_id: " + profileBody.unique_id + string);
        stringBuffer.append("    Object Key: " + this._orb.toObjectId(profileBody.object_key) + string);
        return stringBuffer.toString();
    }
}

