/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.ProtocolManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class ProtocolManagerImpl
implements ProtocolManager,
OrbObject {
    private ORB _orb;
    private Hashtable _profiles = new Hashtable();

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        this._profiles.put(new Integer(0), this._orb.create(26));
    }

    public void addProfile(int n, ProtocolManager.Profile profile) {
        this._profiles.put(new Integer(n), profile);
    }

    public ProtocolManager.Profile removeProfile(int n) {
        return (ProtocolManager.Profile)this._profiles.remove(new Integer(n));
    }

    public ProtocolManager.Profile profile(IOR iOR) {
        int n = 0;
        while (n < iOR.profiles.length) {
            ProtocolManager.Profile profile = this.profile(iOR.profiles[n].tag);
            if (profile != null) {
                return profile;
            }
            ++n;
        }
        return null;
    }

    public ProtocolManager.Profile profile(int n) {
        return (ProtocolManager.Profile)this._profiles.get(new Integer(n));
    }

    public Enumeration allProfiles() {
        return this._profiles.elements();
    }

    public boolean supports(int n) {
        return this._profiles.containsKey(new Integer(n));
    }

    public boolean supports(IOR iOR) {
        return this.profile(iOR) != null;
    }

    public ProtocolManager.Protocol getProtocol(IOR iOR) {
        int n = 0;
        while (n < iOR.profiles.length) {
            ProtocolManager.Protocol protocol = this.getProtocol(iOR.profiles[n]);
            if (protocol != null) {
                return protocol;
            }
            ++n;
        }
        return null;
    }

    public ProtocolManager.Protocol getProtocol(TaggedProfile taggedProfile) {
        ProtocolManager.Profile profile = this.profile(taggedProfile.tag);
        if (profile != null) {
            return profile.getProtocol(taggedProfile);
        }
        return null;
    }

    public String prettyPrint(IOR iOR) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Interoperable Object Reference:" + string);
        stringBuffer.append("  Type ID: " + iOR.type_id + string);
        stringBuffer.append("  Contains " + iOR.profiles.length + (iOR.profiles.length == 1 ? " profile." : " profiles.") + string);
        int n = 0;
        while (n < iOR.profiles.length) {
            stringBuffer.append("  Profile " + n + "-");
            ProtocolManager.Profile profile = this.profile(iOR.profiles[n].tag);
            if (profile == null) {
                stringBuffer.append("Unknown profile:" + string + iOR.profiles[n] + string);
            } else {
                stringBuffer.append(profile.prettyPrint(iOR.profiles[n]));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

