/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.BaseSocket;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.ProtocolManager;
import java.io.IOException;
import java.net.ServerSocket;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;

public class TcpListener
implements ConnectionFactory.Listener,
OrbObject {
    protected ServerSocket _serverSocket;
    protected TaggedProfile _endpoint;
    protected ConnectionFactory _factory;
    protected IiopProtocol _protocol;
    protected ORB _orb;

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        this._factory = (ConnectionFactory)objectArray[0];
        TaggedProfile taggedProfile = (TaggedProfile)objectArray[1];
        ProtocolManager.Protocol protocol = this._orb.protocolManager().getProtocol(taggedProfile);
        if (!(protocol instanceof IiopProtocol)) {
            throw new INTERNAL();
        }
        this._protocol = (IiopProtocol)protocol;
        ProfileBody profileBody = this._protocol.profileBody(taggedProfile);
        int n = this._protocol.port(profileBody);
        try {
            this._serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            throw new INITIALIZE(iOException.toString());
        }
        profileBody.host = this._orb.getLocalHost();
        profileBody.port = (short)this._serverSocket.getLocalPort();
        this._endpoint = this._protocol.taggedProfile(profileBody);
    }

    public Connection accept() {
        BaseSocket baseSocket = (BaseSocket)this._orb.create(19);
        baseSocket.doAccept(this._serverSocket);
        Object[] objectArray = new Object[]{this._protocol, baseSocket, this._factory};
        return (Connection)this._orb.create(27, objectArray);
    }

    public TaggedProfile listenEndpoint() {
        return this._endpoint;
    }

    public void destroy() {
        try {
            this._serverSocket.close();
            return;
        }
        catch (Exception exception) {
            throw new COMM_FAILURE(exception.toString());
        }
    }

    public String toString() {
        return "TcpListener[socket=" + this._serverSocket + "]";
    }
}

