/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util;

import com.visigenic.vbroker.util.Property;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;

public class PropertyManager
extends Observable {
    protected Hashtable _properties = new Hashtable();
    protected static final String READONLY = "r";
    protected static final String READWRITE = "rw";

    protected PropertyManager() {
    }

    protected PropertyManager(String[][] stringArray, Properties properties) {
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = stringArray[n][2] == READONLY;
            String string = stringArray[n][0];
            String string2 = stringArray[n][1];
            if (properties != null) {
                this._properties.put(string, new Property(properties.getProperty(string, string2), bl));
            } else {
                this._properties.put(string, new Property(string2, bl));
            }
            ++n;
        }
    }

    public synchronized void setProperty(String string, String string2) {
        if (!this._properties.containsKey(string)) {
            throw new BAD_PARAM("Unknown property " + string);
        }
        Property property = (Property)this._properties.get(string);
        property.setValue(string2);
        this.setChanged();
        this.notifyObservers(string);
    }

    public boolean getPropertyReadOnly(String string) {
        if (!this._properties.containsKey(string)) {
            throw new BAD_PARAM(string);
        }
        Property property = (Property)this._properties.get(string);
        return property.readOnly();
    }

    public int getNumProperties() {
        return this._properties.size();
    }

    public Enumeration getProperties() {
        return this._properties.keys();
    }

    public String getString(String string) {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            throw new BAD_PARAM("Unknown Property: " + string);
        }
        return property.value();
    }

    public int getInt(String string) {
        String string2 = this.getString(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        try {
            String string2 = this.getString(string);
            if (string2 == null) {
                return bl;
            }
            return !string2.toLowerCase().equals("false");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return bl;
        }
    }
}

