/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedWriter;
import java.io.Reader;

public class PipedReader
extends Reader {
    PipedInputStream byteSink = new PipedInputStream();
    private byte[] buf;
    private int leftOver;

    public PipedReader() {
        this.lock = this.byteSink;
    }

    public PipedReader(PipedWriter pipedWriter) throws IOException {
        this();
        this.connect(pipedWriter);
    }

    private void ensureOpen() throws IOException {
        if (this.byteSink == null) {
            throw new IOException("Stream closed");
        }
    }

    public void connect(PipedWriter pipedWriter) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            pipedWriter.connect(this);
            return;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            this.ensureOpen();
            int n4 = this.leftOver + n2 * 2;
            if (this.buf == null || this.buf.length < n4) {
                this.buf = new byte[n4];
            }
            if ((n3 = this.byteSink.read(this.buf, this.leftOver, n4)) < 0) {
                int n5 = -1;
                Object var6_9 = null;
                return n5;
            }
            n3 += this.leftOver;
            int n6 = 0;
            while (n6 < n3) {
                cArray[n6 >> 1] = (char)((this.buf[n6] & 0xFF) << 8 | this.buf[n6 + 1] & 0xFF);
                n6 += 2;
            }
            if (n3 % 2 != 0) {
                this.buf[0] = this.buf[n3 - 1];
                this.leftOver = 1;
            } else {
                this.leftOver = 0;
            }
            int n7 = n3 / 2;
            Object var6_10 = null;
            return n7;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.byteSink == null) {
                Object var2_2 = null;
                return;
            }
            this.byteSink.close();
            this.byteSink = null;
            return;
        }
    }
}

