/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    protected Object lock;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object object) {
        this.lock = object;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) == -1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public long skip(long l) throws IOException {
        int n = (int)Math.min(l, 8192L);
        Object object = this.lock;
        synchronized (object) {
            if (this.skipBuffer == null || this.skipBuffer.length < n) {
                this.skipBuffer = new char[n];
            }
            long l2 = l;
            while (l2 > 0L) {
                int n2 = this.read(this.skipBuffer, 0, n);
                if (n2 == -1) break;
                l2 -= (long)n2;
            }
            long l3 = l - l2;
            Object var7_7 = null;
            return l3;
        }
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark() not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    public abstract void close() throws IOException;
}

