/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class URL
implements Serializable {
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private String ref;
    transient URLStreamHandler handler;
    private int hashCode = -1;
    static URLStreamHandlerFactory factory;
    static Hashtable handlers;

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        int n2 = string3.indexOf(35);
        this.file = n2 < 0 ? string3 : string3.substring(0, n2);
        this.ref = n2 < 0 ? null : string3.substring(n2 + 1);
        this.handler = URL.getURLStreamHandler(string);
        if (this.handler == null) {
            throw new MalformedURLException("unknown protocol: " + string);
        }
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3);
    }

    public URL(String string) throws MalformedURLException {
        this(null, string);
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        String string2 = string;
        int n = 0;
        String string3 = null;
        boolean bl = false;
        try {
            char c;
            int n2 = string.length();
            while (n2 > 0 && string.charAt(n2 - 1) <= ' ') {
                --n2;
            }
            while (n < n2 && string.charAt(n) <= ' ') {
                ++n;
            }
            if (string.regionMatches(true, n, "url:", 0, 4)) {
                n += 4;
            }
            if (n < string.length() && string.charAt(n) == '#') {
                bl = true;
            }
            int n3 = n;
            while (!bl && n3 < n2 && (c = string.charAt(n3)) != '/') {
                if (c == ':') {
                    string3 = string.substring(n, n3).toLowerCase();
                    n = n3 + 1;
                    break;
                }
                ++n3;
            }
            if (uRL != null && (string3 == null || string3.equals(uRL.protocol))) {
                this.protocol = uRL.protocol;
                this.host = uRL.host;
                this.port = uRL.port;
                this.file = uRL.file;
            } else {
                this.protocol = string3;
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + string2);
            }
            this.handler = URL.getURLStreamHandler(this.protocol);
            if (this.handler == null) {
                throw new MalformedURLException("unknown protocol: " + this.protocol);
            }
            n3 = string.indexOf(35, n);
            if (n3 >= 0) {
                this.ref = string.substring(n3 + 1, n2);
                n2 = n3;
            }
            this.handler.parseURL(this, string, n, n2);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (Exception exception) {
            throw new MalformedURLException(String.valueOf(string2) + ": " + exception);
        }
    }

    protected void set(String string, String string2, int n, String string3, String string4) {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        this.file = string3;
        this.ref = string4;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (this.ref == null) {
            return object instanceof URL && this.sameFile((URL)object);
        }
        return object instanceof URL && this.sameFile((URL)object) && this.ref.equals(((URL)object).ref);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.host.toLowerCase().hashCode() ^ this.file.hashCode() ^ this.protocol.hashCode();
        }
        return this.hashCode;
    }

    boolean hostsEqual(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            return inetAddress.equals(inetAddress2);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {}
        return false;
    }

    public boolean sameFile(URL uRL) {
        return this.protocol.equals(uRL.protocol) && this.hostsEqual(this.host, uRL.host) && this.port == uRL.port && this.file.equals(uRL.file);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = uRLStreamHandlerFactory;
    }

    static synchronized URLStreamHandler getURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler = (URLStreamHandler)handlers.get(string);
        if (uRLStreamHandler == null) {
            if (factory != null) {
                uRLStreamHandler = factory.createURLStreamHandler(string);
            }
            if (uRLStreamHandler == null) {
                String string2 = System.getProperty(protocolPathProp, "");
                if (string2 != "") {
                    string2 = String.valueOf(string2) + "|";
                }
                string2 = String.valueOf(string2) + "sun.net.www.protocol";
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                while (uRLStreamHandler == null && stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    try {
                        String string4 = String.valueOf(string3) + "." + string + ".Handler";
                        uRLStreamHandler = (URLStreamHandler)Class.forName(string4).newInstance();
                    }
                    catch (Exception exception) {}
                }
            }
            if (uRLStreamHandler != null) {
                handlers.put(string, uRLStreamHandler);
            }
        }
        return uRLStreamHandler;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.handler = URL.getURLStreamHandler(this.protocol);
        if (this.handler == null) {
            throw new IOException("unknown protocol: " + this.protocol);
        }
    }

    static {
        handlers = new Hashtable();
    }
}

