/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.text.CharacterBreakData;
import java.text.CharacterIterator;
import java.text.LineBreakData;
import java.text.SentenceBreakData;
import java.text.SimpleTextBoundary;
import java.text.StringCharacterIterator;
import java.text.WordBreakData;
import java.text.resources.LocaleData;
import java.util.Locale;

public abstract class BreakIterator
implements Cloneable,
Serializable {
    public static final int DONE = -1;

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    public abstract int current();

    public abstract CharacterIterator getText();

    public void setText(String string) {
        this.setText(new StringCharacterIterator(string));
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale locale) {
        return new SimpleTextBoundary(new WordBreakData());
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale locale) {
        return new SimpleTextBoundary(new LineBreakData());
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        return new SimpleTextBoundary(new CharacterBreakData());
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        return new SimpleTextBoundary(new SentenceBreakData());
    }

    public static synchronized Locale[] getAvailableLocales() {
        return LocaleData.getAvailableLocales("NumberPatterns");
    }
}

